<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_mcp_request extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucuri = '';
public $sucmsg = '';

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','mcp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_head('{:user_request}');

    if ( !XF::$tpl->is_cached('mcp_request.tpl') ){
    $pp = XFUI::get_post_prefix_list();
    $group = XF::get_group('*');
    $srpp = XF::sql_query("SELECT ur_time,p_id,p_u_id,p_time,p_pp_id,p_subject FROM ".XF::tbl('user_request')."
    LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = ".XF::tbl('user_request').".ur_data_int
    WHERE ur_class = 'REPORT_POSTING'",'',__METHOD__,__LINE__);
    $reported_post = array();
      while ( $r = $srpp->fetchObject() ){
      $r->p_id = intval($r->p_id);
      $r->p_subject = ( isset($pp[$r->p_pp_id]) ) ? '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject : $r->p_subject;
      $u = XF::get_user($r->p_u_id);
      $r->u_name = $u['u_name'];
      $reported_post[$r->p_id] = (array)$r;
      $reported_post[$r->p_id]['g_name'] = $group[$u['u_group']]['g_name'];
      $reported_post[$r->p_id]['g_color'] = $group[$u['u_group']]['g_color'];
      }
    $srpp->closeCursor();

    $lpr = array();
    $pp = XFUI::get_post_prefix_list(true);
    $cg = XF::vault_query('current_group_id');
      foreach ( $pp as $k=>$v ){
        if ( !$v['pp_list_as_request'] )
        unset($pp[$k]);
      }
    $ppi = array_keys($pp);
    $ru = ( $group[$cg]['g_read_unapproved'] ) ? '' : 'AND p_approved = true';
    $slpr = XF::sql_query("SELECT p_id,p_u_id,p_pp_id,p_time,p_subject FROM ".XF::tbl('post_meta')."
    WHERE p_pp_id IN (".implode(',',$ppi).") AND p_closed = false $ru ORDER BY p_weight DESC, p_time DESC",'',__METHOD__,__LINE__);
      while ( $r = $slpr->fetchObject() ){
      $u = XF::get_user($r->p_u_id);
      $r->p_subject = '['.$pp[$r->p_pp_id]['pp_name'].'] '.$r->p_subject;
      $r->u_name = $u['u_name'];
      $r->g_name = $group[$u['u_group']]['g_name'];
      $r->g_color = $group[$u['u_group']]['g_color'];
      $lpr[] = (array)$r;
      }
    $slpr->closeCursor();

    XF::$tpl->assign('reported_posts',$reported_post);
    XF::$tpl->assign('pending_request',$lpr);
    }
  XF::$tpl->display('mcp_request.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $class = XF::sanitize_var(XF::ifset($input,'stage',''),'enum','o=report_posting');
  $data = XF::sanitize_var(XF::ifset($input,'data',''),'str');
  $this->gpc = array('class'=>$class,'data'=>$data);
  return true;
  }

  /**
  * perform a moderator request (remove 'report posting' flag)
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
      switch ( $this->gpc['class'] ){
      case 'report_posting':
      $this->gpc['data'] = intval($this->gpc['data']);
      $sreq = XF::sql_query("SELECT COUNT(ur_hash) AS req_count FROM ".XF::tbl('user_request')." WHERE ur_class = 'REPORT_POSTING' AND ur_data_int = :postid",
      array('postid'=>array($this->gpc['data'],'int')),__METHOD__,__LINE__);
      $reqdata = $sreq->fetchObject();
      $sreq->closeCursor();
        if ( !is_object($reqdata) && (int)$reqdata->req_count === 0 )
        $this->error = '{:posting_not_reported}';

        if ( empty($this->error) ){
          if ( !XF::sql_transaction('begin',array('user_request'=>'w')) )
          throw new XFE('unable to begin database transaction');
        $d = XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_class = 'REPORT_POSTING' AND ur_data_int = :postid",
        array('postid'=>array($this->gpc['data'],'int')),__METHOD__,__LINE__);
          if ( $d ){
          $reported = array(0);
          $sche = XF::sql_query("SELECT ur_data_int FROM ".XF::tbl('user_request')." WHERE ur_class = 'REPORT_POSTING'",'',__METHOD__,__LINE__);
            while ( $r = $sche->fetchObject() )
            $reported[] = intval($r->ur_data_int);
          $sche->closeCursor();
            if ( XF::$tpl->is_cached('mcp_request.tpl') )
            XF::$tpl->clear_cache('mcp_request.tpl');
          XF::tpl_use_cache_pool($this->gpc['data'],'begin');
            if ( XF::$tpl->is_cached('post.tpl',$this->gpc['data']) )
            XF::$tpl->clear_cache('post.tpl',$this->gpc['data']);
          XF::tpl_use_cache_pool(0,'reset');
          XFCache::put('simple','post_reported',$reported);
          }
        $this->sucuri = XF::link('topic',array('post'=>$this->gpc['data']),false);
        $this->sucmsg = '{:posting_report_deleted}';
        $this->success = true;
        XF::logger(':'.$d,'sub','REPORT_POSTING','postid',$this->gpc['data'],'action','-');
        XF::sql_transaction('commit');
        }
      break;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_mcp_request($input){
  $a = new XFAction_mcp_request();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success($a->sucuri,$a->sucmsg);
    else
    return xfaf_failure($a->get_error());
  }

?>