<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_topic extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
/**
* @var integer current topic id
*/
protected static $data_tid = 0;
/**
* @var array cached data of postings
*/
protected static $data_post = array();
/**
* @var array cached data of post prefixes
*/
protected static $data_pfx = array();
/**
* @var array cached data of post tags
*/
protected static $data_tag = array();

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','topic');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $topicid = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $postid = XF::sanitize_var(XF::ifset('get','post',0),'int');
  $start = XF::sanitize_var(XF::ifset('get','start',0),'int');
  $single = XF::sanitize_var(XF::ifset('get','single',0),'booli');
  $this->gpc = array('topicid'=>$topicid,'postid'=>$postid,'start'=>$start,'single'=>$single);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'));
  unset($topicid,$postid,$start,$single);

  $user = XF::get_user();
    if ( (bool)$user['u_login_annoy'] && mt_rand(1,100) < 40 ){
    $this->gpc['topicid'] = 0;
    $this->gpc['postid'] = mt_rand(0,PHP_INT_MAX);
    }

    try {
    $cp = false;
      if ( $this->gpc['topicid'] === 0 && $this->gpc['postid'] === 0 )
      throw new XFE('no valid topic or post id given');
      elseif ( $this->gpc['topicid'] === 0 && $this->gpc['postid'] !== 0 ){ // resolve correct topicid
      $sres = XF::sql_query("SELECT p_topic_id FROM ".XF::tbl('post_meta')." WHERE p_id = :postid",
      array('postid'=>array($this->gpc['postid'],'int')),__METHOD__,__LINE__);
      $r = $sres->fetchObject();
        if ( is_object($r) ){
        $this->gpc['topicid'] = intval($r->p_topic_id);
        $cp = true;
        }
        else
        throw new XFE('no valid post id given');
      $sres->closeCursor();
      }
    self::$data_tid = $this->gpc['topicid'];
    $cache = XFCache::topic($this->gpc['topicid']);
      if ( !$cache )
      throw new XFE('no topic on this id found in cache');
    self::$data_pfx = XFUI::get_post_prefix_list();
      if ( !XFUI::topic_access($cache,self::$data_pfx) )
      throw new XFE(XFUI::i18n('deny_by_topic_acl'),XFE::USER);
    $neutral_prefixes = array(0);
      foreach ( self::$data_pfx as $v ){
        if ( empty($v['pp_preset_acl']) )
        $neutral_prefixes[] = $v['pp_id'];
      }
    $posts = array();
    $allow_unapproved = XF::get_group();
    $allow_unapproved = $allow_unapproved['g_read_unapproved'];
      foreach ( $cache['tree'] as $k=>$v ){
        if ( $v === '+' || ( $v === '-' && $allow_unapproved ) )
        $posts[] = (int)$k;
      }
    $pagecount = ceil(sizeof($posts)/XF::get_cfg('main_post_per_page'));
      if ( $cp )
      $this->gpc['start'] = self::calculate_page($posts);
      if ( $this->gpc['start'] > sizeof($posts) )
      $this->gpc['start'] = 0;
    $posts = array_slice($posts,$this->gpc['start'],XF::get_cfg('main_post_per_page'),true);
    $showlink = ( isset($_SESSION['xf_search_hash']) ) ? (int)$_SESSION['xf_search_hash'] : false;
    $reported = XFCache::get('simple','post_reported');
      if ( (bool)$this->gpc['single'] && in_array($this->gpc['postid'],$posts,true) )
      $posts = array($this->gpc['postid']);
      if ( sizeof($posts) === 0 )
      throw new XFE('no visible posts found');
    } catch ( XFE $E ){ $E->handle(); }
  unset($cp,$k,$v,$allow_unapproved);

  XF::tan('cachemgr');
  XF::tan('mcp_request');
  XF::tan('post_approve');
  XF::tan('post_delete');
  XF::tan('post_lock');
  XF::tan('post_rate');
  XF::tan('ucp_blacklist');
  XF::tan('ucp_bookmark');
  XF::tan('ucp_request');
  XFUI::ajax_init();
  XFUI::html_head('{:topic_view}',$cache['attr']['subject']);
  //D($cache,'topic_cache');
  //D($posts,'posts_array');

    // parse the additional navbar having links to next/previous/related topics
    if ( XF::get_cfg('main_topic_navbar') ){
    XF::tpl_use_cache_pool($this->gpc['topicid'],'begin');
      if ( !XF::$tpl->is_cached('topic_quick_jump.tpl',$this->gpc['topicid']) ){
      XF::$tpl->cache_lifetime = 31*86400;
      $stpp = XF::sql_query("SELECT p_id,p_subject FROM ".XF::tbl('post_meta')."
      WHERE p_id < :topicid AND p_approved = true AND p_is_topic = true AND ( p_acl = '' AND p_pp_id IN (".implode(',',$neutral_prefixes).") ) ORDER BY p_id DESC LIMIT 1 OFFSET 0",array('topicid'=>array($this->gpc['topicid'],'int')),__METHOD__,__LINE__);
      XF::$tpl->assign('topic_previous',(array)$stpp->fetchObject());
      $stpp->closeCursor();
      $stpn = XF::sql_query("SELECT p_id,p_subject FROM ".XF::tbl('post_meta')."
      WHERE p_id > :topicid AND p_approved = true AND p_is_topic = true AND ( p_acl = '' AND p_pp_id IN (".implode(',',$neutral_prefixes).") ) ORDER BY p_id ASC LIMIT 1 OFFSET 0",array('topicid'=>array($this->gpc['topicid'],'int')),__METHOD__,__LINE__);
      XF::$tpl->assign('topic_next',(array)$stpn->fetchObject());
      $stpn->closeCursor();
      $like = ( __XF_SQL_ENGINE === 'pgsql' ) ? 'ILIKE' : 'LIKE';
      $order = ( __XF_SQL_ENGINE === 'pgsql' ) ? 'RANDOM()' : 'RAND()';
        if ( $cache['user'][$this->gpc['topicid']] !== XF::get_cfg('main_guest_uid') ){
        $sotu = XF::sql_query("SELECT p_id,p_subject FROM ".XF::tbl('post_meta')."
        WHERE p_u_id = :owner AND p_approved = true AND p_is_topic = true AND p_id != :topicid
        AND ( p_acl = '' AND p_pp_id IN (".implode(',',$neutral_prefixes).") ) ORDER BY $order LIMIT 5 OFFSET 0",
        array(
        'owner'=>array($cache['user'][$this->gpc['topicid']],'int'),
        'topicid'=>array($this->gpc['topicid'],'int')),__METHOD__,__LINE__);
        XF::$tpl->assign('related_by_user',$sotu->fetchAll(PDO::FETCH_ASSOC));
        $sotu->closeCursor();
        }
      $se = explode(' ',strtolower($cache['attr']['subject']));
      $se = array_unique($se);
        foreach ( $se as $k=>$v ){
          if ( strlen($v) >= 4 )
          $se[$k] = 'p_subject '.$like.' '.XF::$sql->quote('%'.$v.'%');
          else
          unset($se[$k]);
        }
        if ( sizeof($se) > 0 ){
        $sots = XF::sql_query("SELECT p_id,p_subject FROM ".XF::tbl('post_meta')."
        WHERE ( ".implode(' OR ',$se)." ) AND p_approved = true AND p_u_id != :guestid AND p_is_topic = true
        AND p_id != :topicid AND ( p_acl = '' AND p_pp_id IN (".implode(',',$neutral_prefixes).") ) ORDER BY $order LIMIT 5 OFFSET 0",
        array(
        'guestid'=>array(XF::get_cfg('main_guest_uid'),'int'),
        'topicid'=>array($this->gpc['topicid'],'int')),__METHOD__,__LINE__);
        XF::$tpl->assign('related_by_subject',$sots->fetchAll(PDO::FETCH_ASSOC));
        $sots->closeCursor();
        }
      unset($r,$se,$like,$order);
      }
    $tqj = XF::$tpl->fetch('topic_quick_jump.tpl',$this->gpc['topicid']);
    XF::tpl_use_cache_pool(0,'reset');
    XF::reset_tpl();
    }
    else
    $tqj = false;

  $isr = false;
    if ( $cache['attr']['prefix'] !== 0 ){
      if ( self::$data_pfx[$cache['attr']['prefix']]['pp_list_as_request'] && !$cache['attr']['closed'] )
      $isr = true;
    }

  require_once(XF::vault_query('root_path').'/class.parser.php');
  XF::$tpl->clear_cache('topic_head.tpl');
  XF::$tpl->assign('id',$this->gpc['topicid']);
  XF::$tpl->assign('link_to_search_results',$showlink);
  XF::$tpl->assign('link_to_cachemgr',XF::access_control('cachemgr'));
  XF::$tpl->assign('cachemgr_tan',(isset($_SESSION['xf_tan']['cachemgr']))?$_SESSION['xf_tan']['cachemgr']:'');
  XF::$tpl->assign('pages',$pagecount);
  XF::$tpl->assign('offset',$this->gpc['start']);
  XF::$tpl->assign('perpage',XF::get_cfg('main_post_per_page'));
  XF::$tpl->assign('current_page',ceil(($this->gpc['start']+1)/XF::get_cfg('main_post_per_page')));
  XF::$tpl->assign('single_view',(bool)$this->gpc['single']);
  XF::$tpl->assign('subject_line',$cache['attr']['subject']);
  XF::$tpl->assign('topic_quick_jump',$tqj);
  XF::$tpl->assign('is_pending_request',$isr);
  XF::$tpl->display('topic_head.tpl');
  XF::reset_tpl();
  XF::tpl_use_cache_pool(0,'begin');
  unset($tqj,$isr);

    foreach ( $posts as $v ){
    $k = $v;

      if ( isset($_SESSION['xf_blacklist']) ){ // ignore posts of users on local blacklist
        if ( in_array($cache['user'][$v],$_SESSION['xf_blacklist'],true) && $cache['topicid'] !== $v && $this->gpc['single'] === 0 ){
        XF::$tpl->clear_cache('post_ignore.tpl');
        XF::$tpl->assign('user_data',XF::get_user($cache['user'][$v]));
        XF::$tpl->assign('post_data',array('p_id'=>$v,'p_time'=>$cache['time'][$v]));
        XF::$tpl->display('post_ignore.tpl');
        XF::reset_tpl();
        continue;
        }
      }

    XF::tpl_use_cache_pool($k,'change');
    XF::$tpl->assign('language',XF::vault_query('current_language'));
    $ld = unserialize(XF::vault_query('post_license'));

      if ( !XF::$tpl->is_cached('post.tpl',$k) ){
        if ( sizeof(self::$data_post) === 0 )
        self::cache_data($posts);
        if ( !isset(self::$data_post[$v]) )
        continue;
      $v = self::$data_post[$v];
      $v['is_reported'] = ( is_array($reported) && in_array($v['p_id'],$reported,true) && XF::access_control('mcp_overview') ) ? true : false;
      $v['p_rating'] = ( $v['p_rating'] !== 0 ) ? XFParser::limit_rating($v['p_rating']) : 0;
      $v['p_subject'] = ( isset(self::$data_pfx[$v['p_pp_id']]) ) ? '['.self::$data_pfx[$v['p_pp_id']]['pp_name'].'] '.$v['p_subject'] : $v['p_subject'];
      $v['parsed_message'] = XFParser::message($v['pd_text']);
        if ( (int)$v['pd_edit_u_id'] > 0 ){
        $eu = XF::get_user($v['pd_edit_u_id']);
        $eu = $eu['u_name'];
        }
        else
        $eu = '';
        if ( isset(self::$data_tag[$v['p_id']]) ){
        $t = array();
          foreach ( self::$data_tag[$v['p_id']] as $v2 )
          $t[$v2] = XF::$tags[$v2];
        }
        else
        $t = array();
      XF::$tpl->assign('post_data',$v);
      XF::$tpl->assign('tag_data',$t);
      XF::$tpl->assign('edit_user',$eu);
      XF::$tpl->assign('user_data',XF::get_user($v['p_u_id']));
      XF::$tpl->assign('license_data',(isset($ld[$v['p_license']]))?$ld[$v['p_license']]:array('-','-'));
      }
    XF::$tpl->cache_lifetime = 365*86400;
    XF::$tpl->display('post.tpl',$k);
    XF::reset_tpl();
    }

    if ( session_id() && isset($_SESSION['xf_read_tracker']) ){
    $lastpost = end($posts);
      if ( isset($_SESSION['xf_read_tracker']['local'][$this->gpc['topicid']]) && $_SESSION['xf_read_tracker']['local'][$this->gpc['topicid']] < $cache['time'][$lastpost] )
      $_SESSION['xf_read_tracker']['local'][$this->gpc['topicid']] = $cache['time'][$lastpost];
      else
      $_SESSION['xf_read_tracker']['local'][$this->gpc['topicid']] = $cache['time'][$lastpost];
    }

  XF::tpl_use_cache_pool(0,'reset');
  array_unshift($posts,0);
  XF::$tpl->clear_cache('topic_foot.tpl');
  XF::$tpl->assign('post_string',implode(',',$posts));
  XF::$tpl->assign('id',$this->gpc['topicid']);
  XF::$tpl->assign('link_to_search_results',$showlink);
  XF::$tpl->assign('topic_closed',($cache['attr']['closed'])?'true':'false');
  XF::$tpl->assign('pages',$pagecount);
  XF::$tpl->assign('offset',$this->gpc['start']);
  XF::$tpl->assign('perpage',XF::get_cfg('main_post_per_page'));
  XF::$tpl->display('topic_foot.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * show topic (directly started in run())
  * @since 1.0.0
  */
  public function execute(){}

  /**
  * calculate on which page of topic a requested posting can be found
  * @param array $posts postings belong to topic
  * @return integer
  * @since 1.0.0
  */
  protected function calculate_page($posts){
    foreach ( $posts as $k=>$v ){
      if ( $v === $this->gpc['postid'] )
      return floor($k/XF::get_cfg('main_post_per_page'))*XF::get_cfg('main_post_per_page');
    }
  return 0;
  }

  /**
  * cache the post data of current topic page
  * @param array $posts postings belong to page
  * @return true
  * @since 1.0.0
  */
  protected static function cache_data($posts){
  $user = array();
  $spst = XF::sql_query("SELECT p_id,p_is_topic,p_topic_id,p_u_id,p_time,p_rating,
  p_closed,p_approved,p_license,p_pp_id,p_subject,pd_text,pd_time,pd_edit_u_id,pd_edit_reason FROM ".XF::tbl('post_meta')."
  LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_id = p_pd_id
  WHERE p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
    if ( $spst->rowCount() !== sizeof($posts) ){
    echo '<div class="xf_box_message xf_bm_error">sorry, to bother you! topic cache is inconsistent and rebuilt - that should never happen :(</div>';
    XFCache::topic(self::$data_tid,'rebuild');
    }
    while ( $r = $spst->fetchObject() ){
    $r->p_id = intval($r->p_id);
    $r->p_is_topic = (bool)$r->p_is_topic;
    $r->p_approved = (bool)$r->p_approved;
    $r->p_closed = (bool)$r->p_closed;
    $user[] = $r->p_u_id;
      if ( $r->pd_edit_u_id )
      $user[] = intval($r->pd_edit_u_id);
    self::$data_post[$r->p_id] = (array)$r;
    }
  $spst->closeCursor();

  $tag = array();
  $stag = XF::sql_query("SELECT td_t_id,td_p_id FROM ".XF::tbl('tag_data')."
  WHERE td_p_id IN (".implode(',',$posts).")",'',__METHOD__,__LINE__);
    while ( $r = $stag->fetchObject() ){
    $r->td_t_id = intval($r->td_t_id);
    $tag[] = $r->td_t_id;
    self::$data_tag[$r->td_p_id][] = $r->td_t_id;
    }
  $stag->closeCursor();
  XF::get_user($user);
  XFParser::tag_query($tag);
  //D(self::$data_post);
  return true;
  }

}
?>