<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
@set_magic_quotes_runtime(0); // NOTE: deprecated in recent PHP versions...
if(!function_exists('D')){function D($a,$b=null){ob_start();var_dump($a);$x=ob_get_contents();$x=preg_replace('/(\[[\-\d]+\])=>/','<b style="color:#00f;">\1</b>=>',$x);$x=preg_replace('/(\[".+?"\])/','<b style="color:#090;">\0</b>',$x);$x=preg_replace('/(\w+)\(/','<em style="color:#f60;">\1</em>(',$x);ob_end_clean();$y='<pre style="border:3px double #f00;margin:10px;padding:10px;background-color:#fff;color:#000;">'.gettype($b).':'.$b.chr(10).$x.'</pre>';if(XF::vault_query('mode')==='ajax')XFUI::$ajax_response->alert(strip_tags($y));else echo $y;}}

  // implementation for windows as it doesn't support checkdnsrr()...
  // by: developer at sysco dot ch @ 15-May-2007 06:05
  // http://de2.php.net/manual/de/function.checkdnsrr.php
  // @saturas: changed syntax, replaced ereg() and made 'A'-record default
  if ( !function_exists('checkdnsrr') ){
    function checkdnsrr($hostname,$rectype = ''){
      if ( !empty($hostname) ){
        if ( $rectype === '' )
        $rectype = 'A';
      exec('nslookup -type='.$rectype.' '.$hostname,$result);
      // check each line to find the one that starts with the host
      // name. If it exists then the function succeeded.
        foreach ( $result as $line ){
          if ( preg_match('/^'.$hostname.'/iD',$line) )
          return true;
        }
      // otherwise there was no result for the domain
      return false;
      }
    return false;
    }
  }

/**
* XF handles all low-level including initialization, database connection and basic abstraction layers
* @package lbcore
*/
class XF {
/**
* @var boolean debugging mode for developers - activates lots more verbosity...
*/
const DEBUG = false;
/**
* @var boolean well, do the same even in external libaries, where we installed our debugging hooks...
*/
const DEBUG_DEBUG = false;
// next is 'DEBUG_DEBUG_DEBUG'. okay, this was just fun.
// how often can you say it without stuttering :D
/**
* @var string the current software version
*/
const VERSION = '1.0.1';
/**
* @var integer demands this database version
*/
const DATABASE_VERSION = 1;
/**
* @var string what branch does this major release belong to
*/
const BRANCH = 'stable';
/**
* @var integer bit for 'vault': read-only access
*/
const VAULT_RO = 0x08;
/**
* @var integer bit for 'vault': writeable access
*/
const VAULT_RW = 0x04;
/**
* @var integer bit for 'vault': access requires token
*/
const VAULT_PROTECTED = 0x02;
/**
* @var integer bit for 'vault': public access
*/
const VAULT_PUBLIC = 0x01;
/**
* @var integer run scheduled tasks every x minutes
*/
const TASK_INTERVAL = 3;
/**
* @var boolean if 'true', we use encryption for cookies
*/
const ENABLE_SCRAMBLE = true;
/**
* @var integer maximal length of posting messages
*/
const POST_MAXLEN = 20000;
/**
* @var string between x and y seconds we annoy an user on "regular" use, if enabled
*/
const ANNOY_TIMESPAN = '10,20';
/**
* @var integer probability in percent a user gets annoyed on asynchronous requests, if enabled
*/
const ANNOY_PROBABILITY_ON_AJAX = 75;
/**
* @var integer mapped post id for last posts in rss feed (2^31-10)
*/
const RSS_LAST = 2147483638;
/**
* @var integer mapped post id for unapproved posts in rss feed (2^31-9)
*/
const RSS_MOD_UNAPPROVE = 2147483639;
/**
* @var string use this formatting to be complaint to RFC 822
*/
const DATE_RFC822 = 'D, d M Y H:i:s O';
/**
* @var integer token for accessing protected vars in 'vault'
*/
protected static $vtoken = null;
/**
* @var array our 'vault' - global variables for XF can be stored here
*/
protected static $vault = array();
/**
* @var array parsed configuration vars
*/
protected static $config = array();
/**
* @var array cached user data
*/
protected static $user = array();
/**
* @var array cached group data
*/
protected static $group = array();
/**
* @var array simple checksum storage
*/
protected static $checksum = array();
/**
* @var array style definitions: stylesheets and imageset
*/
public static $style = array();
/**
* @var resource sql resource handler
*/
public static $sql = null;
/**
* @var boolean only simulate query execution
*/
public static $sql_simulate = false;
/**
* @var boolean were all required tables found in database?
*/
protected static $tables_complete = false;
/**
* @var resource template engine handler
*/
public static $tpl = null;
/**
* @var array language strings
*/
public static $lang = array();
/**
* @var array cached posting tags
*/
public static $tags = array();
/**
* @var array available tables in database
*/
protected static $tbl = array(
'parsed'=>false,
'acl'=>'$P acl',
'config'=>'$P config',
'config_task'=>'$P config_task',
'group'=>'$P group',
'log'=>'$P log',
'post_data'=>'$P post_data',
'post_meta'=>'$P post_meta',
'post_prefix'=>'$P post_prefix',
'post_rating'=>'$P post_rating',
'search_result'=>'$P search_result',
'statistic'=>'$P statistic',
'tag_data'=>'$P tag_data',
'tag_meta'=>'$P tag_meta',
'user'=>'$P user',
'user_blacklist'=>'$P user_blacklist',
'user_bookmark'=>'$P user_bookmark',
'user_request'=>'$P user_request'
);
/**
* @var array required configuration variables and their allowed content
*/
protected static $config_data = array( // root_* should always be first!
'_'=>array('int'),
'root_uri'=>array('uri'),
'root_path'=>array('path'),
'auth_activate_limit'=>array('utime'),
'auth_bind_agent'=>array('bool'),
'auth_bind_ip'=>array('bool'),
'auth_max_faillogin'=>array('int'),
'auth_max_lifetime'=>array('utime'),
'auth_use_reauth'=>array('bool'),
'auth_use_tan'=>array('bool'),
'cache_acl'=>array('bool'),
'cache_config'=>array('bool'),
'cache_main'=>array('bool'),
'cache_rss'=>array('bool'),
'cache_topic'=>array('bool'),
'cache_tpl'=>array('bool'),
'cache_user'=>array('bool'),
'cookie_domain'=>array('hostname','okifempty'),
'cookie_path'=>array('path','okifempty'),
'cookie_read_tracker'=>array('str'),
'cookie_session'=>array('str'),
'cookie_ssl_only'=>array('bool'),
'help_class'=>array('enum','o=mail,o=direct'),
'help_mail_address'=>array('mail','okifempty'),
'http_detect_language'=>array('bool'),
'http_output_zlib'=>array('bool'),
'log_enable'=>array('bool'),
'log_forward'=>array('enum','o=none,o=filetxt,o=filexml,o=syslog'),
'log_ip'=>array('bool'),
'log_max_age'=>array('utime'),
'log_parameter'=>array('str'),
'log_statistic'=>array('bool'),
'mail_from_mail'=>array('mail'),
'mail_from_name'=>array('str'),
'main_debug_verbose'=>array('bool'),
'main_default_group'=>array('int'),
'main_enable'=>array('bool'),
'main_guest_uid'=>array('int'),
'main_language'=>array('lang'),
'main_post_edit_limit'=>array('utime'),
'main_post_per_page'=>array('int'),
'main_style'=>array('style'),
'main_tags_on_index'=>array('int'),
'main_title'=>array('str'),
'main_topic_navbar'=>array('bool'),
'main_topic_per_page'=>array('int'),
'main_umask'=>array('str','okifempty,forcestr'),
'main_uuid'=>array('str'),
'main_version'=>array('int'),
'param_action'=>array('str'),
'param_ajax'=>array('uri'),
'param_file'=>array('uri'),
'rss_limit'=>array('int'),
'rss_payload'=>array('bool'),
'task_enable'=>array('bool'),
'uri_css'=>array('uri'),
'uri_gfx'=>array('uri'),
'uri_js'=>array('uri')
);
/**
* @var array some annoyances for inconvenient users
*/
protected static $annoyances = array(
'SHOW_BLANK_PAGE','PUT_IN_ANTEROOM','MAINTENANCE_MESSAGE','RANDOM_HTTP_ERROR','LOGOUT_THIS_TIME',
'REDIRECT_TO_INDEX','SCHABERNACK_MACHEN','KILL_AUTHENTICATION'
);

  /**
  * start your engines :)
  * @param string $mode select mode to execute: 'regular', 'ajax' or 'setup'
  * @param array $options options - see method for details
  * @return boolean
  * @since 1.0.0
  */
  // options: 'initcfg_file' - user defined path to initial configuration
  final public function __construct($mode = 'regular',$options = array()){
    //if ( self::DEBUG ) // full error reporting for developers...
    //error_reporting(E_ALL|E_STRICT);
    if ( version_compare(PHP_VERSION,'5.3.0dev','>=') ) // NOTE: needed as xajax raises deprecation warnings...
    error_reporting(error_reporting()&~E_DEPRECATED^E_STRICT);
  self::vault_query('bench',microtime(true),'pub');
  self::$vtoken = mt_rand(0,mt_getrandmax());
  self::vault_query('mode',$mode,'pub');
  self::vault_query('root_path',self::sanitize_var(dirname(__FILE__),'path'),'pub,required');
  $cfg = ( isset($options['initcfg_file']) ) ? self::sanitize_var($options['initcfg_file'],'path') : self::vault_query('root_path').'/config.db.php';
  unset($mode);
    if ( self::DEBUG ){
    require_once(self::vault_query('root_path').'/class.debug.php');
    XFDebug::settracecolor('ccf');
      if ( isset($_GET['TODO']) && (int)$_GET['TODO'] === 1 ){
      $_GET['DEBUG'] = 1;
      XFDebug::todo();
      }
    XFDebug::trace(__METHOD__,self::arr2str($options));
    }
    if ( file_exists($cfg) ){
    $cfg = parse_ini_file($cfg);
      if ( isset($cfg['engine']) ) define('__XF_SQL_ENGINE',$cfg['engine']);
      if ( isset($cfg['hostname']) ) define('__XF_SQL_HOSTNAME',$cfg['hostname']);
      if ( isset($cfg['username']) ) define('__XF_SQL_USERNAME',$cfg['username']);
      if ( isset($cfg['password']) ) define('__XF_SQL_PASSWORD',$cfg['password']);
      if ( isset($cfg['database']) ) define('__XF_SQL_DATABASE',$cfg['database']);
      if ( isset($cfg['prefix']) ) define('__XF_SQL_PREFIX',$cfg['prefix']);
    unset($cfg);
    }
    if ( self::vault_query('mode') === 'regular' ){
    header('Content-Type: text/html; charset=utf-8');
    header('X-Fun: peter piper picked a peck of pickled peppers');
    }
  self::init_begin(); // only reorder, if you know what you're doing!
  self::init_env();
  self::init_cache();
    if ( self::vault_query('mode') === 'setup' )
    return true;
  self::init_cfg();
    if ( self::vault_query('mode') === 'regular' )
    self::init_task();
  self::init_i18n();
  self::init_tpl();
  self::init_user();
  self::init_style();
    if ( self::vault_query('mode') === 'regular' ){
    self::init_annoyances();
    self::init_end();
      try {
      $ac = strtolower(self::vault_query('request_action'));
        if ( self::sql_transaction('is_running:regular_core') )
        self::sql_transaction('commit:regular_core');
      $cn = 'XFAction_'.$ac;
      require_once(self::vault_query('root_path').'/action.'.$ac.'.php');
        if ( is_subclass_of($cn,'XFAction') ){
        $ao = new $cn();
          if ( isset($ao->version) && (int)$ao->version === XFAction::API_VERSION ){
            if ( self::DEBUG ){
            XFDebug::settracecolor('fff');
            XFDebug::trace(__METHOD__,'now switching to action "'.$ac.'"');
            }
          $ao->init('regular',array());
          }
          else
          throw new XFE('"'.$ac.'" has not a compatible api version');
        }
        else
        throw new XFE('"'.$ac.'" is no sibling of "XFAction"');
        if ( self::DEBUG )
        XFDebug::settracecolor('cfc');
        if ( self::sql_transaction('is_running:cleanup') )
        throw new XFE('"action" has not committed an open transaction');

        // executive users can request an exception, if they want to...
        if ( isset($_GET['EXCEPTION']) && (int)$_GET['EXCEPTION'] === 1 ){
        $g = self::get_group();
          if ( $g['g_executive'] )
          throw new XFE('well, you wanted an exception and i throw one ;)');
        }
      } catch ( XFE $E ){ $E->handle(); }
    }
  return true;
  }

  /**
  * well, clean up after work and turn off the lights...
  * @return void
  * @since 1.0.0
  */
  final public function __destruct(){
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,'bye, bye, my love, goodbye...');
    if ( self::vault_query('mode') === 'regular' ){
    self::$sql = null; // PDO closes the connection this way...
      if ( isset($_GET['DEBUG']) && (int)$_GET['DEBUG'] === 1 && XF::DEBUG )
      echo XFDebug::trace(null,'','');
    }
  }

  /**
  * initialize basics: check php settings and prepare user input arrays
  * @return true
  * @since 1.0.0
  */
  protected static function init_begin(){
  $mods = array('pcre','filter','pdo','session','date');
  $cons = array('__XF_SQL_HOSTNAME','__XF_SQL_USERNAME','__XF_SQL_PASSWORD','__XF_SQL_DATABASE',
  '__XF_SQL_PREFIX','__XF_SQL_ENGINE');
  $strip = false;
    try {
      if ( version_compare(PHP_VERSION,'5.2.0','<') )
      throw new XFE('PHP must be at least 5.2.0');
      foreach ( $mods as $v ){
        if ( !extension_loaded($v) )
        throw new XFE('The extension "'.$v.'" is not loaded');
      }
      foreach ( $cons as $v ){
        if ( !defined($v) && XF::vault_query('mode') !== 'setup' )
        throw new XFE('The constant "'.$v.'" is not defined');
      }
      if ( !in_array(__XF_SQL_ENGINE,array('mysql','pgsql'),true) )
      throw new XFE('SQL Engine "'.htmlspecialchars(__XF_SQL_ENGINE).'" not available');
    } catch ( XFE $E ){ $E->handle(); }

    // we handle all slashing of untrusted sources - will be default as of php6
    // NOTE: yes, this is a bad idea, if the board is included into other sites...
    // NOTE: this becomes deprecated in PHP6 and 'is scheduled for removing' as php.ini says
    if ( version_compare(PHP_VERSION,'6.0.0dev','<') && get_magic_quotes_gpc() === 1 ){
    $a = array('_GET','_POST');
    $strip = true;
      foreach ( $a as $v ){
        if ( is_array($GLOBALS[$v]) ){
          foreach ( $GLOBALS[$v] as $k1=>$v1 ){
            if ( is_array($v1) ){
              foreach ( $v1 as $k2=>$v2 )
              $GLOBALS[$v][$k1][$k2] = stripslashes($v2);
            }
            else
            $GLOBALS[$v][$k1] = stripslashes($v1);
          }
        }
      }
    }

  $env = self::arr2str(array('token'=>self::$vtoken,'umask'=>sprintf('%04o',umask()),
  'php_version'=>PHP_VERSION,'zend_version'=>zend_version(),'os'=>PHP_OS,'uname'=>php_uname(),'sapi'=>php_sapi_name(),'uid'=>getmyuid(),
  'extension'=>implode(',',get_loaded_extensions()),'safe_mode'=>self::bool2yn(ini_get('safe_mode')),'memory_limit'=>ini_get('memory_limit'),
  'register_globals'=>self::bool2yn(ini_get('register_globals')),'max_execution_time'=>ini_get('max_execution_time'),'stripped_quotes_on_gpc'=>$strip));
  // please ask php group why "*INI*_get" fetches *runtime* values and "get_cfg_var" from php.*INI*... ;)
  self::vault_query('env_vars',$env,'token='.self::$vtoken);
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,$env);
  return true;
  }

  /**
  * intialize common variables and prepare database table array
  * @return true
  * @since 1.0.0
  */
  protected static function init_env(){
  require_once(self::vault_query('root_path').'/class.ui.php');
  self::vault_query('uts',intval(gmdate('U')),'pub');
  self::vault_query('server_name',self::sanitize_var($_SERVER['SERVER_NAME'],'hostname'),'pub,required');
  self::vault_query('request_method',self::sanitize_var($_SERVER['REQUEST_METHOD'],'request'),'pub,required');
  self::vault_query('client_ip',self::sanitize_var($_SERVER['REMOTE_ADDR'],'ip'),'pub,required');
  self::vault_query('client_hash',sha1(self::ifset('server','HTTP_USER_AGENT','unknown').self::ifset('server','HTTP_ACCEPT_LANGUAGE','unknown').self::ifset('server','X-Forwarded-For','unknown')),'pub');
  self::vault_query('current_user_id',0,'pub,rw');
  self::vault_query('current_group_id',0,'pub,rw');
  self::vault_query('current_language','en','pub,rw');
  self::vault_query('current_timezone','UTC','pub,rw');
  self::vault_query('current_time24h',true,'pub,rw');
  self::vault_query('current_style','default','pub,rw');
  date_default_timezone_set('UTC'); // should both be changed later by language specs
  setlocale(LC_ALL,'C');
    if ( !self::$tbl['parsed'] ){
      foreach ( self::$tbl as $k=>$v )
      self::$tbl[$k] = str_replace('$P ',__XF_SQL_PREFIX,$v);
    self::$tbl['parsed'] = true;
    }
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array('root_path'=>self::vault_query('root_path'),'mode'=>self::vault_query('mode'))));
  return true;
  }

  /**
  * initialize caching system
  * @return true
  * @since 1.0.0
  */
  protected static function init_cache(){
  $cd = self::vault_query('root_path').'/cache';
    try {
    require_once(self::vault_query('root_path').'/class.cache.php');
      if ( !XFCache::setdir($cd) )
      throw new XFE('cache folder could not be set');
    } catch ( XFE $E ){ $E->handle(); }
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,$cd);
  return true;
  }

  /**
  * process configuration
  * @param boolean $safemode use safemode while loading? if 'true', we read it plain from db and do no post processing.
  * @return true
  * @since 1.0.0
  */
  protected static function init_cfg($safemode = false){
  $pattern = array();
  $replace = array();
  $dbdata = array();
  $rebuildcache = true;
  $ssldetected = false;

    try {
    $cache = XFCache::get('simple','config');
      if ( !$safemode && is_array($cache) && sizeof($cache) === sizeof(self::$config_data) ){
        foreach ( $cache as $k=>$v ){
          if ( !isset(self::$config_data[$k]) )
          throw new XFE('configuration key "'.$k.'" is rejected');
        $dbdata[$k] = $v;
        }
      $rebuildcache = false;
      }
      else{
      XFCache::purge('simple','config');
      $scfg = self::sql_query("SELECT * FROM ".self::tbl('config'),'',__METHOD__,__LINE__);
        if ( $scfg->rowCount() === 0 )
        throw new XFE('configuration table is empty');
        while ( $r = $scfg->fetchObject() )
        $dbdata[$r->c_id] = $r->c_value;
      $scfg->closeCursor();
      }
    $cache = $dbdata; // save raw values from cache or database and work with a copy in $cache...

      foreach ( self::$config_data as $k=>$v ){ // configuration parameters are *always* sanitized!
        if ( !isset($cache[$k]) )
        throw new XFE('configuration key "'.$k.'" is missing');
        if ( !isset(self::$config_data[$k]) )
        throw new XFE('configuration key "'.$k.'" is rejected');
        switch ( $k ){ // some patterns should be replaced in all config vars
        case 'root_uri':
          if ( self::sanitize_var(self::ifset('server','SERVER_PORT',80),'int') === 443 && substr($cache[$k],0,7) === 'http://' ){
          $cache[$k] = 'https://'.substr($cache[$k],7); // detect a standard ssl connection and replace protocol handler
          $ssldetected = true;
          }
        $pattern[] = '{$ROOT_URI}';
        $replace[] = $cache[$k];
        break;
        }
        if ( self::DEBUG && isset($_GET['NOCACHE']) && substr($k,0,6) === 'cache_' )
        $cache[$k] = false;
      $constraint = ( isset($v[1]) ) ? $v[1] : '';
      $sanitized = self::sanitize_var(str_replace($pattern,$replace,$cache[$k]),$v[0],$constraint);
      self::$config[$k] = $sanitized;
      }
    unset($cache);
      if ( !$safemode && self::DATABASE_VERSION > self::$config['_'] )
      throw new XFE('you have an incompatible database version ('.self::$config['_'].'), please update ('.self::DATABASE_VERSION.')');
    } catch ( XFE $E ){ $E->handle(); }

    if ( !$safemode ){ // use get_cfg() from now on :)
    $ac = self::sanitize_var(self::ifset(self::vault_query('request_method'),self::get_cfg('param_action'),'overview'),'action');
    self::vault_query('request_action',$ac,'pub,rw,required');
    $lang = self::get_cfg('main_language');
    $style = self::get_cfg('main_style');
    $umask = self::get_cfg('main_umask');
    session_name(self::get_cfg('cookie_session'));
    ini_set('session.use_only_cookies',true);
    ini_set('session.use_trans_sid',false);
    ini_set('session.cookie_httponly',true);
      if ( !empty($lang) )
      self::vault_query('current_language',$lang,'pub,rw');
      if ( !empty($style) )
      self::vault_query('current_style',$style,'pub,rw');
      if ( !empty($umask) )
      umask(octdec($umask));
      if ( !headers_sent() && self::get_cfg('http_output_zlib') ){
      $zoc = strtolower(get_cfg_var('zlib.output_compression'));
      $zoc = ( empty($zoc) || $zoc === 'off' ) ? true : false;
        if ( extension_loaded('zlib') && $zoc ){
        @flush();
        ob_implicit_flush(0);
        ob_start('ob_gzhandler'); // must be registered *before* session_start()!
        }
      }
      if ( self::get_cfg('cache_config') && $rebuildcache )
      XFCache::put('simple','config',$dbdata);
    }

    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array_merge(array('CACHE'=>(int)$rebuildcache^0x01,'SAFEMODE'=>self::bool2yn($safemode),'SSL_DETECTED'=>self::bool2yn($ssldetected),'UMASK'=>sprintf('%04o',umask())),self::$config)));
  return true;
  }

  /**
  * run a scheduled task, if enabled.
  * @return boolean
  * @since 1.0.0
  */
  protected static function init_task(){
    if ( !self::get_cfg('task_enable') )
    return false;
  $task = array('CMD'=>'','RETURN'=>null,'ERROR'=>'','TRACE'=>'');
  $taskrun = ''; // debug: directly run one task on every pageload...
  $run = false;
  $at = self::vault_query('root_path').'/cache/task_lock';
    if ( !file_exists($at) ){
      if ( !is_writeable(dirname($at)) )
      $task['ERROR'] = "'$at' not writable";
      if ( touch($at) )
      $run = true;
    }
    else
    $run = true;

    if ( $run ){
    $run = false;
      if ( date('i')%self::TASK_INTERVAL === 0 ){
      clearstatcache();
      $d = filemtime($at);
        if ( (int)date('ymdHi',$d) < (int)date('ymdHi') ){
        touch($at); // this is also locking -> next user will get 'false' on this if-condition...
        $run = true;
        }
      }
    unset($d,$at);
    }

    if ( strlen($taskrun) > 0 ) $run = true;
    if ( $run ){ // if, TASK_INTERVAL and timestamp file are 'true', run our task...
    $stsk = self::sql_query("SELECT * FROM ".self::tbl('config_task')."
    WHERE ct_active = true AND ct_time_last+ct_time_interval < :now ORDER BY ct_time_last LIMIT 1 OFFSET 0",
    array('now'=>array(self::vault_query('uts'),'int')),__METHOD__,__LINE__);
    $scht = $stsk->fetchObject();
    $stsk->closeCursor();
      if ( is_object($scht) ){
        if ( strlen($taskrun) > 0 ) $scht->ct_command = $taskrun;
      $scht->ct_command = preg_replace('/[^a-z_]+/u','',strtolower($scht->ct_command));
      $scht->ct_parameter = preg_replace('/[^a-z0-9_,\-]+/u','',strtolower($scht->ct_parameter));
        if ( file_exists(self::vault_query('root_path').'/task.'.$scht->ct_command.'.php') ){
        $_t = null;
        define('__XF_ALLOW_TASK',1);
        $cn = 'XFTask_'.$scht->ct_command;
        require_once(self::vault_query('root_path').'/task.'.$scht->ct_command.'.php');
          if ( $_t instanceof $cn && is_subclass_of($cn,'XFTask') ){
            if ( isset($_t->version) && (int)$_t->version === XFTask::API_VERSION )
            $run = $_t->execute($scht->ct_parameter);
            else{
            $task['ERROR'] = 'not compatible api version';
            $run = false;
            }
          $task['RETURN'] = (bool)$run;
          $task['CMD'] = $scht->ct_command;
            if ( !empty($scht->ct_parameter) )
            $task['CMD'] .= ' ['.$scht->ct_parameter.']';
          $task['TRACE'] = implode(chr(10),$_t->get_trace());
          define('__XF_TASK_RUN',$scht->ct_command);
          }
        unset($run,$_t,$cn);
          if ( strlen($taskrun) === 0 ){
          self::sql_query("UPDATE ".self::tbl('config_task')." SET ct_time_last = :time WHERE ct_command = :command",
          array('command'=>array($scht->ct_command,'int'),
          'time'=>array(self::vault_query('uts'),'int')),__METHOD__,__LINE__);
          self::logger('system','task',$task['CMD'],'success',self::bool2yn($task['RETURN']));
          }
        }
        else
        $task['ERROR'] = $scht->ct_command.' does not exist';
      }
    }
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str($task));
  return true;
  }

  /**
  * prepare smarty template engine handing html outputs
  * @return true
  * @since 1.0.0
  */
  protected static function init_tpl(){
  define('SMARTY_DIR',self::vault_query('root_path').'/ext/smarty/libs/');
  require_once(SMARTY_DIR.'Smarty.class.php');
  self::$tpl = new Smarty();
    if ( is_object(self::$tpl) && self::$tpl instanceof Smarty ){
    self::$tpl->template_dir = self::vault_query('root_path').'/template/';
    self::$tpl->compile_dir = self::vault_query('root_path').'/cache/tpl/';
    self::$tpl->config_dir = self::vault_query('root_path').'/';
    self::$tpl->cache_dir = self::vault_query('root_path').'/cache/tpl/';
      if ( self::get_cfg('cache_tpl') )
      self::$tpl->caching = 2;
      else{
      self::$tpl->caching = 0;
      self::$tpl->force_compile = true;
      }
    self::$tpl->compile_check = true;
    self::$tpl->security = true;
    self::$tpl->php_handling = SMARTY_PHP_REMOVE;
    self::$tpl->secure_dir = array(self::$tpl->template_dir);
    //self::$tpl->security_settings['IF_FUNCS'][] = 'is_null';
    }
  return true;
  }

  /**
  * initialize user data and cache group data
  * @return true
  * @since 1.0.0
  */
  protected static function init_user(){
  $auth = false;
  $isguest = true;
  $sessauth = array();
  $cookiesess = self::scramble(self::ifset('cookie',self::get_cfg('cookie_session'),''),'decrypt');
    // TODO: [idle] init_user() well, it doesn't help we scramble this cookie when php sends another plain :)
    // okay, this is quite a dirty hack to prevent sending that unscrambled cookie - also found in 'action.login.php'...
    if ( self::sanitize_var($cookiesess,'session') ){
    session_id($cookiesess);
    session_start();
    @header('Set-Cookie: ');
      if ( isset($_SESSION['xf_authentication']) ){
      require_once(self::vault_query('root_path').'/class.auth.php');
      $sessauth = XFAuth::validate_session();
        if ( $sessauth === false ){ // session has expired...
          if ( !headers_sent() ){
          self::cookie(self::get_cfg('cookie_session'),'');
          session_destroy();
          }
        }
        else{
        $auth = true;
        $isguest = false;
        $uid = $sessauth['user_id'];
        self::vault_query('is_logged_in',true,'pub');
          if ( $sessauth['status'] === 'tainted' ) // handle 'tainted' session later on at init_end()...
          define('__XF_AUTH_IS_TAINTED',$sessauth['reason']);
        }
      }
    }
    if ( $isguest ){
    $auth = true;
    $uid = self::get_cfg('main_guest_uid');
    self::vault_query('is_logged_in',false,'pub');
    }
    try {
      if ( $auth ){
      $user = self::get_user($uid);
        if ( !is_array($user) )
        throw new XFE('userid "'.$uid.'" not found in database');
      $lang = ( self::sanitize_var($user['u_language'],'lang') !== false ) ? $user['u_language'] : '';
      $style = ( self::sanitize_var($user['u_style'],'style') !== false ) ? $user['u_style'] : '';
      $timezone = ( self::sanitize_var($user['u_timezone'],'str') !== false ) ? $user['u_timezone'] : '';
      self::vault_query('current_user_id',$user['u_id'],'pub');
      self::vault_query('current_group_id',$user['u_group'],'pub');
        if ( !empty($style) && in_array($style,explode(',',self::vault_query('available_styles')),true) )
        self::vault_query('current_style',$style,'pub');
        if ( !empty($lang) && in_array($lang,explode(',',self::vault_query('available_languages')),true) ){
        self::vault_query('current_language',$lang,'pub');
        XFUI::load_lang_res(self::vault_query('current_language'),'core');
        }
        if ( !empty($timezone) && in_array($timezone,DateTimeZone::listIdentifiers(),true) )
        self::vault_query('current_timezone',$timezone,'pub');
      self::vault_query('current_time24h',self::sanitize_var($user['u_time24h'],'booli'),'public');
        if ( !$isguest && $user['u_login_annoy'] && isset($_SESSION['xf_authentication']) ){ // do some fun ;)
        $at = explode(',',self::ANNOY_TIMESPAN);
          if ( !isset($_SESSION['xf_authentication']['annoy_timestamp']) )
          $_SESSION['xf_authentication']['annoy_timestamp'] = XF::vault_query('uts');
          if ( XF::vault_query('uts') > $_SESSION['xf_authentication']['annoy_timestamp'] ){
          $ac = array_rand(self::$annoyances);
          define('__XF_ANNOYANCE',self::$annoyances[$ac]);
          $_SESSION['xf_authentication']['annoy_timestamp'] = intval(XF::vault_query('uts')+mt_rand($at[0],$at[1]));
          }
        unset($ac,$at);
        }
      }
      else
      throw new XFE('unauthorized user');
    self::get_user_group_data();
    } catch ( XFE $E ){ $E->handle(); }

    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(self::$user[$uid]));
  return true;
  }

  /**
  * fetch core language file and detect preferred language by browser settings
  * @return true
  * @since 1.0.0
  */
  protected static function init_i18n(){
  $r = parse_ini_file(self::get_cfg('root_path').'/config.root.php');
  self::vault_query('available_languages',$r['installed_languages'],'pub');
  self::vault_query('available_styles',$r['installed_styles'],'pub');
  $r['installed_languages'] = explode(',',$r['installed_languages']);
  $r['installed_styles'] = explode(',',$r['installed_styles']);
  $pl = array();
    foreach ( $r as $k=>$v ){
      if ( substr($k,0,12) === 'post_license' ){
      $k = substr($k,13);
      $v = explode(',',$v);
        if ( substr($v[0],0,5) === ':help' )
        $v[0] = self::link('help').'#nolicense';
      $v[1] = str_replace('{$URI_GFX}',self::get_cfg('uri_gfx'),$v[1]);
      $pl[$k] = array_merge($v,array('post_license_msg_'.$k));
      }
    }
  self::vault_query('post_license',serialize($pl),'pub');
  $ad = '';

    if ( self::get_cfg('http_detect_language') ){
    $lang = explode(',',XF::ifset('server','HTTP_ACCEPT_LANGUAGE',''));
      foreach ( $lang as $v ){
        if ( empty($v) ) continue;
        if ( strpos($v,';') )
        $v = substr($v,0,strpos($v,';')); // use values only, no priorities...
        if ( in_array(strtolower($v),$r['installed_languages'],true) ){
        self::vault_query('current_language',$v,'pub,rw');
        $ad = $v;
        break;
        }
      }
    }

    try {
      if ( !in_array(self::vault_query('current_language'),$r['installed_languages'],true) )
      throw new XFE('selected language not available');
      if ( !in_array(self::vault_query('current_style'),$r['installed_styles'],true) )
      throw new XFE('selected language not available');
    } catch ( XFE $E ){ $E->handle(); }
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array('LANGUAGES'=>self::vault_query('available_languages'),'STYLES'=>self::vault_query('available_styles'),'AUTO_DETECT'=>$ad,'SELECT'=>self::vault_query('current_language').'.'.self::vault_query('current_style'))));
  XFUI::load_lang_res(self::vault_query('current_language'),'core');
  return true;
  }

  /**
  * load and prepare imageset along stylesheet definitions
  * @return true
  * @since 1.0.0
  */
  protected static function init_style(){
  $a = array('{$URI_CSS}'=>self::get_cfg('uri_css'),'{$URI_GFX}'=>self::get_cfg('uri_gfx'),'{$LANGUAGE}'=>self::vault_query('current_language'));
  $r = parse_ini_file(self::get_cfg('root_path').'/config.style.'.self::vault_query('current_style').'.php',true);
    foreach ( $r['stylesheet'] as $k=>$v )
    $r['stylesheet'][$k] = strtr($v,$a);
    foreach ( $r['imageset'] as $k=>$v )
    $r['imageset'][$k] = strtr($v,$a);
  $r['imageset']['icon_missing'] = self::get_cfg('uri_gfx').'/img_not_found.png';
  self::$style = $r;
  return true;
  }

  /**
  * well, prepare some fun for inconvenient users *haha*
  * @return true
  * @since 1.0.0
  */
  protected static function init_annoyances(){
    if ( !defined('__XF_ANNOYANCE') )
    return true;
    switch ( __XF_ANNOYANCE ){
    case 'SHOW_BLANK_PAGE':
    die();
    break;
    case 'PUT_IN_ANTEROOM':
    sleep(mt_rand(4,10));
    break;
    case 'MAINTENANCE_MESSAGE':
    self::$config['main_enable'] = 0;
    break;
    case 'RANDOM_HTTP_ERROR':
    $he = array(
    'HTTP/1.0 100 I Am Fed Up',
    'HTTP/1.0 205 La La La La',
    'HTTP/1.0 304 Please Repeat',
    'HTTP/1.0 400 &lt;°)))o&gt;&lt;',
    'HTTP/1.0 404 Not Found',
    'HTTP/1.0 410 *zzz* *zzz* *zzz*',
    'HTTP/1.0 500 Get The Fuck Out',
    );
    $a = array_rand($he);
    die('<h1><strong>'.$he[$a].'</strong></h1>');
    break;
    case 'LOGOUT_THIS_TIME':
    XF::vault_query('request_action','logout','pub,rw');
    break;
    case 'REDIRECT_TO_INDEX':
    XF::vault_query('request_action','overview','pub,rw');
    break;
    case 'SCHABERNACK_MACHEN': // makes text blinking and set new background color every second ;)
    define('__XF_ANNOY_THIS_BASTARD',1);
    break;
    case 'KILL_AUTHENTICATION':
    define('__XF_AUTH_IS_TAINTED','fun_message_'.mt_rand(1,8));
    break;
    }
  return true;
  }

  /**
  * set 'action' to run, access checks and set basic template vars
  * @return true
  * @since 1.0.0
  */
  protected static function init_end(){
  $redirectondeny = array('post_topic','post_reply');
  date_default_timezone_set(self::vault_query('current_timezone'));
    // NOTE: on *nix you can use "locale -a" to get all locales, if you have problems here...
    switch ( self::vault_query('current_language') ){
    case 'de':
    $sl = setlocale(LC_TIME,'de_DE@utf-8','de_DE.UTF-8','de_DE.UTF8','de.UTF8','de_DE','de','deutsch');
    break;
    default:
    $sl = setlocale(LC_TIME,'en_US@utf-8','de_DE.UTF-8','en_US.UTF8','en.UTF8','en_US','en','english');
    break;
    }
  self::vault_query('locale_setting',$sl,'pub');
    try {
    $ac = self::vault_query('request_action');
      if ( defined('__XF_AUTH_IS_TAINTED') && $ac !== 'logout' ){
        if ( session_id() && self::vault_query('request_method') === 'GET' && !isset($_SESSION['xf_reauth_redirect']) )
        $_SESSION['xf_reauth_redirect'] = self::ifset('server','QUERY_STRING','');
      $ac = 'reauth';
      }
      if ( !self::access_control($ac) ){
        if ( in_array($ac,$redirectondeny,true) && !self::vault_query('is_logged_in') )
        $ac = 'login';
        else
        throw new XFE(XFUI::i18n('running_action_denied_by_acl'),XFE::USER,'ACTION_DENIED_BY_ACCESS_CONTROL_LIST');
      }
      if ( !self::get_cfg('main_enable') && !self::access_control('acp_overview') )
      self::maintenance_mode();
    } catch ( XFE $E ){ $E->handle(); }
    if ( self::$tpl instanceof Smarty ){
    self::$tpl->assign('XF_FILE',self::get_cfg('param_file'));
    self::$tpl->assign('XF_ACTION',self::get_cfg('param_action'));
    self::$tpl->assign('XF_URI_IMAGE',self::get_cfg('uri_gfx'));
    self::vault_query('common_tpl_vars',implode(',',array_keys(self::$tpl->get_template_vars())));
    self::vault_query('request_action',$ac);
    }
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(self::vault_query('*')));
  return true;
  }

  /**
  * fetches user group from database and store them in class vars
  * @return true
  * @since 1.0.0
  */
  protected static function get_user_group_data(){
    if ( !self::chksum_query('get','group') )
    self::chksum_query('put','group',self::hash_cache_keys(
    array('g_id','g_name','g_color','g_max_post_weight','g_post_approved','g_post_repeat','g_read_unapproved','g_executive'),false));
  $rebuildcache = true;
  $cache = XFCache::get('simple','group');
    if ( is_array($cache) && sizeof($cache) > 0 ){
      foreach ( $cache as $k=>$v ){
        if ( self::hash_cache_keys($v) === self::chksum_query('get','group') )
        self::$group[(int)$k] = $v;
      }
      if ( sizeof(self::$group) > 0 )
      $rebuildcache = false;
    unset($cache);
    }

    if ( $rebuildcache ){
      try {
      $sgrp = self::sql_query("SELECT * FROM ".self::tbl('group'),'',__METHOD__,__LINE__);
        if ( $sgrp->rowCount() === 0 )
        throw new XFE('group table is empty');
        while ( $r = $sgrp->fetchObject() ){
        $r->g_id = intval($r->g_id);
        $r->g_name = $r->g_name;
        $r->g_post_approved = (bool)$r->g_post_approved;
        $r->g_post_repeat = (bool)$r->g_post_repeat;
        $r->g_read_unapproved = (bool)$r->g_read_unapproved;
        $r->g_executive = (bool)$r->g_executive;
        self::$group[$r->g_id] = (array)$r;
        }
      $sgrp->closeCursor();
      } catch ( XFE $E ){ $E->handle(); }
    }

    if ( self::get_cfg('cache_main') && $rebuildcache )
    XFCache::put('simple','group',self::$group);
    foreach ( self::$group as $k=>$v )
    self::$group[$k]['g_name'] = XFUI::lang_str($v['g_name']);
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,implode(',',array_keys(self::$group)));
  return true;
  }

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

  /**
  * fetch a list of all tables currently stored in database
  * @return array
  * @since 1.0.0
  */
  public static function get_table_list(){
    switch ( __XF_SQL_ENGINE ){
    case 'mysql': $stbl = self::$sql->query("SHOW TABLES"); break;
    case 'pgsql': $stbl = self::$sql->query("SELECT table_name FROM information_schema.tables WHERE table_schema = 'public'"); break;
    //case 'sqlite': $stbl = self::$sql->query("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name"); break;
    }
    if ( isset($stbl) && is_object($stbl) ){
    $o = $stbl->fetchAll(PDO::FETCH_COLUMN);
    $stbl->closeCursor();
    }
    else
    $o = false;
  return $o;
  }

  /**
  * reload configuration table by using safe mode
  * @return boolean
  * @since 1.0.0
  */
  public static function reload_safe_cfg(){
  return self::init_cfg(true);
  }

  /**
  * get vars from 'vault'
  * @return array
  * @since 1.0.0
  */
  public static function get_env(){
  return str_replace(self::$vtoken,'***',self::vault_query('env_vars','','token='.self::$vtoken));
  }

  /**
  * get current supported configuration values
  * @return array
  * @since 1.0.0
  */
  public static function get_cfg_data(){
  return self::$config_data;
  }

  /**
  * set a cookie. encrypted by default; not very tight, but (maybe) enough to beat junior black-hats ;)
  * is automatically disabled, if suhosin is detected and it already encrypts cookies.
  * @param string $a name of cookie
  * @param mixed $b value to store, set null to remove
  * @param mixed $c expiry time, can be integer or like '3d' for three days
  * @return boolean
  * @since 1.0.0
  */
  public static function cookie($a,$b,$c = 0){
  $os = ob_get_status();
    if ( headers_sent() && sizeof($os) === 0 )
    return false;
    if ( $c !== 0 && is_string($c) )
    $c = self::vault_query('uts')+self::sanitize_var($c,'utime');
    if ( is_null($b) ){
    $v = '';
    $c = 0;
    }
    else
    $v = ( ini_get('suhosin.cookie.encrypt') ) ? $b : self::scramble($b);
  setcookie($a,$v,$c,self::get_cfg('cookie_path'),self::get_cfg('cookie_domain'),self::get_cfg('cookie_ssl_only'));
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array('name'=>$a,'input'=>$b,'output'=>$v,'expire'=>($c===0)?'session_only':self::date($c),'path'=>self::get_cfg('cookie_path'),'domain'=>self::get_cfg('cookie_domain'))));
  return true;
  }

  /**
  * (de)scramble a string using cryptography
  * @param string $a input stream
  * @param string $b use 'auto' mode or 'encrypt' respectively 'decrypt'
  * @param string $c select algorithm: 'ARC4' is fast and 'Blowfish' is slow, but more secure
  * @return string
  * @since 1.0.0
  */
  public static function scramble($a,$b = 'auto',$c = 'ARC4'){
  $fourcc = ( substr($a,0,6) === '--XFs:' ) ? true : false;
    if ( !self::ENABLE_SCRAMBLE )
    return $a;
    if ( ( $b === 'decrypt' && !$fourcc ) || ( $b === 'encrypt' && $fourcc ) )
    return $a;
    if ( $b === 'auto' )
    $b = ( $fourcc ) ? 'decrypt' : 'encrypt';
  require_once(self::vault_query('root_path').'/class.crypt.php');
  $c = 'XFCrypt_'.$c;
  $cb = new $c();
    if ( $b === 'encrypt' ){
    $t = self::token(8);
    $cb->set_key(sha1(self::get_cfg('main_uuid').$t));
    $c = '--XFs:'.base64_encode($t.$cb->encrypt($a));
    }
    elseif ( $b === 'decrypt' ){
    $d = base64_decode(substr($a,6));
    $cb->set_key(sha1(self::get_cfg('main_uuid').substr($d,0,8)));
    $c = rtrim($cb->decrypt(substr($d,8)));
    }
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array('mode'=>$b,'length_input'=>strlen($a),'length_output'=>strlen($c))));
  return $c;
  }

  /**
  * create an 'universal unique identifier'.
  * if we didn't make a mistake on calculation, this should be about 120-bit of randomness...
  * output example: 550e8400-e29b-11d4-a716-446655440000 (not really strict RFC!)
  * @return string
  * @since 1.0.0
  */
  public static function uuid(){
  $o = array();
  $a = sha1(self::token(128,'binary'));
  usleep(mt_rand(100000,750000));
  $b = sha1(self::token(64,'alnum'));
  $o[] = substr($a,8,8);
  $o[] = substr($a.$b,11,4);
  $o[] = substr($b.$a,22,4);
  $o[] = substr($a.$b,33,4);
  $o[] = self::token(6).self::token(6);
  return implode('-',$o);
  }

  /**
  * store a transaction number to session for using in forms
  * @param string $a requested 'action'
  * @return boolean
  * @since 1.0.0
  */
  public static function tan($a,$b = '+'){
    if ( session_id() && self::sanitize_var($a,'action') ){
    $c = self::token(8); // about 30-bit randomness...
      if ( $b === '+' )
      $_SESSION['xf_tan'][$a] = $c;
      elseif ( $b === '-' )
      unset($_SESSION['xf_tan'][$a]);
      if ( self::DEBUG )
      XFDebug::trace(__METHOD__,self::arr2str(array('action'=>$a,'mode'=>$b,'tan'=>$c)));
    return true;
    }
  return false;
  }

  /**
  * hash a bitstream e.g. plaintext password - 256-bit requires php extension (usually available)
  * @param string $input input stream
  * @param boolean $salt add salt to password soup?
  * @param boolean $ext if 'true' returns 256-bit hash, otherwise 160-bit
  * @return string
  * @since 1.0.0
  */
  public static function hash($input,$salt = true,$ext = true){
  $used = 'sha1';
  $extalgo = array('ripemd256','sha256'); // ext = use 256-bit, otherwise 160-bit
    if ( $salt ){ // please keep 256-bit as maximum as some methods rely on string length of these hashes
    $s = substr(self::token(8).self::token(8),0,15);
    $input .= $s;
    }
    if ( extension_loaded('hash') && function_exists('hash_algos') && $ext ){
    $algos = hash_algos();
      foreach ( $extalgo as $v ){
        if ( in_array($v,$algos,true) ){
        $o = hash($v,$input);
        $used = $v;
        break;
        }
      }
    }
    if ( !isset($o) || !$o )
    $o = sha1($input);
    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array('algorithm'=>$used,'is_salted'=>$salt,'input'=>$input,'output'=>$o)));
  return ( $salt ) ? $s.'.'.$o : $o;
  }

  /**
  * returns a valid database table name for usage in sql queries
  * @param string $a name of table (keys of array XF::tbl()), '*' selects all
  * @param boolean $b if 'true', returns raw value
  * @return string
  * @since 1.0.0
  */
  public static function tbl($a,$b = false){
    if ( $a === '*' ){
    $b = self::$tbl;
    unset($b['parsed']);
    return $b;
    }
    if ( !isset(self::$tbl[$a]) )
    return '';
    if ( $b )
    return self::$tbl[$a];
    if ( __XF_SQL_ENGINE === 'pgsql' )
    return '"'.self::$tbl[$a].'"';
    else
    return self::$tbl[$a];
  }

  /**
  * all-purpose file handler - abstracts common php code snippets
  * flags: read,write,delete,noroot,local,remote,append,verify,compression=[none|auto|gz|bz2]
  * @param string $fd filename
  * @param string $data input stream
  * @param string $flags options - have a look at method for details
  * @return mixed
  * @since 1.0.0
  */
  public static function file_handler($fd,$data = '',$flags = ''){
  $flags = explode(',',$flags);
  $chroot = ( !in_array('noroot',$flags,true) ) ? true : false;
    if ( $chroot && !preg_match('|^'.self::vault_query('root_path').'|Du',$fd) )
    $fd = self::vault_query('root_path').'/'.$fd;
  $allow = ( in_array('remote',$flags,true) ) ? array('http','https','ftp','ftps') : array('file');
  $handler = ( strpos($fd,'://') ) ? preg_replace('/[^a-z]+/u','',substr($fd,0,strpos($fd,'://'))) : 'file';

    try {
    $bn = basename($fd);
      if ( !in_array($handler,$allow,true) )
      throw new XFE('wrapper '.$handler.' not allowed for "'.htmlspecialchars($bn).'"');
      if ( in_array('compression=auto',$flags,true) ){
      $ext = substr($bn,strrpos($bn,'.'));
        if ( $ext === 'gz' )
        $flags[] = 'compression=gz';
        elseif ( $ext === 'bz2' )
        $flags[] = 'compression=bz2';
      unset($ext);
      }
      if ( $handler === 'file' && in_array('compression=gz',$flags,true) && extension_loaded('zlib') )
      $handler = 'compress.zlib';
      if ( $handler === 'file' && in_array('compression=bz2',$flags,true) && extension_loaded('bz2') )
      $handler = 'compress.bzip2';
    $fd = $handler.'://'.$fd;
      if ( in_array('read',$flags,true) )
      $o = file_get_contents($fd);
      elseif ( in_array('write',$flags,true) ){
      $fdf = ( in_array('append',$flags,true) ) ? FILE_APPEND|LOCK_EX : LOCK_EX;
      $o = file_put_contents($fd,$data,$fdf);
        if ( $o && in_array('verify',$flags,true) )
        $o = ( sha1_file($fd) === sha1($data) ) ? true : false;
      }
      elseif ( in_array('delete',$flags,true) )
      $o = ( file_exists($fd) ) ? unlink($fd) : false;
    } catch ( XFE $E ){ $E->handle(); }

    if ( self::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array('URI'=>$fd,'FLAGS'=>implode(',',$flags),'SUCCESS'=>(bool)$o)));
  return $o;
  }

  /**
  * check if selected user can access an 'action'
  * @param string $action name of action
  * @param integer $uid user id, current if not given
  * @param integer $gid group id, current if not given
  * @return boolean
  * @since 1.0.0
  */
  public static function access_control($action,$uid = 0,$gid = 0){
  static $localc = array();
    if ( !$uid )
    $uid = self::vault_query('current_user_id');
    if ( !$gid )
    $gid = self::vault_query('current_group_id');
  $acl = array();
  $granted = false;
  $rebuildcache = false;
  $cachehandler = crc32($action);
  $lch = sha1($action.$uid.$gid);

    if ( isset($localc[$lch]) )
    return $localc[$lch];

    try {
    $cache = XFCache::get('acl',$cachehandler);
      if ( is_array($cache) && sizeof($cache) > 0 )
      $acl = $cache;
      else{
      $sacl = self::sql_query("SELECT a_id,a_key,a_use_group,a_allow FROM ".self::tbl('acl')."
      WHERE a_action = :action ORDER BY a_use_group ASC",
      array('action'=>array($action,'str')),__METHOD__,__LINE__);
        if ( $sacl->rowCount() === 0 )
        throw new XFE('no access control list found in database');
        while ( $r = $sacl->fetchObject() ){
        $r->a_use_group = (bool)$r->a_use_group;
        $r->a_allow = (bool)$r->a_allow;
        $acl[$r->a_id] = (array)$r;
        }
      $sacl->closeCursor();
      $rebuildcache = true;
      }

      if ( sizeof($acl) === 0 )
      throw new XFE('no access control entries for "'.htmlspecialchars($action).'"');
      foreach ( $acl as $k=>$v ){
        if ( !isset($v['a_key']) || !isset($v['a_use_group']) || !isset($v['a_allow']) )
        throw new XFE('illegal access control entry format on "'.$k.'"');
      $k = ( $v['a_use_group'] ) ? $gid : $uid;
        if ( $k === (int)$v['a_key'] ){
        $granted = $v['a_allow'];
        break;
        }
      }
    } catch ( XFE $E ){ $E->handle(); }

    if ( self::get_cfg('cache_acl') && $rebuildcache )
    XFCache::put('acl',$cachehandler,$acl);
    if ( self::DEBUG )
      XFDebug::trace(__METHOD__,self::arr2str(array_merge(array('CACHE'=>(int)$rebuildcache^0x01,'req_action'=>$action,'req_user'=>$uid,'req_group'=>$gid,'use_group'=>self::bool2yn($v['a_use_group'])),array('granted'=>$granted))));
  $localc[$lch] = $granted;
  return $granted;
  }

  /**
  * calculate the hash from input - usuable on non-scalar values
  * @param mixed $a input stream
  * @param boolean $b if 'true', use keys instead of values from input as long as it is an array
  * @return string
  * @since 1.0.0
  */
  public static function hash_cache_keys($a,$b = true){
    if ( !is_array($a) )
    return false;
  $c = ( $b ) ? array_keys($a) : array_values($a);
  sort($c);
  return sha1(print_r($c,true));
  }

  /**
  * rewire template engine cache to 'pool' when required
  * @param integer $a id translated by 'XF::get_masqueraded_folder()'
  * @param string $b use 'begin' first, then 'change' to alter the folders and 'reset' after work
  * @return true
  * @since 1.0.0
  */
  public static function tpl_use_cache_pool($a,$b){
  static $dir_cmp = '';
  static $dir_cac = '';
    if ( $b === 'begin' )
    $dir_cac = self::$tpl->cache_dir;
    if ( $b === 'begin' || $b === 'change' )
    self::$tpl->cache_dir = self::vault_query('root_path').'/cache/pool/'.self::get_masqueraded_folder((int)$a).'/';
    if ( $b === 'reset' ){
    self::$tpl->cache_dir = $dir_cac;
    $dir_cmp = '';
    $dir_cac = '';
    }
  return true;
  }

  /**
  * forward an entry to log system
  * deliver input as args: first is level 'system', 'info' or 'error'. any following are combined as message.
  * odd [1,3,5,...] become a 'description' for an entry. even [2,4,6,...] are its message.
  * you may also pass all args in an array as first argument.
  * example: logger('info','foo','bar','userid',3,'select','false') or logger(array('info','foo','bar','userid',3,'select','false'))
  * @params mixed input stream
  * @return boolean
  * @since 1.0.0
  */
  public static function logger(){
  $args = func_get_args();
    if ( sizeof($args) === 1 && is_array($args[0]) )
    $args = $args[0];
    if ( !self::get_cfg('log_enable') || sizeof($args) < 2 )
    return false;
  $lvl = $args[0];
    if ( substr($lvl,0,1) === ':' ){
    $lvl = substr($lvl,1);
    $lvl = ( ( is_bool($lvl) && $lvl ) || ( is_numeric($lvl) && $lvl > 0 ) ) ? 'info' : 'error';
    }
  unset($args[0]);
  $msg = '';
    foreach ( $args as $k=>$v ){
      if ( $k === 1 && $v === '..' )
      break;
    $msg .= ( $k%2 === 1 )
    ? $v.'="'
    : str_replace('"',"'",preg_replace('/[\x00-\x1f]+/u','',$v)).'"'.chr(10);
    }
  $loggedip = ( self::get_cfg('log_ip') ) ? self::vault_query('client_ip') : '127.0.0.1';
  require_once(self::vault_query('root_path').'/class.log.php');
  $l = new XFLog();
  $l->set_level($lvl);
  $l->set_message(rtrim($msg));
  $l->set_ip($loggedip);
  $l->log_to_db();
    switch ( self::get_cfg('log_forward') ){
    case 'filetxt': $l->log_to_file('txt'); break;
    case 'filexml': $l->log_to_file('xml'); break;
    case 'syslog': $l->log_to_syslog(); break;
    default: break;
    }
  unset($l);
  return true;
  }

  /**
  * parse logging messages for (human readable) output
  * @param object $r results of log entry from database
  * @return true
  * @since 1.0.0
  */
  public static function logger_parse_message(&$r){
  $a = '<a href="{$URL}">-·- '.XFUI::i18n('jump_to_object').'</a>';
  $c = explode(chr(10),$r->l_text);
    if ( isset($c[0]) && !empty($c[0]) && is_array($c) ){
      foreach ( $c as $k=>$v )
      $c[$k] = '<span class="xf_alv_key">'.substr($v,0,strpos($v,'=')).'</span>=<span class="xf_alv_value">'.wordwrap(substr($v,strpos($v,'=')+2,-1),80,'<br />').'</span>';
    }

    // well, include a link on some actions...
    if ( in_array($r->action,array('login','ucp_profile','reauth'),true) ){
    preg_match('/userid=\'(\d+)\'/',$r->l_text,$b);
      if ( isset($b[1]) )
      array_unshift($c,str_replace('{$URL}',self::link('ucp_profile',array('user'=>(int)$b[1])),$a));
    }
    elseif ( substr($r->action,0,5) === 'post_' ){
    preg_match('/new_postid=\'(\d+)\'/',$r->l_text,$b);
      if ( isset($b[1]) )
      array_unshift($c,str_replace('{$URL}',self::link('topic',array('post'=>(int)$b[1])),$a));
    }
    elseif ( $r->action === 'acp_acl_edit' ){
    preg_match('/action=\'([a-z0-9_]+)\'/',$r->l_text,$b);
      if ( isset($b[1]) )
      array_unshift($c,str_replace('{$URL}',self::link('acp_acl_list',array('id'=>$b[1])),$a));
    }
    elseif ( preg_match('/acp_(group|pp|user)_new/',$r->action,$d) ){
    preg_match('/new_id=\'(\d+)\'/',$r->l_text,$b);
      if ( isset($b[1]) )
      array_unshift($c,str_replace('{$URL}',self::link('acp_'.$d[1].'_list',array('id'=>(int)$b[1])),$a));
    }

  $r->l_text_f = implode('<br />',$c);
  return true;
  }

  /**
  * increase statistic counter by one
  * @param string $a descriptor - see statistic table for details
  * @return boolean
  * @since 1.0.0
  */
  public static function statistic($a){
    if ( !self::get_cfg('log_statistic') )
    return false;
  $at = self::vault_query('root_path').'/cache/statistic_lock';
    if ( !file_exists($at) ){
      if ( is_writeable(dirname($at)) )
      touch($at);
      else
      return false;
    }
  clearstatcache();
  $d = filemtime($at);
    if ( (int)gmdate('ymd',$d) < (int)gmdate('ymd') ){
    XF::sql_query("INSERT INTO ".self::tbl('statistic')." (st_day,st_month,st_year) VALUES (:day,:month,:year)",array(
    'day'=>array(gmdate('d'),'int'),
    'month'=>array(gmdate('m'),'int'),
    'year'=>array(gmdate('Y'),'int')),__METHOD__,__LINE__);
    touch($at);
    }
  unset($d,$at);
  $a = preg_replace('/[^a-z_]+/u','',$a);
  XF::sql_query("UPDATE ".self::tbl('statistic')." SET st_$a = st_$a+1 WHERE st_day = :day AND st_month = :month AND st_year = :year",array(
  'day'=>array(gmdate('d'),'int'),
  'month'=>array(gmdate('m'),'int'),
  'year'=>array(gmdate('Y'),'int')),__METHOD__,__LINE__);
  return true;
  }

  /**
  * reset all template vars except common one
  * @return boolean
  * @since 1.0.0
  */
  public static function reset_tpl(){
    if ( self::$tpl instanceof Smarty ){
    $ctv = explode(',',self::vault_query('common_tpl_vars'));
    $asv = array_keys(self::$tpl->get_template_vars());
      foreach ( $asv as $v ){
        if ( !in_array($v,$ctv,true) )
        self::$tpl->clear_assign($v);
      }
    return true;
    }
  return false;
  }

  /**
  * update the local caches like self::$user with new values
  * @param string $a cache identifier (currently 'user' only)
  * @param integer $b identifier of cache entry
  * @param string $c name of dataset
  * @param mixed $d new value
  * @return boolean
  * @since 1.0.0
  */
  public static function update_local_cache($a,$b,$c,$d){
    if ( $a === 'user' ){
    $allow = array('u_rating_bonus'=>'int');
      if ( isset(self::$user[(int)$b]) && isset($allow[$c]) ){
      self::$user[(int)$b][$c] = $d;
      settype(self::$user[(int)$b][$c],$allow[$c]);
      }
    return true;
    }
    else
    return false;
  }

  /**
  * get a configuration value
  * @param string $a key or '*' for all
  * @return mixed
  * @since 1.0.0
  */
  public static function get_cfg($a){
    if ( $a === '*' )
    return self::$config;
    if ( isset(self::$config[$a]) )
    return self::$config[$a];
    else
    return false;
  }

  /**
  * get user data - return data, if found, and caches it in class vars
  * @param array $uid user id, current if not given. if array, the first user is returned.
  * @return array
  * @since 1.0.0
  */
  public static function get_user($uid = 0){
    if ( !self::chksum_query('get','user') )
    self::chksum_query('put','user',self::hash_cache_keys(array('u_id','u_active','u_name',
    'u_mail','u_info','u_comment','u_warning_level','u_group','u_time_registration','u_time_last_read','u_rating_bonus','u_post_count',
    'u_post_approved','u_post_license','u_style','u_language','u_timezone','u_time24h','u_auto_bookmark','u_login_annoy','u_login_liberal',
    'u_login_token','u_login_fail','u_login_count'),false));
    if ( !is_array($uid) )
    $uid = array($uid);
    if ( !$uid[0] )
    $uid[0] = self::vault_query('current_user_id');

  $guestuid = self::get_cfg('main_guest_uid');
  $uid = array_unique($uid);
  $requestuid = array();
  $store = array();
    foreach ( $uid as $v )
    $requestuid[] = (int)$v;
    if ( sizeof($requestuid) === 1 && isset(self::$user[$requestuid[0]]) )
    return self::$user[$requestuid[0]];

    if ( sizeof($requestuid) > 0 ){
    $uid = array();
      foreach ( $requestuid as $v ){
      $cache = XFCache::get('user',$v);
        if ( is_array($cache) && self::hash_cache_keys($cache) === self::chksum_query('get','user') )
        self::$user[$v] = $cache;
        if ( !isset(self::$user[$v]) )
        $uid[] = $v;
      }
    unset($cache);
      if ( sizeof($uid) > 0 ){
      $susr = self::sql_query("SELECT * FROM ".self::tbl('user')." WHERE u_id IN (".implode(',',$uid).")",'',__METHOD__,__LINE__);
        while ( $r = $susr->fetchObject() ){
        $data = array();
        $store[] = (int)$r->u_id;
        unset($r->u_password); // do not store password hash in cache files!
          foreach ( $r as $k=>$v ){
            if ( is_numeric($v) ) $v = intval($v);
            if ( in_array($k,array('u_active','u_time24h','u_auto_bookmark','u_login_annoy','u_login_liberal'),true) ) $v = (bool)$v;
          $data[$k] = $v;
          }
        self::$user[$data['u_id']] = $data;
        }
      $susr->closeCursor();
      }
    }

    if ( self::get_cfg('cache_user') && sizeof($store) > 0 ){
      foreach ( $store as $v )
      XFCache::put('user',$v,self::$user[$v]);
    }
    if ( isset(self::$user[$guestuid]) )
    self::$user[$guestuid]['u_name'] = XFUI::lang_str(self::$user[$guestuid]['u_name']);
    if ( isset($requestuid[0]) && isset(self::$user[$requestuid[0]]) )
    return self::$user[$requestuid[0]];
  return false;
  }

  /**
  * get group data
  * @param integer $a group id, current if not given. '*' returns all.
  * @return mixed
  * @since 1.0.0
  */
  public static function get_group($a = 0){
    if ( $a === '*' )
    return self::$group;
    if ( !$a )
    $a = self::vault_query('current_group_id');
    if ( isset(self::$group[$a]) )
    return self::$group[$a];
    else
    return false;
  }

  /**
  * our 'vault': values can be stored here for class-wide reference
  * flags: pub,rw,required,token=
  * @param string $name name, '*' fetches all
  * @param string $value data
  * @param string $flags options, default is protected and read-only
  * @return mixed
  * @since 1.0.0
  */
  public static function vault_query($name,$value = '',$flags = ''){
  $flags = new XFAux_Flags($flags);
  $hastoken = ( $flags->token !== false && (int)$flags->token === self::$vtoken ) ? true : false;
    if ( $name === '*' ){ // fetch all
    $data = array();
      foreach ( self::$vault as $k=>$v ){
        if ( $v['a']&self::VAULT_PROTECTED && !$hastoken )
        continue;
      $data[$k] = $v['v'];
      }
    ksort($data);
    return $data;
    }
    try {
      if ( $flags->required && !$value )
      throw new XFE('proper value for "'.$name.'" is required');

      if ( $value === '' /*strlen($value) === 0 */&& !is_bool($value) ){ // fetch
        if ( isset(self::$vault[$name]) ){
        $access = true;
          if ( self::$vault[$name]['a']&self::VAULT_PROTECTED && !$hastoken )
          $access = false;
          if ( $access )
          return self::$vault[$name]['v'];
          else
          throw new XFE('cannot access protected variable "'.$name.'"');
        }
        else
        return false;
      }
      else{ // put
        if ( !is_scalar($value) )
        throw new XFE('only scalar values are allowed in "'.$name.'"');
        if ( is_numeric($value) && strpos($value,'.') )
        $value = doubleval($value);
        elseif ( is_numeric($value) )
        $value = intval($value);
      $access = ( $flags->rw ) ? self::VAULT_RW : self::VAULT_RO;
      $access += ( $hastoken ) // only token can set protected vars
      ? ( $flags->pub ) ? self::VAULT_PUBLIC : self::VAULT_PROTECTED
      : self::VAULT_PUBLIC;
        if ( isset(self::$vault[$name]) ){
          if ( self::$vault[$name]['a']&self::VAULT_RW )
          self::$vault[$name] = array('a'=>$access,'v'=>$value);
          else
          throw new XFE('cannot reassign read-only variable "'.$name.'"');
        }
        else
        self::$vault[$name] = array('a'=>$access,'v'=>$value);
      }
    } catch ( XFE $E ){ $E->handle(); }

  return true;
  }

  /**
  * store a checksum locally and compare it, if requested
  * @param string $class 'get' does a comparison and 'put' stores a hash of input
  * @param string $name name
  * @param string $data sha1 hash on 'put' for later comparison
  * @return mixed
  * @since 1.0.0
  */
  public static function chksum_query($class,$name,$data = ''){
    switch ( $class ){
    case 'get':
      if ( isset(self::$checksum[$name]) )
      return self::$checksum[$name];
      else
      return false;
    break;
    case 'put':
      if ( strlen($data) === 40 && !isset(self::$checksum[$name]) ){
      self::$checksum[$name] = $data;
      return true;
      }
      else
      return false;
    break;
    }
  }

  /**
  * terminate script execution and output error message
  * @param string $msg input stream
  * @param boolean $beautify if 'true', displays some nice error messages for users instead of 'cold' exception report
  * @return void
  * @since 1.0.0
  */
  public static function terminate($msg,$beautify = false){
  echo '<html><head><title>Exception Handler</title>';
    if ( isset(self::$style['stylesheet']) ){
      foreach ( self::$style['stylesheet'] as $v ){
      $v = explode(',',$v);
        if ( $v[0] === 'AUTO' )
        echo '<link rel="stylesheet" href="'.$v[2].'" media="'.str_replace('|',',',$v[1]).'" charset="utf-8"></link>'.chr(10);
      }
    }
  echo '</head><body>'.chr(10);
    if ( $beautify ){
    echo '<div id="xf__user_exception" class="xf_content">';
    echo '  <div class="xf_item xf_header_main">';
    echo '  <a href="'.self::link('overview').'"><img src="'.XFUI::image('logo').'" alt="logo" class="xf_left" /></a> <h1>'.htmlspecialchars(self::get_cfg('main_title')).' - '.XFUI::i18n('an_error_occured').'</h1>';
    echo '  <br clear="all" />';
    echo '    <div class="xf_box_message xf_bm_message xf_bm_error">';
    echo '    <img src="'.XFUI::image('icon_error').'" alt="error sign" class="xf_left" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.htmlspecialchars($msg);
    echo '    <br clear="all" /><br /><div class="xf_text_small xf_text_normal xf_half_width" style="margin-left: 40px;">'.XFUI::i18n('explain_error_message').'</div>';
    echo '    </div>';
    echo '  &nbsp;&nbsp;» <a href="javascript:history.back(-1);">'.XFUI::i18n('go_one_step_back').'</a><br /><br />';
    echo '  </div>';
    echo '</div>';
    }
    else{
    echo '<div id="xf__system_exception" style="width: 100%; margin-top: 50px; background-color: #fff; border: 3px double #eee;">'.chr(10);
    echo '  <div style="background-color: #ddd; background-image: url('.self::get_cfg('uri_gfx').'/bg_header_main.png); color: #f00; font-size: 3em; text-align: center; font-weight: bold;">-» DEBUG INFORMATION «-</div>'.chr(10);
    echo '  <div style="padding: 10px; color: #000; border-bottom: 4px solid #999;">'.$msg.'</div>'.chr(10);
    //                                                                                ^^ output unfiltered msg!
    echo '  <div style="text-align: right; padding: 5px;"><a href="'.self::link('overview').'">'.htmlspecialchars(self::get_cfg('main_title')).'</a></div>'.chr(10);
    echo '</div>'.chr(10);
    }
  echo '</body></html>';
  die();
  }

  /**
  * output maintenance message and end execution
  * @return void
  * @since 1.0.0
  */
  public static function maintenance_mode(){
  $a = array('{$TITLE}','{$URI_IMAGE}','{$CSS}');
  $b = array(htmlspecialchars(self::get_cfg('main_title')),self::get_cfg('uri_gfx'),self::$style['stylesheet']['css0']);
  echo str_replace($a,$b,XF::file_handler('lang/'.XF::vault_query('current_language').'/maintenance.txt','','read,local'));
  die();
  }

  /**
  * returns value if is set otherwise a default
  * @param string $class location to look: 'get', 'post' or other
  * @param string $name name of variable
  * @param string $default default value to return, if not set
  * @return mixed
  * @since 1.0.0
  */
  public static function ifset($class,$name,$default){
  $type = ( is_array($class) ) ? 'array' : strtolower($class);
    switch ( $type ){
    case 'get': $o = ( isset($_GET["$name"]) ) ? $_GET["$name"] : $default; break;
    case 'post': $o = ( isset($_POST["$name"]) ) ? $_POST["$name"] : $default; break;
    case 'cookie': $o = ( isset($_COOKIE["$name"]) ) ? $_COOKIE["$name"] : $default; break;
    case 'server': $o = ( isset($_SERVER["$name"]) ) ? $_SERVER["$name"] : $default; break;
    case 'array': $o = ( isset($class["$name"]) ) ? $class["$name"] : $default; break;
    default: $o = ''; break;
    }
  return $o;
  }

  /**
  * sanitize user inputs - very(!) important
  * available flags: okifempty,forcestr,enforce,stripspaces,restrict,fullascii,hex,oct,length=,range=,o=
  * 'str,strwbr,path,file' are *sanitizing* (strip illegal chars), others are *validating* (return 'false' on illegal chars)
  * normally we do not allow empty input (zero strlen), use 'okifempty' flag to change this!
  * hex|oct (currently) not support 'range='
  * @param string $input input stream
  * @param string $class validate against what type?
  * @param string $flags some flags - see method for details
  * @return mixed
  * @since 1.0.0
  */
  public static function sanitize_var($input,$class,$flags = ''){
  static $cache = array();
  $ch = crc32($input.$class.$flags);
    if ( isset($cache[$ch]) )
    return $cache[$ch];
  $nolowchars = FILTER_FLAG_NO_ENCODE_QUOTES|FILTER_FLAG_STRIP_LOW;
  $flags = new XFAux_Flags($flags);
  $o = false;
    if ( !$flags->okifempty && strlen($input) === 0 )
    return false;
    switch ( $class ){
    case 'request':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^(GET|POST)$/D')));
    break;
    case 'session': // php5 allows more than 4-bit (a-f0-9) per char in session identifier
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9,\-]{32,40}$/iD')));
    break;
    case 'uri':
    $o = filter_var(self::strip_trailing_slash($input),FILTER_VALIDATE_URL);
    break;
    case 'hostname':
      if ( strlen($input) <= 255 ){
      $label = explode('.',$input);
        foreach ( $label as $v ){
          if ( substr($v,0,1) === '-' || substr($v,-1) === '-' ){
          $v = false;
          break;
          }
        $v = filter_var($v,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9_\-]{1,63}$/iD')));
          if ( $v === false ) // _ is not allowed by RFC 952, but it is used by some people anyway :)
          break;
        }
        if ( $v !== false )
        $o = $input;
      unset($label,$v);
      }
    break;
    case 'ip':
      if ( strstr($input,':') )
      trigger_error('IPv6 is not yet supported by "Larus Board", sorry...',E_USER_ERROR);
    $o = filter_var($input,FILTER_VALIDATE_IP,FILTER_FLAG_IPV4);
    break;
    case 'version':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^\d{1}\.\d{1,2}\.\d{1,3}$/D')));
    break;
    case 'mail':
    $o = filter_var($input,FILTER_VALIDATE_EMAIL);
    break;
    case 'uid':
    $input = preg_replace('/[ ]{2,}/u',' ',trim($input)); // trim multiple spaces
      if ( strlen($input) < 3 || strlen($input) > 32 || is_numeric($input) || substr($input,0,2) === '{:' )
      $o = false;
      else
      $o = filter_var($input,FILTER_SANITIZE_STRING,$nolowchars);
    break;
    case 'enum':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^('.implode('|',$flags->o).')$/D')));
    break;
    case 'path': case 'file':
    $input = realpath(preg_replace('=^[a-z\.]+:=Du','',$input)); // remove any wrappers
      if ( !$input )
      return false;
      if ( $class === 'path' )
      $input = self::strip_trailing_slash(preg_replace('=([\\]+|[/]{2,})=u','/',$input));
      elseif ( $class === 'file' )
      $input = preg_replace('=[\\/]+=u','',basename($input));
    $o = trim(filter_var($input,FILTER_SANITIZE_STRING,$nolowchars));
    break;
    case 'utime':
    preg_match('/([\d\.]+)\s*([sihdmy]{1})/iu',str_replace(',','.',$input),$r);
      if ( is_numeric($input) )
      $r = array('',(int)$input,'s');
      if ( sizeof($r) !== 3 )
      return false;
      switch ( strtolower($r[2]) ){
      case 'y': $o = doubleval($r[1])*365*86400; break;
      case 'M': $o = doubleval($r[1])*31*86400; break;
      case 'd': $o = doubleval($r[1])*86400; break;
      case 'h': $o = doubleval($r[1])*3600; break;
      case 'm': $o = doubleval($r[1])*60; break;
      case 's': $o = intval($r[1]); break;
      default:
      $o = false;
      break;
      }
    unset($r);
    break;
    case 'mdate':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^\d{4}\.\d{1,2}$/D')));
    break;
    case 'color':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[0-9a-f]{3,6}$/iD')));
    break;
    case 'lang':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z_\-]{2,10}$/D')));
    break;
    case 'style':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9_]{2,16}$/D')));
    break;
    case 'action':
    $o = filter_var($input,FILTER_VALIDATE_REGEXP,array('options'=>array('regexp'=>'/^[a-z0-9_]{3,20}$/D')));
    break;
    case 'bool':
    $o = filter_var($input,FILTER_VALIDATE_BOOLEAN);
    break;
    case 'booli':
    $o = ( filter_var($input,FILTER_VALIDATE_BOOLEAN) ) ? 1 : 0;
    break;
    case 'str':
    $o = ( $flags->fullascii )
    ? trim(filter_var($input,FILTER_SANITIZE_STRING))
    : trim(filter_var($input,FILTER_SANITIZE_STRING,$nolowchars));
    break;
    case 'strwbr':
    $o = str_replace("\r\n","\n",$input);
    $o = str_replace("\r","\n",$o);
    $o = trim(preg_replace('/[\x00-\x08\x0b\x0c\x0e-\x1f]{1,}/u','',$o));
    break;
    case 'int':
    $g = 0;
    $f = array(0,PHP_INT_MAX);
      if ( $flags->hex )
      $g += FILTER_FLAG_ALLOW_HEX;
      if ( $flags->oct )
      $g += FILTER_FLAG_ALLOW_OCTAL;
      if ( $flags->range !== false )
      $f = $flags->range;
      if ( $g === 0 )
      $o = filter_var($input,FILTER_VALIDATE_INT,array('min_range'=>(int)$f[0],'max_range'=>(int)$f[1]));
      else
      $o = filter_var($input,FILTER_VALIDATE_INT,$g);
    unset($f,$g);
    break;
    case 'float':
    $o = filter_var($input,FILTER_VALIDATE_FLOAT,$input);
    break;
    }

    if ( $flags->stripspaces && is_string($o) )
    $o = preg_replace('/[ ]{2,}/u',' ',$o);
    if ( $flags->restrict && is_string($o) )
    $o = preg_replace('/[^a-z0-9_]+/iu','',$o);
    if ( $flags->length !== false ){
      if ( isset($flags->length[0]) ){
        if ( strlen($o) < (int)$flags->length[0] )
        $o = false;
      }
      if ( isset($flags->length[1]) ){
        if ( strlen($o) > (int)$flags->length[1] )
        $o = false;
      }
    }
    try {
      if ( $o === false && $flags->enforce )
      throw new XFE('input "'.htmlspecialchars($class).'" rejected by check - enforce aborting');
    } catch ( XFE $E ){ $E->handle(); }
    if ( $flags->okifempty && strlen($input) === 0 )
    $o = ''; // be sure to return empty string
    if ( is_numeric($o) && !$flags->forcestr )
    $o = ( strpos($o,'.') ) ? doubleval($o) : intval($o);
  $cache[$ch] = $o;
  return $o;
  }

  /**
  * strips trailing slashes
  * @param string $a input stream
  * @return string
  * @since 1.0.0
  */
  public static function strip_trailing_slash($a){
    if ( substr($a,-1) === '/' )
    $a = substr($a,0,-1);
  return $a;
  }

  /**
  * validates input array for rejected 'false' data
  * @param array $a input stream
  * @return boolean
  * @since 1.0.0
  */
  public static function validate_gpc_data($a){
  $r = true;
    foreach ( $a as $k=>$v ){
      if ( $v === false ){
      $r = false;
      break;
      }
    }
  return $r;
  }

  /**
  * count set bits in input and returns them as hex
  * @param integer $a input stream
  * @return string
  * @since 1.0.0
  */
  public static function get_masqueraded_folder($a){
  // TODO: [idle] get_masqueraded_folder() this is not well balanced, but better than nothing...
  // example: 4095 => 12 bits set => returns 0C (12 in hex)
  $b = substr_count(str_pad(decbin(intval($a)),32,0,STR_PAD_LEFT),1);
  return str_pad(strtoupper(dechex($b)),2,0,STR_PAD_LEFT);
  }

  /**
  * scan through folders recursively
  * @param string $base base folder
  * @param boolean $list_files if true, also list files
  * @param array $data data stream
  * @return array
  * @since 1.0.0
  */
  public static function rscandir($base,$list_files = true,&$data = array()){
    if ( substr($base,0,-1) !== '/' && sizeof($data) === 0 )
    $base .= '/';
  $folder = scandir($base);
    foreach ( $folder as $v ){
      if ( $v === '.' || $v === '..' )
      continue;
      if ( is_dir($base.$v) ){
      $data[] = $base.$v.'/';
      $data = self::rscandir($base.$v.'/',$list_files,$data);
      }
      elseif ( $list_files && is_file($base.$v) )
      $data[] = $base.$v;
    }
  return $data;
  }

  /**
  * create a token - useful on creating passwords or digests
  * int=0-9, strict=a-f0-9, alnum=a-zA-Z0-9, binary=x00-xff
  * @param integer $a length of token
  * @param string $b choose token type: 'int', 'strict', 'alnum' or 'binary'
  * @param string $c using 'strong' here creates a token for cryptographic use, forces 'binary'
  * @return string
  * @since 1.0.0
  */
  public static function token($a,$b = 'int',$c = 'weak'){
  $a = intval($a);
  $o = '';
    try {
      if ( !in_array($b,array('int','strict','alnum','binary'),true) )
      throw new XFE('incorrect type of character range - use "int", "strict", "alnum" or "binary"');
      if ( !in_array($c,array('weak','strong'),true) )
      throw new XFE('incorrect entropy - use "weak" or "strong"');
      if ( $a > 9 && $b === 'int' )
      throw new XFE('integers cannot be longer than nine chars');
      if ( $c === 'strong' ){
        // TODO: [idle] token() what about bsd or windows here concerning pseudorandom data?
        if ( is_readable('/dev/urandom') /*&& PHP_OS === 'UNIX'*/ ){
        $prng = fopen('/dev/urandom','rb');
        $o = fread($prng,$a);
        fclose($prng);
        }
        else{
        $b = 'binary';
        $c = 'weak';
        }
      }
      if ( $c === 'weak' ){
        switch ( $b ){
        case 'int':
        $l = array(0,9);
        break;
        case 'strict': case 'alnum':
        $l = array(48,126);
        break;
        case 'binary':
        $l = array(0,255);
        break;
        }
        do {
        $m = mt_rand($l[0],$l[1]);
          // yes, i am aware that the following weakens the randomness a bit...
          // avoid leading zeroes as sql does not store them in int w/o zerofill (no error of database at all!)
          if ( $b === 'int' && strlen($o) === 0 && $m === 0 )
          continue;
          // restrict to hex (a-f 0-9)
          if ( $b === 'strict' ){
            if ( $m >= 58 && $m <= 96 )
            continue;
            if ( $m >= 103 )
            continue;
          }
          // spare some chars on alnum (down to a-z A-Z 0-9)
          if ( $b === 'alnum' ){
            if ( $m >= 58 && $m <= 64 ) // :;<=>?@
            continue;
            if ( $m >= 91 && $m <= 96 ) // [\]^_`
            continue;
            if ( $m >= 123 ) // {|}~
            continue;
          }
        $o .= ( $b === 'int' ) ? $m : chr($m);
        }
        while ( strlen($o) < $a );
      }
      if ( is_numeric($o) )
      $o = intval($o);
      elseif ( strlen($o) > 0 && strlen($o) > $a )
      $o = substr($o,0,$a);
    } catch ( XFE $E ){ $E->handle(); }
  return $o;
  }

  /**
  * format a date output
  * @param integer $a input timestamp, should be UTC
  * @param string $b resulting date format (default is RFC 822)
  * @param boolean $c if 'true', output is 'human readable'
  * @return string
  * @since 1.0.0
  */
  public static function date($a = 0,$b = '',$c = false){
  static $c24h = null;
    if ( is_null($c24h) )
    $c24h = self::vault_query('current_time24h');
  $dtn = ( $c24h ) ? '%a, %d %b %Y %H:%M %Z' : '%a, %d %b %Y %I:%M%p %Z';
  $dth = ( $c24h ) ? '%H:%M %Z' : '%I:%M%p %Z';
  $a = intval($a);
    if ( $a < 1 )
    $a = self::vault_query('uts');
    if ( empty($b) )
    $b = $dtn;
    if ( $c ){ // reformat it as 'human readable'
      if ( gmdate('Ymd',self::vault_query('uts')) === gmdate('Ymd',$a) )
      $o = XFUI::i18n('today').', '.strftime($dth,$a);
      elseif ( gmdate('Ymd',self::vault_query('uts')-86400) === gmdate('Ymd',$a) )
      $o = XFUI::i18n('yesterday').', '.strftime($dth,$a);
      elseif ( $a > self::vault_query('uts')-(4*86400) )
      $o = strftime('%A, '.$dth,$a);
      else
      $o = strftime($b,$a);
    }
    else
    $o = strftime($b,$a);
    return self::convert_to_utf8($o);
  }

  /**
  * parse a link
  * @param string $action use 'action'
  * @param mixed $params any params to append?
  * @param boolean $encode_amp if 'true', ampersands are encoded to '&amp;'
  * @return string
  * @since 1.0.0
  */
  public static function link($action,$params = array(),$encode_amp = true){
  $a = ( $encode_amp ) ? '&amp;' : '&';
  $o = self::get_cfg('param_file').'?';
    if ( $action !== '' && !is_null($action) )
    $o .= self::get_cfg('param_action').'='.urlencode($action);
    if ( is_string($params) && strlen($params) > 0 )
    parse_str($params,$params);
    if ( is_array($params) && sizeof($params) > 0 ){
      foreach ( $params as $k=>$v ) // clean up for http_build_query()
      $params[$k] = urldecode($v);
    }
    if ( is_array($params) && sizeof($params) > 0 )
    $o .= $a.http_build_query($params,'',$a);
  return $o;
  }

  /**
  * converts a string to unicode, if not already in this encoding
  * @param array $a input stream
  * @return boolean
  * @since 1.0.0
  */
  // bitseeker [22-Sep-2008 11:07] (http://de2.php.net/manual/en/function.utf8-encode.php)
  public static function convert_to_utf8($a){
  //return $a;
  // From http://w3.org/International/questions/qa-forms-utf-8.html
  $b = preg_match('%^(?:
        [\x09\x0A\x0D\x20-\x7E]            # ASCII
      | [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte
      |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
      | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
      |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
      |  \xF0[\x90-\xBF][\x80-\xBF]{2}     # planes 1-3
      | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
      |  \xF4[\x80-\x8F][\x80-\xBF]{2}     # plane 16
  )*$%xs',$a);
  return ( !$b ) ? utf8_encode($a) : $a;
  }

  /**
  * clears a query string from unencoded chars
  * don't use it on $_GET and $_REQUEST as they are already decoded!
  * @param string $a query string
  * @param string $b flags: force_decode, strip_html
  * @return string
  * @since 1.0.0
  */
  public static function clear_query_string($a,$b = ''){
  parse_str($a,$c);
  $b = explode(',',$b);
    if ( sizeof($c) > 0 ){
    $d = array();
      foreach ( $c as $k=>$v ){
        if ( in_array('force_decode',$b,true) )
        $v = urldecode($v);
        if ( in_array('strip_html',$b,true) )
        $v = strip_tags($v);
      $d[$k] = $v;
      }
    return http_build_query($d,'','&');
    }
  return '';
  }

  /**
  * narrows an array down to string
  * @param array $a input stream
  * @return string
  * @since 1.0.0
  */
  public static function arr2str($a){
    if ( !is_scalar($a) ){
    $b = '';
      if ( is_object($a) )
      $a = (array)$a;
      foreach ( $a as $k=>$v ){
        if ( is_null($v) ) $v = 'NULL';
        if ( is_bool($v) ) $v = ( $v === true ) ? 'TRUE' : 'FALSE';
      $b .= $k.'='.$v.chr(10);
      }
    return $b;
    }
    else
    return $a;
  }

  /**
  * transforms a bool to 'yes' or 'no'
  * @param boolean $a input stream
  * @return string
  * @since 1.0.0
  */
  public static function bool2yn($a){
    if ( $a === true || $a === 1 )
    return 'yes';
    else
    return 'no';
  }

  /**
  * initialize database connection
  * @return true
  * @since 1.0.0
  */
  public static function init_db(){
    if ( is_object(self::$sql) && self::$sql instanceof PDO )
    return true;
  $attr = array(
  'AUTOCOMMIT','ERRMODE','CASE','CLIENT_VERSION','CONNECTION_STATUS',
  'ORACLE_NULLS','PERSISTENT','PREFETCH','SERVER_INFO','SERVER_VERSION',
  'TIMEOUT'
  );
    try {
      if ( !in_array(__XF_SQL_ENGINE,PDO::getAvailableDrivers(),true) )
      throw new XFE('The drivers for "'.$engine.'" are not included in PDO');
      try {
        if ( __XF_SQL_ENGINE === 'mysql' ){
        $dsn = 'mysql:dbname='.__XF_SQL_DATABASE.';host='.__XF_SQL_HOSTNAME;
        self::$sql = new PDO($dsn,__XF_SQL_USERNAME,__XF_SQL_PASSWORD,array(PDO::ATTR_PERSISTENT=>false));
        }
        elseif ( __XF_SQL_ENGINE === 'pgsql' ){
        $dsn = 'pgsql:dbname='.__XF_SQL_DATABASE.';user='.__XF_SQL_USERNAME.';password='.__XF_SQL_PASSWORD;
        self::$sql = new PDO($dsn,null,null,array(PDO::ATTR_PERSISTENT=>false));
        }
      } catch ( PDOException $P ){ try {throw new XFE($P->getMessage());} catch ( XFE $E ){ $E->handle(); } }
    self::$sql->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
    self::$sql->setAttribute(PDO::ATTR_CASE,PDO::CASE_LOWER);
    self::$sql->setAttribute(PDO::ATTR_ORACLE_NULLS,PDO::NULL_NATURAL);
    self::$sql->setAttribute(PDO::ATTR_STRINGIFY_FETCHES,false);
    $req = self::tbl('*');
    $found = self::get_table_list();
    define('__XF_TABLE_CHECK_DONE',1);
      if ( is_array($found) ){
        foreach ( $found as $v ){
        $k = array_search($v,$req,true);
          if ( $k !== false ){
          unset($req[$k]);
          }
        }
      }
      if ( sizeof($req) === 0 )
      self::$tables_complete = true;
      if ( __XF_SQL_ENGINE === 'mysql' ){
      self::$sql->setAttribute(PDO::MYSQL_ATTR_DIRECT_QUERY,1); // we'll prepare statements...
      self::$sql->query("SET collation_connection = 'utf8_general_ci'");
      self::$sql->query("SET character_set_client = 'utf8'");
      self::$sql->query("SET character_set_results = 'utf8'");
      }
      elseif ( __XF_SQL_ENGINE === 'pgsql' )
      self::$sql->query("SET CLIENT_ENCODING TO 'UTF8'");
    } catch ( XFE $E ){ $E->handle(); }

    if ( XF::DEBUG ){
    $mya = array('DSN'=>str_replace('='.__XF_SQL_PASSWORD,'=***',$dsn));
      foreach ( $attr as $v ){
        try {
        $mya[$v] = self::$sql->getAttribute(constant('PDO::ATTR_'.$v));
        } catch ( PDOException $P ){} // don't catch attributes a database is not supporting
      }
    XFDebug::trace(__METHOD__,self::arr2str($mya));
    }

  return ( is_object(self::$sql) && self::$sql instanceof PDO ) ? true : false;
  }

  /**
  * perform a sql query
  * first char can be a flag: ?=debug selects, -=just simulate and !=only output query
  * params === '-' -> do not log query in debug trace AND no check before execution if table exists
  * @param string $query the query
  * @param array $params params for prepared statements
  * @param string $method what method issued it?
  * @param integer $line on which line?
  * @return mixed
  * @since 1.0.0
  */
  public static function sql_query($query,$params = array(),$method = '',$line = 0){
  static $attempt = 0;
    if ( self::$sql_simulate )
    $query = '!'.$query;
    if ( strlen($query) < 3 )
    return false;
    do { // establish database connection on demand
      if ( self::init_db() )
      break;
    $attempt++;
    sleep(1);
    } while ( $attempt <= 3 );
    if ( is_null(self::$sql) )
    trigger_error('cannot establish connection to database server after several retries',E_USER_ERROR);
  $debug = false;
  $simulate = false;
  $flag = substr($query,0,1);
    if ( $flag === '?' ){ // debug 'select-statements'
    $query = substr($query,1);
    $debug = true;
    }
    if ( $flag === '-' ){ // just simulate query processing
    $query = substr($query,1);
    $simulate = true;
    }
    if ( $flag === '!' ){ // return query for output
    $query = substr($query,1);
    echo '<strong>'.$method.'@'.$line.'</strong> --<br /><pre>'.htmlspecialchars(print_r($params,true).trim($query)).'</pre><hr />';
    return true;
    }
  $trace = array('PARENT'=>$method.'@'.intval($line),'TIME'=>null,'DEBUG'=>$debug,'SIMULATE'=>$simulate,'ERROR'=>'','QUERY'=>$query,'ROWS'=>0);
  $err = array();

    try {
      if ( !self::$tables_complete && defined('__XF_TABLE_CHECK_DONE') && self::vault_query('mode') !== 'setup' )
      throw new XFE('Not all required tables were found in database');
    $sexec = self::$sql->prepare(trim($query));
      if ( is_array($params) && sizeof($params) > 0 ){
        foreach ( $params as $k=>$v ){
        $sexec->bindValue(':'.$k,$v[0],constant('PDO::PARAM_'.strtoupper($v[1])));
        $trace['PARAM_'.$k] = '['.$v[1].']'.$v[0];
        }
      }
      if ( !$simulate ){
      $time = microtime(true);
      $sexec->execute();
      $err = self::$sql->errorInfo();
      $trace['ROWS'] = ( $sexec ) ? $sexec->rowCount() : null;
      $trace['TIME'] = round(microtime(true)-$time,3);
      }
    $trace['ERROR'] = ( sizeof($err) === 3 ) ? $err[1].' '.$err[2] : null;
    } catch ( PDOException $P ){ try {throw new XFE($P->getMessage());} catch ( XFE $E ){ $E->handle(); } }

  $readonly = ( in_array(substr($sexec->queryString,0,strpos($sexec->queryString,' ')),array('SELECT','SHOW','ANALYZE','VACUUM','LOCK','UNLOCK'),true) ) ? true : false;
    if ( $debug && $readonly ){ // rerun select-statement on debug gathering additional information
    $sdbg = self::$sql->prepare('EXPLAIN '.$query);
      if ( is_array($params) && sizeof($params) > 0 ){
        foreach ( $params as $k=>$v )
        $sdbg->bindValue(':'.$k,$v[0],constant('PDO::PARAM_'.strtoupper($v[1])));
      }
    $sdbg->execute();
    $trace = array_merge($trace,$sdbg->fetch(PDO::FETCH_ASSOC));
    $sdbg->closeCursor();
    }

    if ( XF::DEBUG && $params !== '-' )
    XFDebug::trace(__METHOD__,self::arr2str($trace));
    if ( $readonly )
    return $sexec;
    else
    return intval($sexec->rowCount());
  }

  /**
  * transaction abstraction layer
  * mysql gets a simulation by locking because it (still/actually) lacks transactions *sigh*
  * you should not use nested transactions to allow using databases not support them
  * @param string $class 'begin', 'commit', 'rollback' or 'is_running', may contain a name separated by colon
  * @param array $params additional table locks for databases not supporting transactions
  * @return boolean
  * @since 1.0.0
  */
  public static function sql_transaction($class,$params = array()){
  static $init = false;
  static $canlock = null;
  static $queue = array();
  $class = explode(':',$class);
  $usetr = ( __XF_SQL_ENGINE === 'pgsql' ) ? true : false;
  $o = null;
    if ( is_null(self::$sql) && $class[0] === 'is_running' )
    return false;
    if ( !$usetr && is_null($canlock) ){ // look whether we can lock tables...
      if ( self::vault_query('mode') !== 'setup' ){
      $sloc = self::sql_query("SHOW GRANTS FOR CURRENT_USER",'-',__METHOD__,__LINE__);
      $canlock = false;
        while ( $r = $sloc->fetch(PDO::FETCH_NUM) ){
          if ( strpos($r[0],'LOCK TABLES') && strpos($r[0],'*.*') )
          $canlock = true;
          if ( strpos($r[0],'LOCK TABLES') && strpos($r[0],__XF_SQL_DATABASE) )
          $canlock = true;
        }
      $sloc->closeCursor();
      }
      else
      $canlock = false; // no locking during setup so far...
    }
    elseif ( $usetr && is_null(self::$sql) )
    self::sql_query("SELECT 1",'-',__METHOD__,__LINE__);

    if ( !$init ){
      if ( XF::DEBUG )
      XFDebug::trace(__METHOD__,self::arr2str(array('use_native_transaction'=>$usetr,'emulation_can_lock_table'=>$canlock)));
    $init = true;
    }

    switch ( $class[0] ){
    case 'begin':
      if ( $usetr && sizeof($queue) === 0 )
      $o = self::$sql->beginTransaction();
      elseif ( !$usetr && sizeof($queue) === 0 ){
      $params['log'] = 'w';
      $params['statistic'] = 'w';
      $local = array();
        foreach ( $params as $k=>$v ){
          if ( isset($local[$k]) )
          continue;
        $v = ( $v === 'w' ) ? ' WRITE' : ' READ';
        $local[] = self::tbl($k).$v;
        }
      $o = ( $canlock ) ? self::sql_query("LOCK TABLES ".implode(', ',$local),'',__METHOD__,__LINE__) : true;
      }
      if ( (bool)$o )
      $queue[] = '*put_it_onto_stack*';
    break;
    case 'commit': case 'rollback':
      if ( $usetr && sizeof($queue) > 0 )
      $o = ( $class[0] === 'commit' ) ? self::$sql->commit() : self::$sql->rollBack();
      elseif ( !$usetr && sizeof($queue) > 0 )
      $o = ( $canlock ) ? self::sql_query("UNLOCK TABLES",'',__METHOD__,__LINE__) : true;
      if ( (bool)$o )
      array_pop($queue);
    break;
    case 'is_running':
    $o = ( sizeof($queue) > 0 ) ? true : false;
    break;
    default: break;
    }
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,self::arr2str(array_merge(array('handler'=>$class[0],'queue_length'=>sizeof($queue),'name'=>(isset($class[1]))?$class[1]:null,'return'=>(bool)$o),$params)));
  return $o;
  }

  /**
  * return last inserted id after sql query
  * @param string $a resource descriptor - currently only for postgres
  * @return mixed
  * @since 1.0.0
  */
  public static function sql_lastId($a){
    if ( __XF_SQL_ENGINE === 'mysql' )
    return self::$sql->lastInsertId();
    elseif ( __XF_SQL_ENGINE === 'pgsql' ){
    $a = explode('.',$a);
    return self::$sql->lastInsertId(self::$tbl[$a[0]].'_'.$a[1].'_seq');
    }
  }

}

/**
* we use instances of this class for flag checking in methods.
* this is much faster than in_array() used before...
* @package lbcore
*/
class XFAux_Flags {
protected static $cache = array();
public $okifempty = false;
public $forcestr = false;
public $enforce = false;
public $stripspaces = false;
public $restrict = false;
public $fullascii = false;
public $hex = false;
public $oct = false;
public $length = false;
public $range = false;
public $o = false;
public $pub = false;
public $rw = false;
public $token = false;
public $required = false;

  function __construct($flags){
  $checksum = crc32($flags);
    if ( isset(self::$cache[$checksum]) ){
    $a = self::$cache[$checksum];
      foreach ( $a as $k=>$v )
      $this->$k = $v;
    return true;
    }
  $flags = explode(',',$flags);
    foreach ( $flags as $v ){
    $x = strpos($v,'=');
      if ( $x > 0 ){
      $k = substr($v,0,$x);
      $v = substr($v,$x+1);
      }
      else
      $k = $v;
      if ( $k === 'okifempty' )
      $this->okifempty = true;
      elseif ( $k === 'forcestr' )
      $this->forcestr = true;
      elseif ( $k === 'enforce' )
      $this->enforce = true;
      elseif ( $k === 'stripspaces' )
      $this->stripspaces = true;
      elseif ( $k === 'restrict' )
      $this->restrict = true;
      elseif ( $k === 'fullascii' )
      $this->fullascii = true;
      elseif ( $k === 'hex' )
      $this->hex = true;
      elseif ( $k === 'oct' )
      $this->oct = true;
      elseif ( $k === 'pub' )
      $this->pub = true;
      elseif ( $k === 'rw' )
      $this->rw = true;
      elseif ( $k === 'required' )
      $this->required = true;
      elseif ( $k === 'length' )
      $this->length = explode('-',$v);
      elseif ( $k === 'range' )
      $this->range = $v;
      elseif ( $k === 'token' )
      $this->token = $v;
      elseif ( $k === 'o' ){
        if ( !$this->o )
        $this->o = array();
      $this->o[] = $v;
      }
      else
      continue;
    }
  self::$cache[$checksum] = (array)$this;
  return true;
  }

}

/**
* well, XFE is my little own interpretation of a dump after catching an exception.
* yes, i know my usage is not the real intention of exceptions. it is just another
* way of doing 'trigger_error()' at the moment. the 'getTraceAsString()' is what i like :D
* @package lbcore
*/
class XFE extends Exception {
/**
* @var integer use this flag on 'throw new XFE' as second argument to create a 'system exception'. this is default and makes a 'cold' report listing...
*/
const SYSTEM = 0x01;
/**
* @var integer use this flag to produce a nicer error message intended for users
*/
const USER = 0x02;
/**
* @var boolean abort flag for ajax requests
*/
protected $abort = false;
/**
* @var string user level exception id
*/
protected $ulei = '';

  /**
  * init exception class
  * @param string $msg exception message
  * @param integer $code exception code
  * @param string $add additional id string on USER
  * @return void
  * @since 1.0.0
  */
  public function __construct($msg,$code = self::SYSTEM,$add = ''){
  $this->ulei = $add;
  parent::__construct($msg,$code);
  }

  /**
  * format the exception and include debugging information
  * @return string
  * @since 1.0.0
  */
  protected function system_exception(){
  $o = '<div style="font-size: 1.8em; text-align: center; margin: 0px; color: #a00;">'.htmlspecialchars(parent::getMessage()).'</div><hr />';
  $o .= '<textarea style="width: 100%; height: 400px; background-color: #ffd; border: 0;">';
  $o .= ':: Is it now '.gmdate('r').chr(10);
  $o .= 'An exception raised at '.htmlspecialchars(parent::getFile()).' on line '.intval(parent::getLine()).chr(10);
  $o .= 'Reason: '.htmlspecialchars(parent::getMessage()).chr(10).chr(10);
  $o .= 'We got a stack trace, I\'m now appending:'.chr(10);
  $o .= htmlspecialchars(parent::getTraceAsString()).chr(10).chr(10);
    if ( XF::get_cfg('main_debug_verbose') || XF::DEBUG ){
    $o .= str_repeat('=',72).chr(10);
    $o .= chr(10).'  --- here you can provide additional information...'.chr(10).chr(10);
    $o .= str_repeat('=',72).chr(10);
    $o .= '/!\\ The following paragraphs may contain data violating your privacy /!\\'.chr(10);
    $o .= 'Please check them before sending or remove any text behind this mark...'.chr(10);
    $o .= str_repeat('=',72).chr(10);
    $o .= 'VERSION    :'.XF::VERSION.chr(10);
    $o .= 'HTTP HEADER:'.htmlspecialchars(print_r(headers_list(),true)).chr(10);
    $o .= 'RQST   VARS:'.htmlspecialchars(print_r($_REQUEST,true)).chr(10);
    $o .= 'SERVER VARS:'.htmlspecialchars(print_r($_SERVER,true)).chr(10);
    $o .= 'ENVIRONMENT:'.htmlspecialchars(print_r(XF::get_env(),true)).chr(10);
    $o .= 'CONFIG VARS:'.htmlspecialchars(print_r(XF::arr2str(XF::get_cfg('*')),true)).chr(10);
      if ( XF::DEBUG ){
      $o .= str_repeat('=',72).chr(10);
      $o .= chr(10).trim(strip_tags(XFDebug::trace(null,'return','')));
      }
    }
  $o .= '</textarea>';
  return $o;
  }

  /**
  * handle the exception - default entry point to trigger
  * @return void
  * @since 1.0.0
  */
  public function handle(){
  $ph = array(self::SYSTEM=>'SYSTEM_LEVEL',self::USER=>'USER_LEVEL');
    if ( is_object(XF::$sql) && XF::$sql instanceof PDO ){
    XF::sql_transaction('rollback:exception');
    XF::logger('error','handler',strtr(parent::getCode(),$ph),'id',$this->ulei,'text',parent::getMessage(),
    'request',strip_tags(urldecode(XF::ifset('server','QUERY_STRING','none'))),
    'location',basename(parent::getFile()).':'.parent::getLine()
    );
    XF::statistic('exception');
    }
    if ( XF::vault_query('mode') === 'ajax' ){
      if ( !is_null(XFUI::$ajax_response) ){
      XFUI::$ajax_response->alert('EXCEPTION HANDLER'.chr(10).basename(parent::getFile()).':'.parent::getLine().chr(10).parent::getMessage());
      XFUI::$ajax_response->call('xf_dosubmit',-1);
      }
    $this->abort = true;
    }
    else{
      if ( parent::getCode() === self::USER )
      XF::terminate(parent::getMessage(),true);
      else
      XF::terminate(self::system_exception(),false);
    }
  }

  /**
  * check, if execution is to be aborted
  * @return boolean
  * @since 1.0.0
  */
  public function check_abort(){
  return $this->abort;
  }

}

/**
* any 'action' inherit XFAction must define at least some common methods/vars...
* @package lbcore
*/
abstract class XFAction {
/**
* @var integer what version does this base class implement?
*/
const API_VERSION = 0x01;
/**
* @var integer version number of sibling class
*/
public $version = null;
/**
* @var boolean flag storing success after execution, useful for ajax requests
*/
protected $success = false;
/**
* @var string error message storage, useful for ajax requests
*/
protected $error = '';
/**
* @var array stores user input variables
*/
protected $gpc = array();
/**
* @var array can mark invalid inputs in forms, useful for ajax requests
*/
protected $markgpc = array();

  final public function __construct(){}

  /**
  * main entry point
  * @since 1.0.0
  */
  abstract public function init($a,$b);

  /**
  * run an action on regular basis - called by init()
  * @since 1.0.0
  */
  abstract protected function regular();

  /**
  * entry point for ajax requests - called by init()
  * @since 1.0.0
  */
  abstract protected function ajax($a);

  /**
  * execute the main 'action' the name of a file says
  * @since 1.0.0
  */
  abstract public function execute();

  /**
  * return success to public
  * @since 1.0.0
  */
  final public function get_success(){
  return $this->success;
  }

  /**
  * return error to public
  * @since 1.0.0
  */
  final public function get_error(){
  return $this->error;
  }

  /**
  * return local user input vars to public
  * @since 1.0.0
  */
  final public function get_GPC(){
  return $this->gpc;
  }

  /**
  * return 'invalid gpc form mark' to public
  * @since 1.0.0
  */
  final public function get_mark_GPC(){
  return $this->markgpc;
  }

}

/**
* basic elements to inherit by XFTask for scheduled tasks either...
* @package lbcore
*/
abstract class XFTask {
/**
* @var integer what version does this base class implement?
*/
const API_VERSION = 0x01;
/**
* @var integer version number of sibling class
*/
public $version = null;
/**
* @var array storage for message during task execution
*/
protected $trace = array();

  final public function __construct(){}

  /**
  * is run on scanning for new tasks
  * @since 1.0.0
  */
  abstract public function setup();

  /**
  * is run on normal operation
  * @since 1.0.0
  */
  abstract public function execute($p);

  /**
  * return message queue to public
  * @since 1.0.0
  */
  final public function get_trace(){
  return $this->trace;
  }

}
?>
