<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_log extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  XFUI::load_lang_res('','acpacl');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
    if ( XF::vault_query('request_method') === 'POST' )
    return $this->execute();
  $statistic = XF::sanitize_var(XF::ifset('GET','statistic',0),'booli');
  $format = XF::sanitize_var(XF::ifset('GET','f','png'),'enum','o=png,o=svg');
  $stimage = XF::sanitize_var(XF::ifset('GET','image',0),'booli');
  $stzoom = XF::sanitize_var(XF::ifset('GET','f_zoom','m'),'enum','o=m,o=y');
  $stmonth = XF::sanitize_var(XF::ifset('GET','f_month',gmdate('n')),'int');
  $styear = XF::sanitize_var(XF::ifset('GET','f_year',gmdate('Y')),'int');
  $stdata = XF::sanitize_var(XF::ifset('GET','f_data','posting'),'enum','o=login,o=account,o=password,o=search,o=filter,o=posting,o=exception');
  $this->gpc = array('format'=>$format,'image'=>$stimage,'f_zoom'=>$stzoom,'f_month'=>$stmonth,'f_year'=>$styear,'f_data'=>$stdata);
  unset($format,$stimage,$stzoom,$stmonth,$styear,$stdata);
    if ( $this->gpc['image'] === 1 )
    return $this->statistic_image();

  $statdata = array(
  'login'=>'{:statistic_data_login}',
  'account'=>'{:statistic_data_account}',
  'password'=>'{:statistic_data_password}',
  'search'=>'{:statistic_data_search}',
  'filter'=>'{:statistic_data_filter}',
  'posting'=>'{:statistic_data_posting}',
  'exception'=>'{:statistic_data_exception}'
  );
  $day = array('*');
  $month = array();
  $year = array();
    for ( $i = 1 ; $i <= 31 ; $i++ )
    $day[] = $i;
    for ( $i = 1 ; $i <= 12 ; $i++ )
    $month[$i] = XF::convert_to_utf8(strftime('%B',gmmktime(0,0,0,$i,1,2000)));
    for ( $i = gmdate('Y')-10 ; $i <= gmdate('Y') ; $i++ )
    $year[] = $i;

  XFUI::html_head('{:log_view}');
  XF::$tpl->clear_cache('form_acp_log.tpl');
  XF::$tpl->assign('display_statistic_image',(bool)$statistic);
  XF::$tpl->assign('statistic_data_listing',$statdata);
  XF::$tpl->assign('stat_zoom',$this->gpc['f_zoom']);
  XF::$tpl->assign('stat_month',$this->gpc['f_month']);
  XF::$tpl->assign('stat_year',$this->gpc['f_year']);
  XF::$tpl->assign('stat_data',$this->gpc['f_data']);
  XF::$tpl->assign('current_day',gmdate('j'));
  XF::$tpl->assign('current_month',gmdate('n'));
  XF::$tpl->assign('current_year',gmdate('Y'));
  XF::$tpl->assign('day_listing',$day);
  XF::$tpl->assign('month_listing',$month);
  XF::$tpl->assign('year_listing',$year);
  XF::$tpl->assign('sort_listing',array('u_id'=>XFUI::i18n('username'),'time'=>XFUI::i18n('date'),'level'=>XFUI::i18n('log_level'),'action'=>XFUI::i18n('log_action'),'ip'=>XFUI::i18n('ip_address')));
  XF::$tpl->assign('order_listing',array('asc'=>XFUI::i18n('ascending'),'desc'=>XFUI::i18n('descending')));
  XF::$tpl->assign('skip_svg',(bool)stripos(XF::ifset('server','HTTP_USER_AGENT','unknown'),'msie'));
  XF::$tpl->display('form_acp_log.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * show log results
  * @return true
  * @since 1.0.0
  */
  public function execute(){
  $day = XF::sanitize_var(XF::ifset('POST','f_day',gmdate('j')),'int');
  $month = XF::sanitize_var(XF::ifset('POST','f_month',gmdate('n')),'int');
  $year = XF::sanitize_var(XF::ifset('POST','f_year',gmdate('Y')),'int');
  $level = XF::sanitize_var(XF::ifset('POST','f_level','-'),'enum','o=i,o=e,o=-');
  $user = XF::sanitize_var(XF::ifset('POST','f_user',0),'int');
  $ip = XF::sanitize_var(XF::ifset('POST','f_ip',''),'ip','okifempty');
  $sort = XF::sanitize_var(XF::ifset('POST','f_sort','time'),'enum','o=u_id,o=time,o=level,o=action,o=ip');
  $order = XF::sanitize_var(XF::ifset('POST','f_order','desc'),'enum','o=asc,o=desc');
  $this->gpc = array('f_day'=>$day,'f_month'=>$month,'f_year'=>$year,'f_level'=>$level,'f_user'=>$user,'f_ip'=>$ip,
  'f_sort'=>$sort,'f_order'=>$order);
  unset($day,$month,$year,$level,$user,$ip,$sort,$order);

  $wq = array();
  $data = array();
  $group = XF::get_group('*');
    switch ( $this->gpc['f_level'] ){
    case 'i': $wq[] = "l_level = 'info'"; break;
    case 'e': $wq[] = "l_level = 'error'"; break;
    default: $wq[] = "l_level != 'system'"; break;
    }
    if ( $this->gpc['f_user'] !== 0 )
    $wq[] = 'l_u_id = '.$this->gpc['f_user'];
    if ( $this->gpc['f_ip'] !== '' ){
    XF::sql_query('SELECT 1','',__FILE__,__LINE__);
    $wq[] = 'l_ip = '.XF::$sql->quote(XFUI::ip_transform($this->gpc['f_ip'],'encode'));
    }

    if ( $this->gpc['f_day'] === 0 ){
    $t = gmmktime(0,0,0,$this->gpc['f_month'],1,$this->gpc['f_year']);
    $day_begin = 1;
    $day_end = gmdate('t',$t);
    }
    else
    $day_begin = $day_end = (int)$this->gpc['f_day'];

    if ( !checkdate($this->gpc['f_month'],$day_begin,$this->gpc['f_year']) ){
    $this->gpc['f_day'] = gmdate('d');
    $this->gpc['f_month'] = gmdate('m');
    $this->gpc['f_year'] = gmdate('Y');
    }

  $tss = mktime(0,0,0,$this->gpc['f_month'],$day_begin,$this->gpc['f_year']);
  $tse = mktime(23,59,59,$this->gpc['f_month'],$day_end,$this->gpc['f_year']);
  $wq = ( sizeof($wq) > 0 ) ? ' AND '.implode(' AND ',$wq) : '';
  $q = "SELECT * FROM ".XF::tbl('log')."
  WHERE l_index_month = :month AND l_index_year = :year AND l_time BETWEEN :days AND :daye $wq
  ORDER BY l_".$this->gpc['f_sort']." ".$this->gpc['f_order'];
  $slog = XF::sql_query($q,array(
  'days'=>array($tss,'int'),
  'daye'=>array($tse,'int'),
  'month'=>array($this->gpc['f_month'],'int'),
  'year'=>array($this->gpc['f_year'],'int')),__METHOD__,__LINE__);
    while ( $r = $slog->fetchObject() ){
    $action = explode(',',$r->l_action);
    $user = XF::get_user($r->l_u_id);
    $r->l_ip = XFUI::ip_transform($r->l_ip);
    $r->u_name = $user['u_name'];
    $r->g_name = $group[$user['u_group']]['g_name'];
    $r->g_color = $group[$user['u_group']]['g_color'];
    $r->level_str = 'log_level_'.$r->l_level;
    $r->method = $action[0];
    $r->action = $action[1];
    $r->action_str = 'acl_seg_'.$r->action;
    XF::logger_parse_message($r);
    unset($r->l_action);
    $data[] = (array)$r;
    }
  $slog->closeCursor();
  XFUI::html_head('{:log_view}');
  XF::$tpl->clear_cache('acp_log_results.tpl');
  XF::$tpl->assign('result_start_time',$tss);
  XF::$tpl->assign('result_end_time',$tse);
  XF::$tpl->assign('log_listing',$data);
  XF::$tpl->display('acp_log_results.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * draw a image from statisic log
  * @return true
  * @since 1.0.0
  */
  protected function statistic_image(){
  require_once(XF::vault_query('root_path').'/class.image.php');
  $vmin = 0;
  $vmax = 0;
  $vsum = 0;
  $data = array();
  $select = array();
  $output = $this->gpc['format'];
  $img = new XFImage();
    if ( !$img->enabled() && $output === 'png' )
    return false;

    switch ( $this->gpc['f_data'] ){
    case 'login':
    $select[0] = 'st_login_attempt';
    $select[1] = 'st_login_success';
    break;
    case 'account':
    $select[0] = 'st_account_register';
    $select[1] = 'st_account_activation';
    break;
    case 'password':
    $select[0] = 'st_password_request';
    $select[1] = 'st_password_activation';
    break;
    case 'search':
    $select[0] = 'st_search_query';
    $select[1] = 'st_search_cached';
    break;
    case 'filter':
    $select[0] = 'st_filter_ham';
    $select[1] = 'st_filter_spam';
    break;
    case 'posting':
    $select[1] = 'st_submit_posting';
    break;
    case 'exception':
    $select[1] = 'st_exception';
    break;
    }
  $ptr = ( sizeof($select) === 2 ) ? 0 : 1;
    if ( $this->gpc['f_zoom'] === 'm' ){
    $select[9] = 'st_day';
    $ssta = XF::sql_query("SELECT ".implode(',',$select)." FROM ".XF::tbl('statistic')."
    WHERE st_year = :year AND st_month = :month ORDER BY st_day",array(
    'month'=>array($this->gpc['f_month'],'int'),
    'year'=>array($this->gpc['f_year'],'int')),__METHOD__,__LINE__);
    array_pop($select);
      while ( $r = $ssta->fetchObject() ){
/*      $a = 0;
      $r = (array)$r;
        foreach ( $select as $v ){
        $r[$v] = intval($r[$v]);
        $a += $r[$v];
        }
        if ( $a > $vmax )
        $vmax = $a;*/
        if ( $r->$select[$ptr] > $vmax )
        $vmax = $r->$select[$ptr];
      $data[$r->st_day] = (array)$r;
      }
    $ssta->closeCursor();
    }
    elseif ( $this->gpc['f_zoom'] === 'y' ){
    $q = array();
    $select[9] = 'st_month';
      foreach ( $select as $k=>$v ){
        if ( $k === 0 || $k === 1 )
        $q[] = 'SUM('.$v.') AS '.$v;
      }
    $a = array_pop($select);
    $ssta = XF::sql_query("SELECT $a,".implode(',',$q)." FROM ".XF::tbl('statistic')."
    WHERE st_year = :year GROUP BY st_month ORDER BY st_month",
    array('year'=>array($this->gpc['f_year'],'int')),__METHOD__,__LINE__);
      while ( $r = $ssta->fetchObject() ){
/*      $a = 0;
      $r = (array)$r;
        foreach ( $select as $v ){
        $r[$v] = intval($r[$v]);
        $a += $r[$v];
        }
        if ( $a > $vmax )
        $vmax = $a;*/
        if ( $r->$select[$ptr] > $vmax )
        $vmax = $r->$select[$ptr];
      $data[$r->st_month] = (array)$r;
      }
    $ssta->closeCursor();
    }
  define('__XF_IMG_WIDTH',900);
  define('__XF_IMG_HEIGHT',300);
  define('__XF_IMG_MARGIN',30);
  define('__XF_IMG_SCALE',10);
  define('__XF_IMG_VALUE_MIN',(int)$vmin);
  define('__XF_IMG_VALUE_MAX',self::nextstep($vmax));
  define('__XF_IMG_ABS_MAX',(int)$vmax);
  self::yaxismap(array(__XF_IMG_VALUE_MIN,__XF_IMG_VALUE_MAX,__XF_IMG_HEIGHT-(2*__XF_IMG_MARGIN)),'set');
  unset($a,$q,$vmin,$vmax,$ptr);
  //D($data);

  $ptr = $img->create(__XF_IMG_WIDTH,__XF_IMG_HEIGHT,'antialias=yes');
  $img->color($ptr,0xaa,0xaa,0xff,1,'lightblue');
  $img->color($ptr,0xff,0xf1,0xff,1,'pearl');
  $img->color($ptr,0xdd,0xdd,0xdd,1,'silver');
  $img->color($ptr,0x00,0x00,0x00,0.2,'semiblack');
  $img->background($ptr,'white');
  $img->border($ptr,'black');
  $img->use_filter(XFImage::FILTER_GRADIENT,'DrawableArea,20,80,pearl,white');
  $img->filledrectangle($ptr,__XF_IMG_MARGIN,__XF_IMG_MARGIN,__XF_IMG_WIDTH-__XF_IMG_MARGIN,__XF_IMG_HEIGHT-__XF_IMG_MARGIN,'pearl');
  $img->reset_filter();

    for ( $i = 1 ; $i <= __XF_IMG_SCALE ; $i++ ){ // y-axis values
    $j = round(($i/__XF_IMG_SCALE)*__XF_IMG_VALUE_MAX);
    $img->use_filter(XFImage::FILTER_LINE_STRONG);
    $img->line($ptr,__XF_IMG_MARGIN,self::yaxismap($j),__XF_IMG_WIDTH-__XF_IMG_MARGIN,self::yaxismap($j),'silver');
    $img->reset_filter();
    $img->string($ptr,4,5,self::yaxismap($j)-7,$j,'black');
    }

    if ( $this->gpc['f_zoom'] === 'm' ){ // x-axis values
    define('__XF_IMG_ITEM',ceil((__XF_IMG_WIDTH-(2*__XF_IMG_MARGIN))/33));
    $img->string($ptr,5,700,0,XF::convert_to_utf8(strftime('%B %Y',mktime(0,0,0,$this->gpc['f_month'],1,$this->gpc['f_year']))),'black');
    $loop = 31;
    }
    elseif ( $this->gpc['f_zoom'] === 'y' ){
    define('__XF_IMG_ITEM',ceil((__XF_IMG_WIDTH-(2*__XF_IMG_MARGIN))/13));
    $img->string($ptr,5,700,0,XF::convert_to_utf8(strftime('%Y',mktime(0,0,0,$this->gpc['f_month'],1,$this->gpc['f_year']))),'black');
    $loop = 12;
    }

    for ( $i = 1 ; $i <= $loop ; $i++ ){ // now loop through the data
    $k = ($i*__XF_IMG_ITEM)+__XF_IMG_MARGIN;
    $img->line($ptr,$k,__XF_IMG_MARGIN,$k,__XF_IMG_HEIGHT-__XF_IMG_MARGIN,'silver');

      if ( $this->gpc['f_zoom'] === 'm' ){
      $j = ( $i <= date('t',mktime(0,0,0,$this->gpc['f_month'],1,$this->gpc['f_year'])) ) ? 'black' : 'silver';
        if ( $j === 'black' && (int)date('w',mktime(0,0,0,$this->gpc['f_month'],$i,$this->gpc['f_year'])) === 0 )
        $j = 'red';
      $img->string($ptr,4,$k-5,__XF_IMG_HEIGHT-25,$i,$j);
      }
      elseif ( $this->gpc['f_zoom'] === 'y' )
      $img->string($ptr,4,$k-12,__XF_IMG_HEIGHT-25,XF::convert_to_utf8(strftime('%b',mktime(0,0,0,$i,1,$this->gpc['f_year']))),'black');

      if ( isset($select[0]) && isset($select[1]) ){
        if ( isset($data[$i]) && $data[$i][$select[0]] > 0 ){
        $img->use_filter(XFImage::FILTER_SMOOTH_EDGE);
        $img->filledrectangle($ptr,$k-5+2,self::yaxismap($data[$i][$select[0]]),$k+5+2,self::yaxismap(0),'semiblack');
          if ( $data[$i][$select[0]] > $data[$i][$select[1]] )
          $img->filledrectangle($ptr,$k-5,self::yaxismap($data[$i][$select[0]]),$k+5,self::yaxismap($data[$i][$select[1]]),'lightblue');
        $img->filledrectangle($ptr,$k-5,self::yaxismap($data[$i][$select[1]]),$k+5,self::yaxismap(0),'blue');
        $vsum += $data[$i][$select[0]]+$data[$i][$select[1]];
        $img->reset_filter();
        }
      }
      elseif ( isset($select[1]) ){
        if ( isset($data[$i]) && $data[$i][$select[1]] > 0 ){
        $img->use_filter(XFImage::FILTER_SMOOTH_EDGE);
        $img->filledrectangle($ptr,$k-5+2,self::yaxismap($data[$i][$select[1]])+2,$k+5+2,self::yaxismap(0),'semiblack');
        $img->filledrectangle($ptr,$k-5,self::yaxismap($data[$i][$select[1]]),$k+5,self::yaxismap(0),'blue');
        $vsum += $data[$i][$select[1]];
        $img->reset_filter();
        }
      }
    }

    if ( isset($select[0]) ){
    $img->filledrectangle($ptr,50,5,55,10,'lightblue');
    $img->string($ptr,2,60,0,XFUI::i18n($select[0]),'black');
    }
    if ( isset($select[1]) ){
    $img->filledrectangle($ptr,50,15,55,20,'blue');
    $img->string($ptr,2,60,10,XFUI::i18n($select[1]),'black');
    }

  $img->string($ptr,2,700,18,XFUI::i18n('total').': '.$vsum,'black');
  $img->string($ptr,2,__XF_IMG_WIDTH-24,__XF_IMG_HEIGHT-12,$output,'black');
  $img->line($ptr,__XF_IMG_MARGIN,__XF_IMG_MARGIN,__XF_IMG_MARGIN,__XF_IMG_HEIGHT-__XF_IMG_MARGIN,'black'); // y-axis line
  $img->line($ptr,__XF_IMG_MARGIN,__XF_IMG_HEIGHT-__XF_IMG_MARGIN,__XF_IMG_WIDTH-__XF_IMG_MARGIN,__XF_IMG_HEIGHT-__XF_IMG_MARGIN,'black'); // x-axis line
  $img->output($ptr,$output);
  return true;
  }

  /**
  * calculate the y-coord (height) of values in diagram
  * @param double $a value
  * @param string $b 'set' margins (min,max) on first run or 'get' a calculation
  * @return mixed
  * @since 1.0.0
  */
  protected static function yaxismap($a,$b = 'get'){
  static $min = 0;
  static $max = 0;
  static $da = 0;
    if ( $b === 'set' ){
    $min = $a[0];
    $max = $a[1];
    $da = $a[2];
    return true;
    }
    elseif ( $b === 'get' ){
      if ( $a < $min )
      $a = $min;
      if ( $a > $max )
      $a = $max;
    $z = $max-$min;
    $c = ( $z > 0 ) ? ($a-$min)/$z : 0;
    $c = __XF_IMG_HEIGHT-__XF_IMG_MARGIN-($c*$da);
    return $c;
    }
  }

  /**
  * find next multiple of 10 on input value
  * @param integer $a input value
  * @return integer
  * @since 1.0.0
  */
  protected function nextstep($a){
    if ( $a <= 10 )
    return 10;
    while ( true ){
      if ( $a%10 === 0 )
      break;
    $a++;
    }
  return (int)$a;
  }

}
?>