<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFLog provides a general-purpose logging facility
* @package lbbackend
*/
class XFLog {
/**
* @var integer mapped id for IPv4 entries
*/
const IP_IS_V4 = 0x01;
/**
* @var integer mapped id for IPv6 entries
*/
const IP_IS_V6 = 0x02;
/**
* @var string error level
*/
protected $level = 'info';
/**
* @var string buffer for error message
*/
protected $buffer = '';
/**
* @var string ip address
*/
protected $ip = '';
/**
* @var string ip address type
*/
protected $ip_type = 0x00;

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * sets a logging level
  * @param string $a use level 'info' or 'error'
  * @return boolean
  * @since 1.0.0
  */
  public function set_level($a){
    if ( XF::sanitize_var($a,'enum','o=system,o=info,o=error') ){
    $this->level = $a;
    return true;
    }
    else
    return false;
  }

  /**
  * set a logging message
  * @param string $a text message, can be array
  * @return true
  * @since 1.0.0
  */
  public function set_message($a){
    if ( is_array($a) )
    $a = implode(' ',$a);
  $this->buffer = str_replace('"',"'",$a);
  return true;
  }

  /**
  * set an ip-address
  * @param string $a the ip address
  * @param integer $b type of ip address, 0=autodetect
  * @return boolean
  * @since 1.0.0
  */
  public function set_ip($a,$b=0x00){
    if ( XF::sanitize_var($a,'ip') ){
    $this->ip = $a;
      if ( $b === 0x00 )
      $this->ip_type = ( strstr($a,':') ) ? self::IP_IS_V6 : self::IP_IS_V4;
      else
      $this->ip_type = $b;
    return true;
    }
    else
    return false;
  }

  /**
  * reset any settings
  * @return true
  * @since 1.0.0
  */
  public function reset(){
  $this->level = 'info';
  $this->buffer = '';
  $this->ip = '';
  $this->ip_type = 0x00;
  return true;
  }

  /**
  * dump prepared data array for writing
  * @return array
  * @since 1.1.0
  */
  public function dump(){
  return $this->prepare();
  }

  /**
  * write a log entry to our database
  * @return true
  * @since 1.0.0
  */
  public function log_to_db(){
  $l = $this->prepare();
    if ( $this->ip_type === self::IP_IS_V4 )
    $l['ip'] = ip2long($l['ip']);
  XF::sql_query("INSERT INTO ".XF::tbl('log')." (l_u_id,l_index_month,l_index_year,l_level,l_ip,l_time,l_action,l_text) VALUES (:userid,:month,:year,:level,:ip,:time,:action,:message)",
  array('userid'=>array($l['user'],'int'),
  'month'=>array($l['month'],'int'),
  'year'=>array($l['year'],'int'),
  'level'=>array($l['level'],'str'),
  'ip'=>array($l['ip'],'str'),
  'time'=>array($l['time'],'int'),
  'action'=>array($l['action'],'str'),
  'message'=>array($l['message'],'str')),__METHOD__,__LINE__);
  return true;
  }

  /**
  * write a log entry to archive file on local filesystem
  * @param string $f target format: txt or xml
  * @return true
  * @since 1.0.0
  */
  public function log_to_file($f){
    if ( !in_array($f,array('txt','xml'),true) )
    $f = 'txt';
  $l = $this->prepare();
  $l['message'] = str_replace("\n"," ",$l['message']);
  $rf = array('{$MONTH}'=>$l['month'],'{$YEAR}'=>$l['year'],'{$EXTENSION}'=>$f,'{$ROOT_PATH}'=>XF::get_cfg('root_path'));
  $fn = XF::sanitize_var(strtr(XF::get_cfg('log_parameter'),$rf),'path');
  unset($l['month'],$l['year']);
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,$fn);
    if ( !file_exists($fn) && is_writeable(dirname($fn)) )
    touch($fn);
    if ( file_exists($fn) && is_writeable($fn) ){
    $o = '';
      if ( $f === 'xml' )
      $o .= '<entry>'.chr(10);
      foreach ( $l as $k=>$v ){
        if ( $f === 'txt' )
        $o .= $k.'="'.$v.'" ';
        elseif ( $f === 'xml' )
        $o .= chr(9).'<'.$k.'>'.urlencode($v).'</'.$k.'>'.chr(10);
      }
      if ( $f === 'xml' )
      $o .= '</entry>';
    XF::file_handler($fn,trim($o).chr(10),'write,local,noroot,append');
    }
  return true;
  }

  /**
  * write a log entry to syslog daemon
  * @return true
  * @since 1.0.0
  */
  public function log_to_syslog(){
  static $sock = null;
  $l = $this->prepare();
  $l['message'] = str_replace("\n"," ",$l['message']);
  unset($l['month'],$l['year'],$l['level']);
  $o = '';
    if ( is_null($sock) )
    $sock = openlog('Larus Board',LOG_NDELAY|LOG_PID,LOG_USER);
    foreach ( $l as $k=>$v )
    $o .= $k.'="'.$v.'" ';
    switch ( $this->level ){
    case 'system': $lvl = LOG_DEBUG; break;
    case 'info': $lvl = LOG_INFO; break;
    case 'error': $lvl = LOG_ERR; break;
    }
  syslog($lvl,trim($o));
  return true;
  }

  /**
  * prepare data for storage
  * @return array
  * @since 1.0.0
  */
  protected function prepare(){
  $o = array(
  'user'=>( $this->level === 'system' ) ? XF::get_cfg('main_guest_uid') : XF::vault_query('current_user_id'),
  'month'=>gmdate('m'),
  'year'=>gmdate('Y'),
  'level'=>$this->level,
  'ip'=>$this->ip,
  'time'=>XF::vault_query('uts'),
  'action'=>XF::vault_query('request_method').','.XF::vault_query('request_action'),
  'message'=>$this->buffer
  );
  return $o;
  }

}
?>