/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
/* <![CDATA[ */
var XFJSV_TEMP_COUNTER = 0;
var XFJSV_TEMP_THRESHOLD = Math.round(XFJSV_POST_MAXLEN/50);
var XFJSV_LIVEDIT_TEXT_NAME = 'f_message';
var XFJSV_FADING_NAME = '';
var XFJSV_FADING_TARGET = '';
var XFJSV_FADING_STACK = '';
var XFJSB_RELEASE_LOCK = false;

// transform "input" method args to an array
function xf_var2arr(input){
var o = new Array();
var i = 0;
var mod = 0;
  for ( i = 0 ; i < input.length ; i++ ){
  mod = i/2;
  mod = mod.toString().indexOf('.');
    if ( mod == -1 )
    o[input[i]] = input[i+1];
  }
return o;
}

// display the current time in nav panel and refresh it regularly
function xf_clock(){
var v = new Date();
document.getElementById('xf__clock').innerHTML = v.toLocaleString();
window.setTimeout('xf_clock()',15000); // 15 secs should be enough :)
}

// perform some actions on form submit; before "turn=1" and after "turn=-1"
function xf_dosubmit(turn){
  if ( turn === undefined )
  return false;
  if ( turn == 1 && !XFJSV_DEBUG ){
  document.getElementById('xf__sbtn').disabled = true;
  document.getElementById('xf__sbtn').style.opacity = '0.2';
  document.getElementById('xf__sbtn').innerHTML += '<!--#--><br /><img src="'+XFJSV_LOADING_GIF+'" alt="loading" />';
  window.setTimeout('xf_release_submit()',15000);
  XFJSB_RELEASE_LOCK = true;
  }
  else if ( turn == -1 && !XFJSV_DEBUG ){
  var cn = document.getElementById('xf__sbtn').innerHTML;
  var ci = cn.indexOf('<!--#-->');
    if ( ci !== -1 )
    document.getElementById('xf__sbtn').innerHTML = cn.substring(0,ci);
  document.getElementById('xf__sbtn').disabled = false;
  document.getElementById('xf__sbtn').style.opacity = '1';
  XFJSB_RELEASE_LOCK = false;
  }
}

// release lock of submit button after some time, if has not been done before...
function xf_release_submit(){
  if ( XFJSB_RELEASE_LOCK )
  xf_dosubmit(-1);
}

// hash a password, set the result to hidden field and empty the plain version, if "doclear" is "1".
function xf_hash_password(fname,doclear){
  if ( doclear === undefined )
  doclear = 0;
var a = hex_sha1(document.getElementById(fname).value);
document.getElementById(fname+'_hash').value = hex_sha1(a);
  if ( doclear === 1 )
  document.getElementById(fname).value = '';
}

// set visibility of the block "objname"; disable fading by "nofade=nofade".
function xf_visibility(objname,useopt,nofade){
// can only animate one box at a time - should be enough...
var fade_out = new Array(1.0,0.9,0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.0);
var fade_in  = new Array(0.0,0.15,0.3,0.45,0.6,0.75,0.9,0.75,0.6,0.45,0.3,0.45,0.6,0.75,0.9,1.0);
var ua = navigator.userAgent.toLowerCase();
var olds = null;
var news = null;
  if ( nofade === undefined )
  nofade = '';
  if ( ua.indexOf('msie') != -1 ) // no fading by opacity on msie
  nofade = 'nofade';

  if ( useopt == '' ){
  olds = document.getElementById(objname).style.display;
    if ( olds == 'block' || olds == 'inline-block' || olds == 'inline' )
    news = 'none';
    else if ( olds == 'none' )
    news = 'block';
  }
  else
  news = useopt;

  if ( nofade != 'nofade' && XFJSV_FADING_STACK == '' ){
  XFJSV_FADING_NAME = objname;
  XFJSV_FADING_TARGET = news;
  XFJSV_FADING_STACK = ( news == 'block' || news == 'inline-block' || news == 'inline' ) ? fade_in : fade_out;
  xf_fading();
  }
  else
  document.getElementById(objname).style.display=news;
}

// do the fading of an object by iterating through an array having transparency values
function xf_fading(){
var op = XFJSV_FADING_STACK.shift();
op = op.toString();
document.getElementById(XFJSV_FADING_NAME).style.opacity = op;
  if ( XFJSV_FADING_STACK.length > 0 ){
    if ( op == 0 )
    document.getElementById(XFJSV_FADING_NAME).style.display = XFJSV_FADING_TARGET;
  window.setTimeout('xf_fading()',100); // 100ms for smooth animation
  }
  else{
    if ( op == 0 )
    document.getElementById(XFJSV_FADING_NAME).style.display = XFJSV_FADING_TARGET;
  XFJSV_FADING_NAME = '';
  XFJSV_FADING_TARGET = '';
  XFJSV_FADING_STACK = '';
  }
}

// toggle "advanced options" on a form; basically hide the link box and make the options visible...
function xf_toggle_advanced_options(){
xf_visibility('f_post_adv_option_1','none','nofade');
xf_visibility('f_post_adv_option_2','block','nofade');
}

// toggle a "subpage" of a form by select list; basically display one block and hide all others...
function xf_toggle_subpage(stack){
var a = '';
var i = 0;
  for ( i = 0 ; i < stack.length ; i++ ){
  a = ( stack.selectedIndex == i ) ? 'block' : 'none';
  xf_visibility(stack[i].value,a,'nofade');
  }
}

// add a system message shown on acp overview panel
function xf_addsysmsg(msg){
var a = document.getElementById('xf__acp_system_message').innerHTML;
var b = '';
  if ( a.length == 0 )
  b = '';
  else
  b = '<hr />';
document.getElementById('xf__acp_system_message').innerHTML = a+b+msg;
xf_visibility('xf__acp_system_message','block');
}

// disable the acl field in "action.post_topic.php", if a subject prefix is chosen.
function xf_post_form_acl(acl){
  if ( acl === undefined )
  acl = 'yes';
  if ( acl == '' ){
  document.getElementById('f_acl').value = '';
  document.getElementById('f_acl').disabled = false;
  }
  else{
  document.getElementById('f_acl').value = acl;
  document.getElementById('f_acl').disabled = true;
  }
}

// initial hook function for message parser on "action.post_*.php" forms
function xf_msghook(fname){
  if ( fname.createTextRange )
  fname.caretPos = document.selection.createRange().duplicate();
xf_msglength(fname);
}

// calculate the length of the string
function xf_msglength(fname){
XFJSV_TEMP_COUNTER++;
  if ( XFJSV_TEMP_COUNTER === XFJSV_TEMP_THRESHOLD ){
  XFJSV_TEMP_COUNTER = 0; // perform threshold calculation every 1/50 of max length
  xf_msgthreshold(fname);
  }
}

// display the "threshold bar", whether the maximum string length is reached.
function xf_msgthreshold(fname){
var clen = document.getElementById(fname).value.length;
var pct = Math.round((clen/XFJSV_POST_MAXLEN)*100);
var ibc = '';
  if ( pct > 100 )
  pct = 100;
  if ( pct === 100 )
  ibc = '#000';
  else if ( pct >= 80 )
  ibc = '#f00';
  else if ( pct >= 60 )
  ibc = '#f90';
  else if ( pct >= 40 )
  ibc = '#ff0';
  else if ( pct >= 20 )
  ibc = '#9f0';
  else
  ibc = '#0f0';
document.getElementById('xf__msgfill__'+fname).style.width = pct+'%';
document.getElementById('xf__msgfill__'+fname).style.backgroundColor = ibc;
}

// insert a string on current caret position
function xf_bbcode_insert(text,popup){
var textarea = null;
var caret_pos = 0;
var sel_start = 0;
var sel_end = 0;
  if ( popup )
  textarea = window.opener.document.getElementById(XFJSV_LIVEDIT_TEXT_NAME);
  else
  textarea = document.getElementById(XFJSV_LIVEDIT_TEXT_NAME);

  if ( textarea.createTextRange && !isNaN(textarea.caretPos) ){
  caret_pos = textarea.caretPos;
  caret_pos.text = caret_pos.text.charAt(caret_pos.text.length - 1) === ' ' ? caret_pos.text + text + ' ' : caret_pos.text + text;
  }
  else if ( !isNaN(textarea.selectionStart) ){
  sel_start = textarea.selectionStart;
  sel_end = textarea.selectionEnd;
  xf_mozWrap(textarea,text,'');
  textarea.selectionStart = sel_start + text.length;
  textarea.selectionEnd = sel_end + text.length;
  }
  else
  textarea.value += text;
}

// insert begin and end tag on current selection
function xf_bbcode_replace(opentag,closetag,popup){
var textarea = null;
var selection = '';
  if ( popup )
  textarea = window.opener.document.getElementById(XFJSV_LIVEDIT_TEXT_NAME);
  else
  textarea = document.getElementById(XFJSV_LIVEDIT_TEXT_NAME);
var ua = navigator.userAgent.toLowerCase();
textarea.focus();
  if ( (ua.indexOf('msie')!=-1) && (ua.indexOf('opera')==-1) ){
  selection = document.selection.createRange().text;
    if ( selection ){
    document.selection.createRange().text = opentag + selection + closetag;
    textarea.focus();
    selection = '';
    return;
    }
  }
  else if ( textarea.selectionEnd && ( textarea.selectionEnd - textarea.selectionStart > 0 ) ){
  xf_mozWrap(textarea,opentag,closetag);
  textarea.focus();
  selection = '';
  return;
  }
xf_bbcode_insert(opentag+closetag,popup);
textarea.focus();
xf_msghook(textarea);
return;
}

/**
* From http://www.massless.org/mozedit/
*/
function xf_mozWrap(textarea,open,close){
var selLength = textarea.textLength;
var selStart = textarea.selectionStart;
var selEnd = textarea.selectionEnd;
var scrollTop = textarea.scrollTop;
  if ( selEnd === 1 || selEnd === 2 )
  selEnd = selLength;
var s1 = (textarea.value).substring(0,selStart);
var s2 = (textarea.value).substring(selStart,selEnd)
var s3 = (textarea.value).substring(selEnd,selLength);
textarea.value = s1 + open + s2 + close + s3;
textarea.selectionStart = selEnd + open.length + close.length;
textarea.selectionEnd = textarea.selectionStart;
textarea.focus();
textarea.scrollTop = scrollTop;
return;
}

/* ]]> */