<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_task_list extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $id = XF::sanitize_var(XF::ifset('get','id',''),'str','okifempty,restrict');
  $scan = XF::sanitize_var(XF::ifset('get','scan',0),'booli');
  $this->gpc = array('id'=>$id,'scan'=>$scan);
  unset($id,$scan);

  $nt = array();
  $data = array();
  $tasks = array();
  $cmd = array();
  $stsk = XF::sql_query("SELECT ct_command,ct_active FROM ".XF::tbl('config_task')." ORDER BY ct_command",'',__METHOD__,__LINE__);
    while ( $r = $stsk->fetchObject() ){
    $tasks[] = array('name'=>$r->ct_command,'active'=>(bool)$r->ct_active,'_str'=>'{:task_seg_'.$r->ct_command.'}');
    $cmd[] = $r->ct_command;
    }
  $stsk->closeCursor();

    if ( $this->gpc['scan'] ){
    $d = scandir(XF::vault_query('root_path'));
      foreach ( $d as $v ){
      $k = array();
        if ( preg_match('/^task\.([a-z0-9_]{1,16})\.php$/Du',$v,$k) ){
        $_t = null;
        $cn = 'XFTask_'.$k[1];
          if ( !defined('__XF_ALLOW_TASK') )
          define('__XF_ALLOW_TASK',1);
        require_once(XF::vault_query('root_path').'/'.$v);
        $i = ( $_t instanceof $cn && is_subclass_of($cn,'XFTask') && method_exists($cn,'setup') ) ? $_t->setup() : array();
          if ( !in_array($k[1],$cmd,true) && isset($i['default_parameter']) && isset($i['default_interval']) && isset($i['default_active']) ){
          XF::sql_query("INSERT INTO ".XF::tbl('config_task')." (ct_command,ct_parameter,ct_time_interval,ct_active) VALUES (:cmd,:param,:interval,:active)",array(
          'cmd'=>array($k[1],'str'),
          'param'=>array($i['default_parameter'],'str'),
          'interval'=>array((int)$i['default_interval'],'int'),
          'active'=>array((bool)$i['default_active'],'str')),__METHOD__,__LINE__);
          $nt[] = $k[1];
          }
        }
      }
    unset($d,$k,$v);
    }

    if ( $this->gpc['id'] !== '' ){
    $stsk = XF::sql_query("SELECT * FROM ".XF::tbl('config_task')." WHERE ct_command = :id",array(
    'id'=>array($this->gpc['id'],'str')),__METHOD__,__LINE__);
    $data = (array)$stsk->fetchObject();
    $data['description'] = 'task_explain_'.$data['ct_command'];
    $data['ct_time_next'] = intval($data['ct_time_last']+$data['ct_time_interval']);
    $stsk->closeCursor();
    XFUI::ajax_init();
    }

  XF::tan('acp_task_edit');
  XFUI::html_head('{:scheduled_task}');
  XF::$tpl->clear_cache('form_acp_task.tpl');
  XF::$tpl->assign('new_task',implode(',',$nt));
  XF::$tpl->assign('scan_task',$this->gpc['scan']);
  XF::$tpl->assign('selected_task',$this->gpc['id']);
  XF::$tpl->assign('task_listing',$tasks);
  XF::$tpl->assign('task_data',$data);
    if ( isset($data['ct_command']) )
    XF::$tpl->assign('task_name',XFUI::lang_str('{:task_seg_'.$data['ct_command'].'}'));
  XF::$tpl->display('form_acp_task.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * list scheduled tasks (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>