<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_reply extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','post');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $id = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $quote = XF::sanitize_var(XF::ifset('get','quote',0),'int');
  $this->gpc = array('id'=>$id,'quote'=>$quote);
  unset($id,$quote);

  $newmsg = '';
  $pp = XFUI::get_post_prefix_list();
  $schk = XF::sql_query("SELECT p_closed,p_subject,p_pp_id,p_acl FROM ".XF::tbl('post_meta')." WHERE p_id = :id AND p_is_topic = true",
  array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
  $topicdata = $schk->fetchObject();
  $schk->closeCursor();
    if ( !is_object($topicdata) || (bool)$topicdata->p_closed )
    XFUI::html_redirect(-1,XF::link('topic',array('id'=>$this->gpc['id'])));

    try {
    $a = array('attr'=>array('prefix'=>$topicdata->p_pp_id,'acl'=>$topicdata->p_acl));
      if ( !XFUI::topic_access($a,$pp) )
      throw new XFE(XFUI::i18n('access_denied'),XFE::USER,'NO_ACCESS_TO_TOPIC');
    } catch ( XFE $E ){ $E->handle(); }

    if ( $this->gpc['quote'] !== 0 ){ // is the user going to quote a message?
    $group = XF::get_group();
    $sa = ( !$group['g_read_unapproved'] ) ? 'AND p_approved = true' : '';
    $schk = XF::sql_query("SELECT p_topic_id,p_u_id,p_time,pd_text FROM ".XF::tbl('post_meta')."
    LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_p_id = p_id
    WHERE p_id = :id AND pd_is_last = true $sa",
    array('id'=>array($this->gpc['quote'],'int')),__METHOD__,__LINE__);
    $postdata = $schk->fetchObject();
    $postdata->p_topic_id = intval($postdata->p_topic_id);
    $postdata->p_time = intval($postdata->p_time);
    $cache = XFCache::topic($postdata->p_topic_id);
    $user = XF::get_user((int)$postdata->p_u_id);
    $schk->closeCursor();
      if ( is_object($postdata) && is_array($cache) && is_array($user) && XFUI::topic_access($cache,$pp) )
      $newmsg = '[quote]'.'[link='.$this->gpc['quote'].'] ('.$user['u_name'].' @ '.XF::date($postdata->p_time,'%d.%m.%Y').')[hr]'.preg_replace('/\[code(=\w+)*\].+?\[\/code\]/siu','',$postdata->pd_text).'[/quote]';
    }

  XF::tan('post_reply');
  XFUI::ajax_init();
  XFUI::html_head('{:new_reply}');
  XF::$tpl->clear_cache('form_post_reply.tpl');
  XF::$tpl->assign('topicid',$this->gpc['id']);
  XF::$tpl->assign('quoteid',$this->gpc['quote']);
  XF::$tpl->assign('new_subject','Re: '.$topicdata->p_subject);
  XF::$tpl->assign('new_message',$newmsg);
  XF::$tpl->assign('default_approvement',XFUI::get_post_approvement());
  XF::$tpl->assign('smilie_listing',XFCache::get('simple','smilies'));
  XF::$tpl->display('form_post_reply.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $stage = XF::sanitize_var(XF::ifset($input,'stage',''),'enum','o=,o=preview,o=submit');
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $quoteid = XF::sanitize_var(XF::ifset($input,'quote_id',0),'int');
  $pss = XF::sanitize_var(XF::ifset($input,'f_subject',''),'str','length=8-128');
  $psm = XF::sanitize_var(XF::ifset($input,'f_message',''),'strwbr','length=40-'.XF::POST_MAXLEN);
  $pst = XF::sanitize_var(XF::ifset($input,'f_tags',''),'str','okifempty');
  $this->gpc = array('stage'=>$stage,'id'=>$id,'quoteid'=>$quoteid,'f_subject'=>$pss,'f_message'=>$psm,'f_tags'=>$pst);
  $this->markgpc = array('f_subject','f_message','f_tags');
  return true;
  }

  /**
  * preview message text
  * @return string
  * @since 1.0.0
  */
  public function preview(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  return XFParser::message($this->gpc['f_message']);
  }

  /**
  * submit a new reply on a topic
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  $sf = '';
  $force_invisible = false;
  $user = XF::get_user();
  $group = XF::get_group();
  $pp = XFUI::get_post_prefix_list();
    try {
    $schk = XF::sql_query("SELECT p_topic_id,p_closed FROM ".XF::tbl('post_meta')." WHERE p_id = :id AND p_is_topic = true",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $topicdata = $schk->fetchObject();
    $schk->closeCursor();
    $schk = XF::sql_query("SELECT p_u_id FROM ".XF::tbl('post_meta')." WHERE p_topic_id = :id
    ORDER BY p_time DESC LIMIT 1 OFFSET 0",array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $lastpost = $schk->fetchObject();
    $schk->closeCursor();
      if ( !is_object($topicdata) )
      $this->error = '{:no_valid_id}';
      else{
      $a = XFCache::topic($topicdata->p_topic_id);
      $b = XFCache::topic($this->gpc['id']);
        if ( !XFUI::topic_access($a,$pp) )
        $this->error = '{:access_denied}';
        if ( (bool)$topicdata->p_closed && empty($this->error) )
        $this->error = '{:cannot_reply_as_topic_is_closed}';
        if ( is_object($lastpost) && (bool)$group['g_post_repeat'] === false && (int)$lastpost->p_u_id === XF::vault_query('current_user_id') && empty($this->error) )
        $this->error = '{:not_allowed_to_submit_repeated_posting}';
        if ( !XFUI::topic_access($b,$pp) )
        $this->error = '{:not_allowed_to_access_the_topic}';
        if ( XF::get_cfg('filter_enable') && $group['g_post_filter'] && XF::get_cfg('filter_spam_action') !== 'accept' ){
        $sf = XF::spam_filter('','',$this->gpc['f_message']);
          if ( is_bool($sf->result_cache) ){
            if ( $sf->result_cache ){
              if ( XF::get_cfg('filter_spam_action') === 'mark' )
              $force_invisible = true;
              elseif ( XF::get_cfg('filter_spam_action') === 'reject' )
              $this->error = '{:your_posting_has_been_filtered_as_spam}';
            }
          $sf->save();
          }
        }
        if ( !$group['g_moderator'] && !$group['g_executive'] )
        $this->gpc['f_message'] = preg_replace('/\[notice\].+?\[\/notice\]/siu','',$this->gpc['f_message']);
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_meta'=>'w','post_data'=>'w','tag_meta'=>'w','tag_data'=>'w','user'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $vis = ( $force_invisible ) ? 0 : (int)XFUI::get_post_approvement();
      $sm = XF::spam_result_to_marker($sf);
      XF::sql_query("INSERT INTO ".XF::tbl('post_meta')." (p_is_topic,p_u_id,p_time,p_approved,p_license,p_subject) VALUES ('0',:userid,:date,:approved,:license,:subject)",
      array('userid'=>array(XF::vault_query('current_user_id'),'int'),
      'date'=>array(XF::vault_query('uts'),'int'),
      'approved'=>array($vis,'str'),
      'license'=>array($user['u_post_license'],'str'),
      'subject'=>array($this->gpc['f_subject'],'str')),__METHOD__,__LINE__);
      $newpostid = XF::sql_lastId('post_meta.p_id');
        if ( !$newpostid )
        throw new XFE('new post (meta) could not be inserted');
      XF::sql_query("INSERT INTO ".XF::tbl('post_data')." (pd_p_id,pd_time,pd_spam_marker,pd_text) VALUES (:postid,:date,:spam,:message)",
      array('postid'=>array($newpostid,'int'),
      'date'=>array(XF::vault_query('uts'),'int'),
      'spam'=>array($sm,'int'),
      'message'=>array($this->gpc['f_message'],'str')),__METHOD__,__LINE__);
      $newmessid = XF::sql_lastId('post_data.pd_id');
        if ( !$newmessid )
        throw new XFE('new post (data) could not be inserted');
      $qid = ( $this->gpc['quoteid'] !== 0 && isset($b['tree'][$this->gpc['quoteid']]) ) ? $this->gpc['quoteid'] : $this->gpc['id'];
      XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_topic_id = :id, p_parent_id = :parentid, p_pd_id = :msgid WHERE p_id = :postid AND p_is_topic = false",
      array('postid'=>array($newpostid,'int'),
      'parentid'=>array($qid,'int'),
      'id'=>array($this->gpc['id'],'int'),
      'msgid'=>array($newmessid,'int')),__METHOD__,__LINE__);
      XF::sql_query("UPDATE ".XF::tbl('user')." SET u_post_count = u_post_count+1 WHERE u_id = :userid",
      array('userid'=>array(XF::vault_query('current_user_id'),'int')),__METHOD__,__LINE__);
      require_once(XF::vault_query('root_path').'/class.parser.php');
        if ( !XFParser::tag_management($newpostid,$this->gpc['f_tags']) )
        throw new XFE('tags of post could not be set');
      XF::logger('info','new_postid',$newpostid,'new_msgid',$newmessid,'is_approved',XF::bool2yn($vis));
      ( $sm <= 1 ) ? XF::statistic('submit_posting,filter_ham') : XF::statistic('submit_posting,filter_spam');
      XF::sql_transaction('commit');
        if ( $vis ){
        $cache = XFCache::get('simple','post_recent');
          if ( is_array($cache) && in_array($this->gpc['id'],$cache,true) && XF::$tpl->is_cached('overview_recent_posts.tpl') )
          XF::$tpl->clear_cache('overview_recent_posts.tpl');
        XFCache::purge('rss',$this->gpc['id']);
        }
        else
        XFCache::purge('rss',XF::RSS_MOD_UNAPPROVE);
      XFCache::statistic('post','rebuild');
      $cache = XFCache::topic($this->gpc['id']);
      XFCache::topic_delta($cache,'add_reply',array('id'=>$newpostid,'approve'=>$vis,'time'=>XF::vault_query('uts'),'user'=>XF::vault_query('current_user_id')));
      XFCache::put('topic',$this->gpc['id'],$cache);
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_reply($input){
  $a = new XFAction_post_reply();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
    if ( $b['stage'] === 'preview' ){
    XFUI::$ajax_response->script('xf_visibility(\'f_post_preview\',\'block\',\'nofade\');');
    XFUI::$ajax_response->assign('f_post_preview','innerHTML',$a->preview());
    }
    elseif ( $b['stage'] === 'submit' ){
    $a->execute();
      if ( $a->get_success() )
      return xfaf_success(XF::link('topic',array('post'=>$b['id']),false),'{:new_reply_successfully_posted}');
      else
      return xfaf_failure($a->get_error());
    }
  }

?>