;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-config-set-string!
  (lambda (key value)
    (c-lw6cfg-set-option key value)
    )
  )

(define lw6-config-get-string
  (lambda (key)
    (c-lw6cfg-get-option key)
    )
  )

(define lw6-config-set-number!
  (lambda (key value)
    (begin
      (c-lw6cfg-set-option key (number->string value))
      )
    )
  )

(define lw6-config-get-number
  (lambda (key)
    (string->number (c-lw6cfg-get-option key))
    )
  )

(define lw6-config-set-boolean!
  (lambda (key value)
    (c-lw6cfg-set-option key (if value "true" "false"))
    )
  )

(define lw6-config-is-true?
  (lambda (key)
    (equal? (c-lw6cfg-get-option key) "true")
    )
  )

(define lw6-config-map-options-defaults
  (lambda ()
    (map (lambda (key) (lw6-config-set-number! key (c-lw6map-options-get-default key))) (c-lw6hlp-list-map-options))    
      ))

(define lw6-config-map-style-defaults
  (lambda ()
    (map (lambda (key) (lw6-config-set-string! key (c-lw6map-style-get-default key))) (c-lw6hlp-list-map-style))    
      ))

(define lw6-config-defaults
  (lambda ()
    (begin 
      (lw6-config-set-string! "user-dir" (c-lw6sys-get-user-dir))
      (lw6-config-set-string! "log-file" (c-lw6sys-get-log-file))
      (lw6-config-set-string! "map-path" "")
      (lw6-config-set-boolean! "fullscreen" (c-lw6sys-build-is-ms-windows))
      (lw6-config-set-boolean! "display-fps" #t)
      (lw6-config-set-number! "width" 0)
      (lw6-config-set-number! "height" 0)
      (lw6-config-set-number! "music-volume" 0.8)
      (lw6-config-set-number! "sound-volume" 0.8)
      (lw6-config-set-string! "player1-name" (c-lw6sys-get-username))
      (lw6-config-set-string! "player2-name" (string-join (list (_ "player2") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-string! "player3-name" (string-join (list (_ "player3") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-string! "player4-name" (string-join (list (_ "player4") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-number! "log-level" (c-lw6sys-log-get-level))
      (lw6-config-set-number! "max-frames-per-sec" 60)
      (lw6-config-set-number! "max-logic-per-sec" 100)
      (lw6-config-set-number! "max-io-per-sec" 15)
      (lw6-config-set-number! "max-logic-per-display" 10)
      (lw6-config-set-number! "max-io-per-display" 2)
      (lw6-config-set-number! "checkpoint-period" 1000)
      (lw6-config-set-number! "loader-sleep" 0.1)
      (lw6-config-set-number! "memory-bazooka-size" 100)
      (lw6-config-set-boolean! "memory-bazooka-eraser" #t)

      (lw6-config-set-string! "chosen-map" "strange-new-world")

      (lw6-config-set-boolean! "use-map-options" #t)
      (lw6-config-set-boolean! "use-map-style" #t)
      (lw6-config-set-boolean! "force-time" #f)
      (lw6-config-set-boolean! "force-size" #f)
      (lw6-config-set-boolean! "force-background" #f)
      (lw6-config-set-boolean! "force-hud" #f)
      (lw6-config-set-boolean! "force-menu" #f)
      (lw6-config-set-boolean! "force-view" #f)
      (lw6-config-set-boolean! "force-team-colors" #f)
      
      (lw6-config-map-options-defaults)
      (lw6-config-map-style-defaults)
      )
    )
  )

(define lw6-load-config 
  (lambda () 
    (begin
      (lw6-config-defaults)
      (c-lw6cfg-load (c-lw6sys-get-config-file))
      (c-lw6cfg-save (c-lw6sys-get-config-file))
      (c-lw6cfg-load (c-lw6sys-get-config-file))      
      )
    )
  )

(define lw6-config-update-video
  (lambda ()
    (let (
	  (res (c-lw6gfx-get-video-mode))
	  )
      (begin
	(lw6-config-set-number! "width" (assoc-ref res "width"))
	(lw6-config-set-number! "height" (assoc-ref res "height"))
	(lw6-config-set-boolean! "fullscreen" (assoc-ref res "fullscreen"))
	))))

(define lw6-save-config 
  (lambda () 
    (c-lw6cfg-save (c-lw6sys-get-config-file))))

(define lw6-config-subset
  (lambda (key-list)
    (let* ((target (list)))
	  (begin
	    (map (lambda (key) (set! target (assoc-set! target key (lw6-config-get-string key)))) key-list)	    
	    target))))
      
(define lw6-default-map-options
  (lambda ()
    (lw6-config-subset (c-lw6hlp-list-map-options))))

(define lw6-default-map-style
  (lambda ()
    (lw6-config-subset (c-lw6hlp-list-map-style))))

(define lw6-forced-map-options
  (lambda ()
    (lw6-config-subset 
     (if (lw6-config-is-true? "use-map-options") 
	 (append (if (lw6-config-is-true? "force-time")
		     (list "total-time"
			   "respawn-time"
			   "moves-per-round"
			   "spreads-per-round"
			   "rounds-per-sec")
		     (list))
		 (if (lw6-config-is-true? "force-size")
		     (list "min-map-width"
			   "max-map-width"
			   "min-map-height"
			   "max-map-height"
			   "min-map-surface"
			   "max-map-surface")
		     (list)))
	 (c-lw6hlp-list-map-options)))))

(define lw6-forced-map-style
  (lambda ()
    (lw6-config-subset 
     (if (lw6-config-is-true? "use-map-style") 
	 (append (if (lw6-config-is-true? "force-background")
		     (list "use-texture"
			   "background-style"
			   "background-density"
			   "background-speed"
			   "colorize-background"
			   "background-color-auto"
			   "background-color-base"
			   "background-color-alternate")
		     (list))
		 (if (lw6-config-is-true? "force-hud")
		     (list "hud-style"
			   "hud-color-auto"
			   "hud-color-frame"
			   "hud-color-text")
		     (list))
		 (if (lw6-config-is-true? "force-menu")
		     (list "menu-style"
			   "menu-color-auto"
			   "menu-color-default"
			   "menu-color-selected"
			   "menu-color-disabled")
		     (list))
		 (if (lw6-config-is-true? "force-view")
		     (list "keep-ratio"
			   "zoom"
			   "fighter-scale"
			   "view-style"
			   "view-color-auto"
			   "view-color-cursor"
			   "viwe-color-map")
		     (list))
		 (if (lw6-config-is-true? "force-team-colors")
		     (list "team-color-red"
			   "team-color-green"
			   "team-color-blue "
			   "team-color-yellow"
			   "team-color-cyan"
			   "team-color-magenta"
			   "team-color-orange"
			   "team-color-lightblue"
			   "team-color-purple"
			   "team-color-pink")
		     (list)))
	 (c-lw6hlp-list-map-style)))))

