;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define %lw6-menu-stack
  '()
  )

(define lw6-empty-menu-stack?
  (lambda ()
    (equal? '() %lw6-menu-stack)
    ))

(define lw6-menu-warp-mouse
  (lambda ()
    (let ((menu (lw6-current-menu)))
      (if menu
	  (c-lw6gfx-warp-mouse-on-menuitem (assoc-ref menu "smob") (assoc-ref menu "selected-item") (lw6-get-game-global "look"))))))

(define lw6-push-menu 
  (lambda (menu)
    (begin 
      ((lw6-menu-action "on-push-child"))
      (set! %lw6-menu-stack (cons menu %lw6-menu-stack))
      ((lw6-menu-action "on-push"))
      (lw6-menu-warp-mouse)
      ((lw6-menuitem-action "on-select"))
      )))

(define lw6-pop-menu 
  (lambda ()
    (begin
      ((lw6-menu-action "on-pop"))
      (set! %lw6-menu-stack (cdr %lw6-menu-stack))
      ((lw6-menu-action "on-pop-child"))
      (let (
	    (menu (lw6-current-menu))
	    )
	(if menu
	    (lw6-menu-warp-mouse)
	    )))))

(define lw6-current-menu 
  (lambda ()
    (if (lw6-empty-menu-stack?)
	#f
	(car %lw6-menu-stack)
	)))

(define lw6-current-menuitem
  (lambda ()
    (let (
	  (current-menu (lw6-current-menu))
	  )
      (if current-menu
	  (list-ref (assoc-ref current-menu "items")
		    (assoc-ref current-menu "selected-item"))))))

(define lw6-set-menuitem!
  (lambda (i warp-mouse)
    (let (
	  (menuitem (lw6-current-menuitem))
	  )
      (if menuitem
	  (let* (
		 (menu (lw6-current-menu))
		 (items (assoc-ref menu "items"))
		 (selected-item (assoc-ref menu "selected-item"))
		 (nb-items (length items))
		 (new-selected-item (max 0 (min i (- nb-items 1))))
		 )
	    (if (= selected-item new-selected-item)
		#f
		(begin
		  (lw6-play-sound-beep-select)
		  ((lw6-menuitem-action "on-unselect"))
		  (assoc-set! menu "selected-item" new-selected-item)
		  (lw6-menu-sync menu)
		  ((lw6-menuitem-action "on-select"))
		  (if warp-mouse (lw6-menu-warp-mouse))
		  #t
		  )))))))

(define lw6-prev-menuitem
  (lambda (warp-mouse)
    (let (
	  (menu (lw6-current-menu))
	  (menuitem (lw6-current-menuitem))
	  )
      (if menuitem
	  (lw6-set-menuitem! (- (assoc-ref menu "selected-item") 1) warp-mouse)
	  ))))

(define lw6-next-menuitem
  (lambda (warp-mouse)
    (let (
	  (menu (lw6-current-menu))
	  (menuitem (lw6-current-menuitem))
	  )
      (if menuitem
	  (lw6-set-menuitem! (+ (assoc-ref menu "selected-item") 1) warp-mouse)
	  ))))

(define lw6-menu-action
  (lambda (action)
    (if (not (lw6-empty-menu-stack?))
	(
	 (lambda (f) 
	   (if f 
	       f 
	       (lambda() #f)
	       )
	   )
	 (assoc-ref (lw6-current-menu) action))
	(lambda () #f))))

(define lw6-menuitem-action
  (lambda (action)
    (let (
	  (menuitem (lw6-current-menuitem))
	  )
      (if menuitem
	  (
	   (lambda (f) 
	     (if f 
		 f 
		 (lambda() #f)
		 )
	     )
	   (assoc-ref menuitem action))
	  (lambda () #f)))))

(define lw6-menu-template
  (lambda (title)
    (list
     (cons "smob" (c-lw6gui-menu-new title))
     (cons "selected-item" 0)
     (cons "items" (list))
     (cons "on-pop" (lambda () #t))
     (cons "on-push" (lambda () #t))
     (cons "on-push-child" (lambda () #t))
     (cons "on-pop-child" (lambda () #t))
     (cons "on-cancel" lw6-pop-menu))))

(define lw6-menu-item-template
  (lambda (label)
    (list
     (cons "label" label)
     (cons "value" 0)
     (cons "enabled" #t)
     (cons "selected" #f)
     (cons "colored" #f)
     (cons "on-valid" (lambda () #t))
     (cons "on-plus" (lambda () #t))
     (cons "on-minus" (lambda () #t))
     (cons "on-select" (lambda () #t))
     (cons "on-unselect" (lambda () #t)))))

(define lw6-menu-item-template-switch
  (lambda (label-func on-plus on-minus)
    (let (
	  (item (lw6-menu-item-template (label-func)))
	  )
      (begin
	(assoc-set! item "on-valid" 
		    (lambda ()		      
		      (let (
			    (menu (assoc-ref (lw6-current-menu) "smob"))
			    (menuitem (lw6-current-menuitem))
			    )
			(begin
			  (on-plus)
			  (assoc-set! menuitem "label" (label-func))
			  (c-lw6gui-menu-sync menu menuitem)))))
	(assoc-set! item "on-plus" 
		    (lambda ()		      
		      (let (
			    (menu (assoc-ref (lw6-current-menu) "smob"))
			    (menuitem (lw6-current-menuitem))
			    )
			(begin
			  (on-plus)
			  (assoc-set! menuitem "label" (label-func))
			  (c-lw6gui-menu-sync menu menuitem)))))
	(assoc-set! item "on-minus" 
		    (lambda ()		      
		      (let (
			    (menu (assoc-ref (lw6-current-menu) "smob"))
			    (menuitem (lw6-current-menuitem))
			    )
			(begin
			  (on-minus)
			  (assoc-set! menuitem "label" (label-func))
			  (c-lw6gui-menu-sync menu menuitem)))))
	item))))

(define lw6-append-menuitem!
  (lambda (menu menuitem)
    (let (
	  (id (c-lw6gui-menu-append (assoc-ref menu "smob") menuitem))
	  )
      (assoc-set! menu "items" (append (assoc-ref menu "items") (list (assoc-set! menuitem "id" id)))))))

(define lw6-menu-sync
  (lambda (menu)
    (c-lw6gui-menu-select (assoc-ref menu "smob") 
			  (assoc-ref menu "selected-item"))
    ))

(define lw6-menu-pump-keys
  (lambda ()
    (let
	(
	 (menu (lw6-current-menu))
	 (key (c-lw6gfx-poll-key))
	 )
      (if
       (and menu key)
       (begin
					;(display key)
	 (cond 
	  (
	   (c-lw6gfx-is-key-esc (assoc-ref key "keysym"))
	   (if
	    ((lw6-menu-action "on-cancel"))
	    (lw6-play-sound-beep-valid)
	    )
	   )
	  (
	   (c-lw6gfx-is-key-enter (assoc-ref key "keysym"))
	   (if
	    ((lw6-menuitem-action "on-valid"))
	    (lw6-play-sound-beep-valid)
	    )	    
	   )
	  (
	   (c-lw6gfx-is-key-right (assoc-ref key "keysym"))
	   (if
	    ((lw6-menuitem-action "on-plus"))
	    (lw6-play-sound-beep-valid)
	    )	    
	   )
	  (
	   (c-lw6gfx-is-key-left (assoc-ref key "keysym"))
	   (if
	    ((lw6-menuitem-action "on-minus"))
	    (lw6-play-sound-beep-valid)
	    )	    
	   )
	  (
	   (c-lw6gfx-is-key-up (assoc-ref key "keysym"))
	   (if
	    (lw6-prev-menuitem #t)
	    (lw6-play-sound-beep-select)
	    )
	   )
	  (
	   (c-lw6gfx-is-key-down (assoc-ref key "keysym"))
	   (if
	    (lw6-next-menuitem #t)
	    (lw6-play-sound-beep-select)
	    ))))))))

(define lw6-menu-pump-joystick
  (lambda ()
    (let
	(
	 (menu (lw6-current-menu))
	 )
      (if
       menu
       (cond 
	((or
	  (c-lw6gfx-poll-joystick-button 0 1)
	  (c-lw6gfx-poll-joystick-button 1 1))
	 (if
	  ((lw6-menu-action "on-cancel"))
	  (lw6-play-sound-beep-valid)
	  )
	 )
	((or
	  (c-lw6gfx-poll-joystick-button 0 0)
	  (c-lw6gfx-poll-joystick-button 1 0))
	 (if
	  ((lw6-menuitem-action "on-valid"))
	  (lw6-play-sound-beep-valid)
	  ) 
	 )
	((or
	  (c-lw6gfx-poll-joystick-right 0)
	  (c-lw6gfx-poll-joystick-right 1))
	 (if
	  ((lw6-menuitem-action "on-plus"))
	  (lw6-play-sound-beep-valid)
	  ) 
	 )
	((or
	  (c-lw6gfx-poll-joystick-left 0)
	  (c-lw6gfx-poll-joystick-left 1))
	 (if
	  ((lw6-menuitem-action "on-minus"))
	  (lw6-play-sound-beep-valid)
	  ) 
	 )
	((or
	  (c-lw6gfx-poll-joystick-up 0)
	  (c-lw6gfx-poll-joystick-up 1))
	 (if
	  (lw6-prev-menuitem #t)
	  (lw6-play-sound-beep-select)
	  )
	 )
	((or
	  (c-lw6gfx-poll-joystick-down 0)
	  (c-lw6gfx-poll-joystick-down 1))
	 (if
	  (lw6-next-menuitem #t)
	  (lw6-play-sound-beep-select)
	  )))))))

(define lw6-menu-pump-mouse
  (lambda ()
    (let
	(
	 (move (c-lw6gfx-poll-mouse-move))
	 (button-left (c-lw6gfx-poll-mouse-button-left))
	 (button-right (c-lw6gfx-poll-mouse-button-right))
	 (wheel-up (c-lw6gfx-poll-mouse-wheel-up))
	 (wheel-down (c-lw6gfx-poll-mouse-wheel-down))
	 (mouse-state (c-lw6gfx-get-mouse-state))
	 (menu (lw6-current-menu))
	 )
      (if menu
	  (begin
	    (let* (
		   (x (if move (assoc-ref move "x") (assoc-ref mouse-state "x")))
		   (y (if move (assoc-ref move "y") (assoc-ref mouse-state "y")))
		   (pick (c-lw6gfx-pick-menuitem (assoc-ref menu "smob") x y (lw6-get-game-global "look")))
		   (position (assoc-ref pick "position"))
		   (scroll (assoc-ref pick "scroll"))
		   (changed #f)
		   )
	      (begin
		(if (and move (>= position 0))
		    (lw6-set-menuitem! position #f))
		(if (> scroll 0)
		    (lw6-next-menuitem #f))
		(if (< scroll 0)
		    (lw6-prev-menuitem #f)))
	    (if button-left
		(begin
		  (lw6-play-sound-beep-valid)
		  ((lw6-menuitem-action "on-valid"))))
	    (if button-right 
		(begin (lw6-play-sound-beep-valid)
		       ((lw6-menu-action "on-cancel"))))
	    (if wheel-up
		(begin (c-lw6gui-menu-scroll-up (assoc-ref menu "smob"))
		       (lw6-prev-menuitem #t)))
	    (if wheel-down
		(begin (c-lw6gui-menu-scroll-down (assoc-ref menu "smob"))
		       (lw6-next-menuitem #t)))))))))

(define lw6-menu
  (lambda () 
    (begin 
      (if (lw6-empty-menu-stack?)
	  (lw6-init-menu)
	  )
      (lw6-menu-pump-keys)
      (lw6-menu-pump-joystick)
      (lw6-menu-pump-mouse)
      (let (
	    (loader (lw6-get-game-global "loader"))
	    )
	(if loader
	    (let (
		  (loaded (c-lw6tsk-loader-pop loader))
		  )
	      (if loaded
		  (begin
		    (lw6-set-game-global! "loaded" loaded)
		    (lw6-set-game-global! "look" (c-lw6map-get-look (assoc-ref loaded "level")))
		    )
		  )
	      ))))))
