;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-config-set-string!
  (lambda (key value)
    (c-lw6cfg-set-option key value)
    )
  )

(define lw6-config-get-string
  (lambda (key)
    (c-lw6cfg-get-option key)
    )
  )

(define lw6-config-set-number!
  (lambda (key value)
    (begin
      (c-lw6cfg-set-option key (number->string value))
      )
    )
  )

(define lw6-config-get-number
  (lambda (key)
    (string->number (c-lw6cfg-get-option key))
    )
  )

(define lw6-config-set-boolean!
  (lambda (key value)
    (c-lw6cfg-set-option key (if value "true" "false"))
    )
  )

(define lw6-config-is-true?
  (lambda (key)
    (equal? (c-lw6cfg-get-option key) "true")
    )
  )

(define lw6-config-change-boolean!
  (lambda (key)
    (c-lw6cfg-set-option key (if (lw6-config-is-true? key) "false" "true"))
    )
  )

(define lw6-config-map-rules-defaults
  (lambda ()
    (map (lambda (key) (lw6-config-set-number! key (c-lw6map-rules-get-default key))) (c-lw6hlp-list-map-rules))    
      ))

(define lw6-config-map-hints-defaults
  (lambda ()
    (map (lambda (key) (lw6-config-set-string! key (c-lw6ldr-hints-get-default key))) (c-lw6hlp-list-map-hints))    
      ))

(define lw6-config-map-style-defaults
  (lambda ()
    (map (lambda (key) (lw6-config-set-string! key (c-lw6map-style-get-default key))) (c-lw6hlp-list-map-style))    
      ))

(define lw6-config-defaults
  (lambda ()
    (begin 
      (lw6-config-set-string! lw6def-user-dir (c-lw6sys-get-user-dir))
      (lw6-config-set-string! lw6def-log-file (c-lw6sys-get-log-file))
      (lw6-config-set-string! lw6def-map-path "")
      (lw6-config-set-boolean! lw6def-fullscreen (c-lw6sys-build-is-ms-windows))
      (lw6-config-set-boolean! lw6def-preset-resolution 1)
      (lw6-config-set-number! lw6def-windowed-mode-limit 0.91)
      (lw6-config-set-boolean! lw6def-display-fps #f)
      (lw6-config-set-boolean! lw6def-display-console #f)
      (lw6-config-set-number! lw6def-width 0)
      (lw6-config-set-number! lw6def-height 0)
      (lw6-config-set-string! lw6def-gfx-backend (lw6-get-default-gfx-backend))
      (lw6-config-set-number! lw6def-music-volume 0.8)
      (lw6-config-set-number! lw6def-sound-volume 0.8)
      (lw6-config-set-string! lw6def-snd-backend (lw6-get-default-snd-backend))
      (lw6-config-set-string! lw6def-player1-name (c-lw6sys-get-username))
      (lw6-config-set-string! lw6def-player2-name (string-join (list (_ "player2") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-string! lw6def-player3-name (string-join (list (_ "player3") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-string! lw6def-player4-name (string-join (list (_ "player4") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-boolean! lw6def-player1-status #t)
      (lw6-config-set-boolean! lw6def-player2-status #t)
      (lw6-config-set-boolean! lw6def-player3-status #f)
      (lw6-config-set-boolean! lw6def-player4-status #f)
      (lw6-config-set-string! lw6def-player1-control "mouse")
      (lw6-config-set-string! lw6def-player2-control "keyboard")
      (lw6-config-set-string! lw6def-player3-control "joystick1")
      (lw6-config-set-string! lw6def-player4-control "joystick2")
      (lw6-config-set-string! lw6def-player1-bot "")
      (lw6-config-set-string! lw6def-player2-bot "")
      (lw6-config-set-string! lw6def-player3-bot "idiot")
      (lw6-config-set-string! lw6def-player4-bot "random")
      (lw6-config-set-string! lw6def-player1-color "red")
      (lw6-config-set-string! lw6def-player2-color "green")
      (lw6-config-set-string! lw6def-player3-color "blue")
      (lw6-config-set-string! lw6def-player4-color "yellow")
      (lw6-config-set-number! lw6def-mouse-sensitivity 1.0)
      (lw6-config-set-number! lw6def-joystick-sensitivity 1.0)
      (lw6-config-set-number! lw6def-keyboard-sensitivity 1.0)
      (lw6-config-set-number! lw6def-max-joystick-cursor-speed 10.0)
      (lw6-config-set-number! lw6def-max-keyboard-cursor-speed 10.0)
      (lw6-config-set-number! lw6def-key-repeat-delay 500)
      (lw6-config-set-number! lw6def-key-repeat-interval 100)      
      (lw6-config-set-number! lw6def-joystick1-index 0)
      (lw6-config-set-number! lw6def-joystick1-button-a 0)
      (lw6-config-set-number! lw6def-joystick1-button-b 1)
      (lw6-config-set-number! lw6def-joystick2-index 1)
      (lw6-config-set-number! lw6def-joystick2-button-a 0)
      (lw6-config-set-number! lw6def-joystick2-button-b 1)
      (lw6-config-set-string! lw6def-custom-up "(lw6gfx-get-key-state 101)") ; SDLK_e
      (lw6-config-set-string! lw6def-custom-down "(lw6gfx-get-key-state 100)") ; SDLK_d
      (lw6-config-set-string! lw6def-custom-left "(lw6gfx-get-key-state 99)") ; SDLK_c
      (lw6-config-set-string! lw6def-custom-right "(lw6gfx-get-key-state 118)") ; SDLK_v
      (lw6-config-set-string! lw6def-custom-esc "(lw6gfx-get-key-state 304)") ; SDLK_LSHIFT
      (lw6-config-set-string! lw6def-custom-enter "(lw6gfx-get-key-state 306)") ; SDLK_LCTRL
      (lw6-config-set-number! lw6def-log-level (c-lw6sys-log-get-level))
      (lw6-config-set-number! lw6def-frames-per-sec 60)
      (lw6-config-set-number! lw6def-io-per-sec 15)
      (lw6-config-set-number! lw6def-commands-per-sec 5)
      (lw6-config-set-number! lw6def-checkpoint-period 1000)
      (lw6-config-set-number! lw6def-loader-sleep 0.05)
      (lw6-config-set-number! lw6def-pilot-sleep 0.002)
      (lw6-config-set-number! lw6def-pilot-lag 10)
      (lw6-config-set-number! lw6def-memory-bazooka-size 1000)
      (lw6-config-set-boolean! lw6def-memory-bazooka-eraser #t)
      (lw6-config-set-number! lw6def-bot-speed 1.0)
      (lw6-config-set-number! lw6def-bot-iq 100)

      (lw6-config-set-string! lw6def-chosen-map "strange-new-world")

      (lw6-config-set-boolean! lw6def-use-texture #t)
      (lw6-config-set-boolean! lw6def-use-rules-xml #t)
      (lw6-config-set-boolean! lw6def-use-hints-xml #t)
      (lw6-config-set-boolean! lw6def-use-style-xml #t)
      (lw6-config-set-string! lw6def-force "respawn-team,color-conflict-mode")
      (lw6-config-set-boolean! lw6def-demo #f)      
      (lw6-config-set-boolean! lw6def-quick-start #f)      
      (lw6-config-map-rules-defaults)
      (lw6-config-map-hints-defaults)
      (lw6-config-map-style-defaults)
      )
    )
  )

(define lw6-load-config 
  (lambda () 
    (begin
      (lw6-config-defaults)
      (c-lw6cfg-load (c-lw6sys-get-config-file))
      (c-lw6cfg-save (c-lw6sys-get-config-file))
      (c-lw6cfg-load (c-lw6sys-get-config-file))      
      )
    )
  )

(define lw6-config-update-video
  (lambda ()
    (let (
	  (res (c-lw6gfx-get-video-mode))
	  (low-res (c-lw6gfx-get-low-resolution))
	  (high-res (c-lw6gfx-get-high-resolution))
	  )
      (begin
	(lw6-config-set-number! lw6def-width (assoc-ref res lw6def-width))
	(lw6-config-set-number! lw6def-height (assoc-ref res lw6def-height))
	(lw6-config-set-boolean! lw6def-fullscreen (assoc-ref res lw6def-fullscreen))
	(cond
	 (
	  (<= (lw6-res-surface res) (lw6-res-surface low-res))
	  (lw6-config-set-number! lw6def-preset-resolution 0)
	  )
	 (
	  (>= (lw6-res-surface res) (lw6-res-surface high-res))
	  (lw6-config-set-number! lw6def-preset-resolution 2)
	  )
	 (
	  #t
	  (lw6-config-set-number! lw6def-preset-resolution 1)	  
	 ))))))

(define lw6-save-config 
  (lambda () 
    (c-lw6cfg-save (c-lw6sys-get-config-file))))

(define lw6-config-subset
  (lambda (key-list)
    (let* ((target (list)))
	  (begin
	    (map (lambda (key) (set! target (assoc-set! target key (lw6-config-get-string key)))) key-list)	    
	    target))))
      
(define lw6-default-map
  (lambda ()
    (lw6-config-subset (list lw6def-use-texture
			     lw6def-use-rules-xml
			     lw6def-use-hints-xml
			     lw6def-use-style-xml))))

(define lw6-default-map-rules
  (lambda ()
    (lw6-config-subset (c-lw6hlp-list-map-rules))))

(define lw6-default-map-hints
  (lambda ()
    (lw6-config-subset (c-lw6hlp-list-map-hints))))

(define lw6-default-map-style
  (lambda ()
    (lw6-config-subset (c-lw6hlp-list-map-style))))

(define lw6-default-param
  (lambda ()
    (append (lw6-default-map) (lw6-default-map-rules) (lw6-default-map-hints) (lw6-default-map-style))))

(define lw6-forced-param
  (lambda ()
    (lw6-config-subset (string-split (lw6-config-get-string lw6def-force) #\,))))

