/*
 * @(#)SnmpTrapType.java         1.0          6 September 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

/**
 * A class for handling type information for a SNMP trap type.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class SnmpTrapType extends Type {

   /**
    * The trap type description.
    */
   private String     description;

   /**
    * Creates a new SNMP trap type with no parameters.
    * The description is set to an empty string.
    */
   public SnmpTrapType() {
      this("");
   }

   /**
    * Creates a new SNMP trap type with the given description.
    *
    * @param  descr       a string description
    */
   public SnmpTrapType(String descr) {
      this.description = descr;
   }

   /**
    * Checks if this type equals another.
    *
    * @param  obj       an object
    * @return true if the types are equal, false otherwise
    */
   public boolean equals(Object obj) {
      return this == obj;
   }

   /**
    * Returns a description of this type.
    *
    * @return a description of the type
    */
   public String toString() {
      return "Trap";
   }

   /**
    * Transfers the type information from this type to a type converter
    * object. The calling conventions declared in the TypeConverter
    * class are followed.
    *
    * @param   converter     a type converter
    */
   public void transferType(TypeConverter converter) {
      throw new UnsupportedOperationException("Traps cannot be mapped " +
                                              "to anything.");
   }

}

