/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.percederberg.mib.Mib;
import net.percederberg.mib.symbol.Symbol;
import net.percederberg.mib.symbol.TypeSymbol;
import net.percederberg.mib.type.SnmpTrapType;

public class MibTreeModel
implements TreeModel {
    private TreeSymbol root;
    private TreeSymbol traps;
    private TreeSymbol types;
    private Symbol enterprises;

    public MibTreeModel(Mib mib) {
        this.root = new TreeSymbol(mib.toString());
        this.enterprises = mib.getSymbol("enterprises");
        if (this.enterprises != null) {
            this.root.addChild(this.enterprises);
        }
        this.traps = new TreeSymbol(this.root, "TRAPS");
        this.types = new TreeSymbol(this.root, "TEXTUAL CONVENTIONS");
        this.addTraps(mib);
        this.addTypes(mib);
    }

    private void addTraps(Mib mib) {
        int i = 0;
        while (i < mib.getSymbolCount()) {
            Symbol sym = mib.getSymbol(i);
            if (sym.getType() instanceof SnmpTrapType) {
                this.traps.addChild(sym);
            }
            ++i;
        }
    }

    private void addTypes(Mib mib) {
        int i = 0;
        while (i < mib.getSymbolCount()) {
            Symbol sym = mib.getSymbol(i);
            if (sym instanceof TypeSymbol) {
                this.types.addChild(sym);
            }
            ++i;
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return ((Symbol)parent).childAt(index);
    }

    public int getChildCount(Object parent) {
        return ((Symbol)parent).children();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0 && !(node instanceof TreeSymbol);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        int i = 0;
        Symbol symbol = (Symbol)parent;
        while (i < symbol.children()) {
            if (symbol.childAt(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    private class TreeSymbol
    extends Symbol {
        public TreeSymbol(String name) {
            this.name = name;
        }

        public TreeSymbol(Symbol parent, String name) {
            this.name = name;
            this.setParent(parent);
        }

        public void addChild(Symbol child) {
            super.addChild(child);
        }

        public String getOID() {
            return "";
        }

        public void setOID(int id) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Cannot assign an id to " + this.toString());
        }
    }
}

