/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.symbol;

import java.util.Vector;
import net.percederberg.mib.type.Type;

public abstract class Symbol {
    protected String name = "";
    protected Type type = null;
    protected int id = -1;
    protected Symbol parent = null;
    protected Vector children = null;

    public boolean isField() {
        return false;
    }

    public boolean isTopField() {
        return false;
    }

    public Symbol childAt(int index) {
        if (index < 0 || this.children() <= index) {
            return null;
        }
        return (Symbol)this.children.elementAt(index);
    }

    public int children() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public String getName() {
        return this.name;
    }

    public String getOID() {
        String base = "";
        if (this.parent != null) {
            base = this.parent.getOID();
        }
        if (this.id >= 0) {
            return base + "." + this.id;
        }
        return base;
    }

    public Symbol getParent() {
        return this.parent;
    }

    public Type getType() {
        return this.type;
    }

    public void setOID(int id) {
        this.id = id;
    }

    public void setParent(Symbol parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Symbol) {
            Symbol sym = (Symbol)obj;
            return this.name.equals(sym.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    protected void addChild(Symbol child) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(child);
    }

    protected void removeChild(Symbol child) {
        if (this.children == null) {
            return;
        }
        this.children.removeElement(child);
    }

    protected Symbol findChild(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        int i = 0;
        while (i < this.children()) {
            Symbol sym = this.childAt(i).findChild(name);
            if (sym != null) {
                return sym;
            }
            ++i;
        }
        return null;
    }
}

