/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib.asn1.node;

import net.percederberg.mib.asn1.analysis.Switch;
import net.percederberg.mib.asn1.analysis.Switchable;
import net.percederberg.mib.asn1.node.NodeConstants;

public abstract class Node
implements NodeConstants,
Switchable {
    public int kind = -1;
    private Node parent = null;

    public static String toName(int nodeType) {
        try {
            if (nodeType < 200) {
                return NodeConstants.tokenNodeName[nodeType];
            }
            return NodeConstants.productionNodeName[nodeType - 200];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toName(Node node) {
        return Node.toName(node.kind);
    }

    public void apply(Switch sw) {
        switch (this.kind) {
            case 0: {
                sw.caseEOF(this);
                break;
            }
            case 8: {
                sw.caseTDOT(this);
                break;
            }
            case 9: {
                sw.caseTCOMMA(this);
                break;
            }
            case 10: {
                sw.caseTSEMI_COLON(this);
                break;
            }
            case 11: {
                sw.caseTLEFTPAREN(this);
                break;
            }
            case 12: {
                sw.caseTRIGHTPAREN(this);
                break;
            }
            case 13: {
                sw.caseTLEFTBRACE(this);
                break;
            }
            case 14: {
                sw.caseTRIGHTBRACE(this);
                break;
            }
            case 15: {
                sw.caseTLEFTBRACKET(this);
                break;
            }
            case 16: {
                sw.caseTRIGHTBRACKET(this);
                break;
            }
            case 17: {
                sw.caseTMINUS(this);
                break;
            }
            case 18: {
                sw.caseTLESSTHAN(this);
                break;
            }
            case 19: {
                sw.caseTBAR(this);
                break;
            }
            case 20: {
                sw.caseTASSIGN(this);
                break;
            }
            case 21: {
                sw.caseTDEFINITIONS(this);
                break;
            }
            case 22: {
                sw.caseTEXPLICIT(this);
                break;
            }
            case 23: {
                sw.caseTIMPLICIT(this);
                break;
            }
            case 24: {
                sw.caseTTAGS(this);
                break;
            }
            case 25: {
                sw.caseTBEGIN(this);
                break;
            }
            case 26: {
                sw.caseTEND(this);
                break;
            }
            case 27: {
                sw.caseTEXPORTS(this);
                break;
            }
            case 28: {
                sw.caseTIMPORTS(this);
                break;
            }
            case 29: {
                sw.caseTFROM(this);
                break;
            }
            case 30: {
                sw.caseTMACRO(this);
                break;
            }
            case 31: {
                sw.caseTINTEGER(this);
                break;
            }
            case 32: {
                sw.caseTREAL(this);
                break;
            }
            case 33: {
                sw.caseTBOOLEAN(this);
                break;
            }
            case 34: {
                sw.caseTNULL(this);
                break;
            }
            case 35: {
                sw.caseTBIT(this);
                break;
            }
            case 36: {
                sw.caseTOCTET(this);
                break;
            }
            case 37: {
                sw.caseTSTRING(this);
                break;
            }
            case 38: {
                sw.caseTENUMERATED(this);
                break;
            }
            case 39: {
                sw.caseTSEQUENCE(this);
                break;
            }
            case 40: {
                sw.caseTSET(this);
                break;
            }
            case 41: {
                sw.caseTOF(this);
                break;
            }
            case 42: {
                sw.caseTCHOICE(this);
                break;
            }
            case 43: {
                sw.caseTUNIVERSAL(this);
                break;
            }
            case 44: {
                sw.caseTAPPLICATION(this);
                break;
            }
            case 45: {
                sw.caseTPRIVATE(this);
                break;
            }
            case 46: {
                sw.caseTANY(this);
                break;
            }
            case 47: {
                sw.caseTDEFINED(this);
                break;
            }
            case 48: {
                sw.caseTBY(this);
                break;
            }
            case 49: {
                sw.caseTOBJECT(this);
                break;
            }
            case 50: {
                sw.caseTIDENTIFIER(this);
                break;
            }
            case 51: {
                sw.caseTINCLUDES(this);
                break;
            }
            case 52: {
                sw.caseTMIN(this);
                break;
            }
            case 53: {
                sw.caseTMAX(this);
                break;
            }
            case 54: {
                sw.caseTSIZE(this);
                break;
            }
            case 55: {
                sw.caseTWITH(this);
                break;
            }
            case 56: {
                sw.caseTCOMPONENT(this);
                break;
            }
            case 57: {
                sw.caseTCOMPONENTS(this);
                break;
            }
            case 58: {
                sw.caseTPRESENT(this);
                break;
            }
            case 59: {
                sw.caseTABSENT(this);
                break;
            }
            case 60: {
                sw.caseTOPTIONAL(this);
                break;
            }
            case 61: {
                sw.caseTDEFAULT(this);
                break;
            }
            case 62: {
                sw.caseTTRUE(this);
                break;
            }
            case 63: {
                sw.caseTFALSE(this);
                break;
            }
            case 64: {
                sw.caseTPLUS_INFINITY(this);
                break;
            }
            case 65: {
                sw.caseTMINUS_INFINITY(this);
                break;
            }
            case 66: {
                sw.caseTMODULE_IDENTITY(this);
                break;
            }
            case 67: {
                sw.caseTOBJECT_IDENTITY(this);
                break;
            }
            case 68: {
                sw.caseTOBJECT_TYPE(this);
                break;
            }
            case 69: {
                sw.caseTNOTIFICATION_TYPE(this);
                break;
            }
            case 70: {
                sw.caseTTRAP_TYPE(this);
                break;
            }
            case 71: {
                sw.caseTTEXTUAL_CONVENTION(this);
                break;
            }
            case 72: {
                sw.caseTOBJECT_GROUP(this);
                break;
            }
            case 73: {
                sw.caseTNOTIFICATION_GROUP(this);
                break;
            }
            case 74: {
                sw.caseTMODULE_COMPLIANCE(this);
                break;
            }
            case 75: {
                sw.caseTAGENT_CAPABILITIES(this);
                break;
            }
            case 76: {
                sw.caseTLAST_UPDATED(this);
                break;
            }
            case 77: {
                sw.caseTORGANIZATION(this);
                break;
            }
            case 78: {
                sw.caseTCONTACT_INFO(this);
                break;
            }
            case 79: {
                sw.caseTDESCRIPTION(this);
                break;
            }
            case 80: {
                sw.caseTREVISION(this);
                break;
            }
            case 81: {
                sw.caseTSTATUS(this);
                break;
            }
            case 82: {
                sw.caseTREFERENCE(this);
                break;
            }
            case 83: {
                sw.caseTSYNTAX(this);
                break;
            }
            case 84: {
                sw.caseTBITS(this);
                break;
            }
            case 85: {
                sw.caseTUNITS(this);
                break;
            }
            case 86: {
                sw.caseTACCESS(this);
                break;
            }
            case 87: {
                sw.caseTMAX_ACCESS(this);
                break;
            }
            case 88: {
                sw.caseTMIN_ACCESS(this);
                break;
            }
            case 89: {
                sw.caseTINDEX(this);
                break;
            }
            case 90: {
                sw.caseTAUGMENTS(this);
                break;
            }
            case 91: {
                sw.caseTIMPLIED(this);
                break;
            }
            case 92: {
                sw.caseTDEFVAL(this);
                break;
            }
            case 93: {
                sw.caseTOBJECTS(this);
                break;
            }
            case 94: {
                sw.caseTENTERPRISE(this);
                break;
            }
            case 95: {
                sw.caseTVARIABLES(this);
                break;
            }
            case 96: {
                sw.caseTDISPLAY_HINT(this);
                break;
            }
            case 97: {
                sw.caseTNOTIFICATIONS(this);
                break;
            }
            case 98: {
                sw.caseTMODULE(this);
                break;
            }
            case 99: {
                sw.caseTMANDATORY_GROUPS(this);
                break;
            }
            case 100: {
                sw.caseTGROUP(this);
                break;
            }
            case 101: {
                sw.caseTWRITE_SYNTAX(this);
                break;
            }
            case 102: {
                sw.caseTPRODUCT_RELEASE(this);
                break;
            }
            case 103: {
                sw.caseTSUPPORTS(this);
                break;
            }
            case 104: {
                sw.caseTVARIATION(this);
                break;
            }
            case 105: {
                sw.caseTCREATION_REQUIRES(this);
                break;
            }
            case 106: {
                sw.caseTBINSTRING(this);
                break;
            }
            case 107: {
                sw.caseTHEXSTRING(this);
                break;
            }
            case 108: {
                sw.caseTCSTRING(this);
                break;
            }
            case 109: {
                sw.caseTIDENT(this);
                break;
            }
            case 110: {
                sw.caseTNUMBER(this);
                break;
            }
            case 200: {
                sw.caseStart(this);
                break;
            }
            case 201: {
                sw.caseModuleDefinition(this);
                break;
            }
            case 202: {
                sw.caseTagDefault(this);
                break;
            }
            case 203: {
                sw.caseModuleIdentifier(this);
                break;
            }
            case 204: {
                sw.caseModuleBody(this);
                break;
            }
            case 205: {
                sw.caseExports(this);
                break;
            }
            case 206: {
                sw.caseImports(this);
                break;
            }
            case 207: {
                sw.caseSymbolsFromModuleList(this);
                break;
            }
            case 208: {
                sw.caseSymbolsFromModule(this);
                break;
            }
            case 209: {
                sw.caseSymbolList(this);
                break;
            }
            case 210: {
                sw.caseSymbol(this);
                break;
            }
            case 211: {
                sw.caseAssignmentList(this);
                break;
            }
            case 212: {
                sw.caseAssignment(this);
                break;
            }
            case 213: {
                sw.caseMacroDefinition(this);
                break;
            }
            case 214: {
                sw.caseMacroBody(this);
                break;
            }
            case 215: {
                sw.caseSkipToEND(this);
                break;
            }
            case 216: {
                sw.caseMacroReference(this);
                break;
            }
            case 217: {
                sw.caseTypeAssignment(this);
                break;
            }
            case 218: {
                sw.caseType(this);
                break;
            }
            case 219: {
                sw.caseBuiltinType(this);
                break;
            }
            case 220: {
                sw.caseIntegerType(this);
                break;
            }
            case 221: {
                sw.caseNamedNumberList(this);
                break;
            }
            case 222: {
                sw.caseNamedNumber(this);
                break;
            }
            case 223: {
                sw.caseSignedNumber(this);
                break;
            }
            case 224: {
                sw.caseStringType(this);
                break;
            }
            case 225: {
                sw.caseBitStringType(this);
                break;
            }
            case 226: {
                sw.caseSequenceType(this);
                break;
            }
            case 227: {
                sw.caseSequenceOfType(this);
                break;
            }
            case 228: {
                sw.caseSetType(this);
                break;
            }
            case 229: {
                sw.caseSetOfType(this);
                break;
            }
            case 230: {
                sw.caseElementTypeList(this);
                break;
            }
            case 231: {
                sw.caseElementType(this);
                break;
            }
            case 232: {
                sw.caseNamedType(this);
                break;
            }
            case 233: {
                sw.caseChoiceType(this);
                break;
            }
            case 234: {
                sw.caseEnumeratedType(this);
                break;
            }
            case 235: {
                sw.caseSelectionType(this);
                break;
            }
            case 236: {
                sw.caseTaggedType(this);
                break;
            }
            case 237: {
                sw.caseTag(this);
                break;
            }
            case 238: {
                sw.caseClassNumber(this);
                break;
            }
            case 239: {
                sw.caseClass(this);
                break;
            }
            case 240: {
                sw.caseAnyType(this);
                break;
            }
            case 241: {
                sw.caseDefinedType(this);
                break;
            }
            case 242: {
                sw.caseConstraintList(this);
                break;
            }
            case 243: {
                sw.caseConstraint(this);
                break;
            }
            case 244: {
                sw.caseValueConstraint(this);
                break;
            }
            case 245: {
                sw.caseValueRange(this);
                break;
            }
            case 246: {
                sw.caseLowerEndPoint(this);
                break;
            }
            case 247: {
                sw.caseUpperEndPoint(this);
                break;
            }
            case 248: {
                sw.caseSizeConstraint(this);
                break;
            }
            case 249: {
                sw.caseAlphabetConstraint(this);
                break;
            }
            case 250: {
                sw.caseValueAssignment(this);
                break;
            }
            case 251: {
                sw.caseValue(this);
                break;
            }
            case 252: {
                sw.caseDefinedValue(this);
                break;
            }
            case 253: {
                sw.caseBuiltinValue(this);
                break;
            }
            case 254: {
                sw.caseBooleanValue(this);
                break;
            }
            case 255: {
                sw.caseSpecialRealValue(this);
                break;
            }
            case 256: {
                sw.caseNullValue(this);
                break;
            }
            case 257: {
                sw.caseNamedValue(this);
                break;
            }
            case 258: {
                sw.caseObjectIdentifierValue(this);
                break;
            }
            case 259: {
                sw.caseObjIdComponentList(this);
                break;
            }
            case 260: {
                sw.caseObjIdComponent(this);
                break;
            }
            case 261: {
                sw.caseNameAndNumberForm(this);
                break;
            }
            case 262: {
                sw.caseBinaryString(this);
                break;
            }
            case 263: {
                sw.caseHexString(this);
                break;
            }
            case 264: {
                sw.caseCharString(this);
                break;
            }
            case 265: {
                sw.caseNumber(this);
                break;
            }
            case 266: {
                sw.caseIdentifier(this);
                break;
            }
            case 267: {
                sw.caseModuleReference(this);
                break;
            }
            case 268: {
                sw.caseTypeReference(this);
                break;
            }
            case 269: {
                sw.caseDefinedMacroType(this);
                break;
            }
            case 270: {
                sw.caseDefinedMacroName(this);
                break;
            }
            case 271: {
                sw.caseSnmpModuleIdentityMacroType(this);
                break;
            }
            case 272: {
                sw.caseSnmpObjectIdentityMacroType(this);
                break;
            }
            case 273: {
                sw.caseSnmpObjectTypeMacroType(this);
                break;
            }
            case 274: {
                sw.caseSnmpNotificationTypeMacroType(this);
                break;
            }
            case 275: {
                sw.caseSnmpTrapTypeMacroType(this);
                break;
            }
            case 276: {
                sw.caseSnmpTextualConventionMacroType(this);
                break;
            }
            case 277: {
                sw.caseSnmpObjectGroupMacroType(this);
                break;
            }
            case 278: {
                sw.caseSnmpNotificationGroupMacroType(this);
                break;
            }
            case 279: {
                sw.caseSnmpModuleComplianceMacroType(this);
                break;
            }
            case 280: {
                sw.caseSnmpAgentCapabilitiesMacroType(this);
                break;
            }
            case 281: {
                sw.caseSnmpUpdatePart(this);
                break;
            }
            case 282: {
                sw.caseSnmpOrganizationPart(this);
                break;
            }
            case 283: {
                sw.caseSnmpContactPart(this);
                break;
            }
            case 284: {
                sw.caseSnmpDescrPart(this);
                break;
            }
            case 285: {
                sw.caseSnmpRevisionPart(this);
                break;
            }
            case 286: {
                sw.caseSnmpStatusPart(this);
                break;
            }
            case 287: {
                sw.caseSnmpReferPart(this);
                break;
            }
            case 288: {
                sw.caseSnmpSyntaxPart(this);
                break;
            }
            case 289: {
                sw.caseTypeOrBits(this);
                break;
            }
            case 290: {
                sw.caseNamedBits(this);
                break;
            }
            case 291: {
                sw.caseNamedBit(this);
                break;
            }
            case 292: {
                sw.caseSnmpUnitsPart(this);
                break;
            }
            case 293: {
                sw.caseSnmpAccessPart(this);
                break;
            }
            case 294: {
                sw.caseSnmpIndexPart(this);
                break;
            }
            case 295: {
                sw.caseTypeOrValueList(this);
                break;
            }
            case 296: {
                sw.caseTypeOrValue(this);
                break;
            }
            case 297: {
                sw.caseSnmpDefValPart(this);
                break;
            }
            case 298: {
                sw.caseSnmpObjectsPart(this);
                break;
            }
            case 299: {
                sw.caseValueList(this);
                break;
            }
            case 300: {
                sw.caseSnmpEnterprisePart(this);
                break;
            }
            case 301: {
                sw.caseSnmpVarPart(this);
                break;
            }
            case 302: {
                sw.caseVarTypes(this);
                break;
            }
            case 303: {
                sw.caseSnmpDisplayPart(this);
                break;
            }
            case 304: {
                sw.caseSnmpNotificationsPart(this);
                break;
            }
            case 305: {
                sw.caseSnmpModulePart(this);
                break;
            }
            case 306: {
                sw.caseSnmpMandatoryPart(this);
                break;
            }
            case 307: {
                sw.caseSnmpCompliancePart(this);
                break;
            }
            case 308: {
                sw.caseComplianceGroup(this);
                break;
            }
            case 309: {
                sw.caseComplianceObject(this);
                break;
            }
            case 310: {
                sw.caseSnmpWriteSyntaxPart(this);
                break;
            }
            case 311: {
                sw.caseSnmpProductReleasePart(this);
                break;
            }
            case 312: {
                sw.caseSnmpModuleSupportPart(this);
                break;
            }
            case 313: {
                sw.caseSnmpVariationPart(this);
                break;
            }
            case 314: {
                sw.caseSnmpCreationPart(this);
                break;
            }
        }
    }

    public Node childAfter(Node child) {
        return null;
    }

    public Node childAt(int index) {
        return null;
    }

    public Node childOfType(int type) {
        return null;
    }

    public int children() {
        return 0;
    }

    public int childrenOfType(int type) {
        return 0;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean isAncestor(int type) {
        Node node = this;
        while (node != null) {
            if (node.isParent(type)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public boolean isParent(int type) {
        if (this.parent != null) {
            return this.parent.kind == type;
        }
        return false;
    }

    public boolean isType(int type) {
        return type == this.kind;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int firstLine() {
        return -1;
    }

    public int firstColumn() {
        return -1;
    }

    public int lastLine() {
        return -1;
    }

    public int lastColumn() {
        return -1;
    }

    public String toString() {
        if (Node.toName(this.kind) != null) {
            return Node.toName(this.kind);
        }
        return "*** UNKNOWN NODE ***";
    }
}

