/*
 * @(#)SwitchAdapter.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * As a special exception, the copyright holders of this library 
 * give you permission to link this library with independent modules
 * to produce an executable, regardless of the license terms of 
 * these independent modules, and to copy and distribute the 
 * resulting executable under terms of your choice, provided that 
 * you also meet, for each linked independent module, the terms and 
 * conditions of the license of that module. An independent module 
 * is a module which is not derived from or based on this library. 
 * If you modify this library, you may extend this exception to your 
 * version of the library, but you are not obligated to do so. If 
 * you do not wish to do so, delete this exception statement from 
 * your version. 
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

import net.percederberg.mib.asn1.node.Node;

/**
 * This class provides a default implementation of the Switch interface.
 * By default all caseX methods call the defaultCase method, which is
 * empty. This class should be subclassed and the appropriate methods
 * overridden for handling various types of parse tree analysis.
 *
 * @version  1.2
 * @author   Per Cederberg, per@percederberg.nett
 */
public class SwitchAdapter implements Switch {

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseStart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseModuleDefinition(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTagDefault(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseModuleIdentifier(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseModuleBody(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseExports(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseImports(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSymbolsFromModuleList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSymbolsFromModule(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSymbolList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSymbol(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseAssignmentList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseAssignment(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseMacroDefinition(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseMacroBody(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSkipToEND(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseMacroReference(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTypeAssignment(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseBuiltinType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseIntegerType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNamedNumberList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNamedNumber(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSignedNumber(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseStringType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseBitStringType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSequenceType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSequenceOfType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSetType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSetOfType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseElementTypeList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseElementType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNamedType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseChoiceType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseEnumeratedType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSelectionType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTaggedType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTag(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseClassNumber(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseClass(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseAnyType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseDefinedType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseConstraintList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseConstraint(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseValueConstraint(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseValueRange(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseLowerEndPoint(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseUpperEndPoint(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSizeConstraint(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseAlphabetConstraint(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseValueAssignment(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseDefinedValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseBuiltinValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseBooleanValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSpecialRealValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNullValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNamedValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseObjectIdentifierValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseObjIdComponentList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseObjIdComponent(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNameAndNumberForm(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseBinaryString(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseHexString(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseCharString(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNumber(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseIdentifier(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseModuleReference(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTypeReference(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseDefinedMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseDefinedMacroName(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpModuleIdentityMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpObjectIdentityMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpObjectTypeMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpNotificationTypeMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpTrapTypeMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpTextualConventionMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpObjectGroupMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpNotificationGroupMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpModuleComplianceMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpAgentCapabilitiesMacroType(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpUpdatePart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpOrganizationPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpContactPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpDescrPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpRevisionPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpStatusPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpReferPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpSyntaxPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTypeOrBits(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNamedBits(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseNamedBit(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpUnitsPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpAccessPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpIndexPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTypeOrValueList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTypeOrValue(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpDefValPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpObjectsPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseValueList(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpEnterprisePart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpVarPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseVarTypes(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpDisplayPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpNotificationsPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpModulePart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpMandatoryPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpCompliancePart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseComplianceGroup(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseComplianceObject(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpWriteSyntaxPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpProductReleasePart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpModuleSupportPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpVariationPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseSnmpCreationPart(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseEOF(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDOT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCOMMA(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSEMI_COLON(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTLEFTPAREN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTRIGHTPAREN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTLEFTBRACE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTRIGHTBRACE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTLEFTBRACKET(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTRIGHTBRACKET(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMINUS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTLESSTHAN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBAR(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTASSIGN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDEFINITIONS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTEXPLICIT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTIMPLICIT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTTAGS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBEGIN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTEND(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTEXPORTS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTIMPORTS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTFROM(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMACRO(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTINTEGER(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTREAL(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBOOLEAN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTNULL(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBIT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOCTET(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSTRING(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTENUMERATED(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSEQUENCE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSET(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOF(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCHOICE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTUNIVERSAL(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTAPPLICATION(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTPRIVATE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTANY(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDEFINED(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBY(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOBJECT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTIDENTIFIER(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTINCLUDES(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMIN(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMAX(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSIZE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTWITH(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCOMPONENT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCOMPONENTS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTPRESENT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTABSENT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOPTIONAL(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDEFAULT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTTRUE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTFALSE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTPLUS_INFINITY(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMINUS_INFINITY(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMODULE_IDENTITY(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOBJECT_IDENTITY(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOBJECT_TYPE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTNOTIFICATION_TYPE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTTRAP_TYPE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTTEXTUAL_CONVENTION(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOBJECT_GROUP(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTNOTIFICATION_GROUP(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMODULE_COMPLIANCE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTAGENT_CAPABILITIES(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTLAST_UPDATED(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTORGANIZATION(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCONTACT_INFO(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDESCRIPTION(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTREVISION(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSTATUS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTREFERENCE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSYNTAX(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBITS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTUNITS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTACCESS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMAX_ACCESS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMIN_ACCESS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTINDEX(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTAUGMENTS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTIMPLIED(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDEFVAL(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTOBJECTS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTENTERPRISE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTVARIABLES(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTDISPLAY_HINT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTNOTIFICATIONS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMODULE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTMANDATORY_GROUPS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTGROUP(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTWRITE_SYNTAX(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTPRODUCT_RELEASE(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTSUPPORTS(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTVARIATION(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCREATION_REQUIRES(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTBINSTRING(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTHEXSTRING(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTCSTRING(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTIDENT(Node node) {
        defaultCase(node);
    }

    /**
     * Called when switching this node type. By default, this method
     * calls the defaultCase() method.
     *
     * @param node   a parse tree node
     */
    public void caseTNUMBER(Node node) {
        defaultCase(node);
    }

    /**
     * A default method called from all caseX methods. Override this method
     * in a subclass to handle the default case.
     *
     * @param  node   a parse tree node
     */
    protected void defaultCase(Node node) {
    }
}
