/*
 * @(#)NodeConstants.java
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * As a special exception, the copyright holders of this library 
 * give you permission to link this library with independent modules
 * to produce an executable, regardless of the license terms of 
 * these independent modules, and to copy and distribute the 
 * resulting executable under terms of your choice, provided that 
 * you also meet, for each linked independent module, the terms and 
 * conditions of the license of that module. An independent module 
 * is a module which is not derived from or based on this library. 
 * If you modify this library, you may extend this exception to your 
 * version of the library, but you are not obligated to do so. If 
 * you do not wish to do so, delete this exception statement from 
 * your version. 
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2003 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.node;

/**
 * Interface containing all the token and production node
 * constants. These constants <strong>must</strong> be updated
 * manually when the set of tokens or productions change.
 *
 * @version  1.2
 * @author   Per Cederberg, per@percederberg.net
 */
public interface NodeConstants {

    // Token node constants (starting at 0)
    public static final int EOF = 0;
    public static final int TDOT = 8;
    public static final int TCOMMA = 9;
    public static final int TSEMI_COLON = 10;
    public static final int TLEFTPAREN = 11;
    public static final int TRIGHTPAREN = 12;
    public static final int TLEFTBRACE = 13;
    public static final int TRIGHTBRACE = 14;
    public static final int TLEFTBRACKET = 15;
    public static final int TRIGHTBRACKET = 16;
    public static final int TMINUS = 17;
    public static final int TLESSTHAN = 18;
    public static final int TBAR = 19;
    public static final int TASSIGN = 20;
    public static final int TDEFINITIONS = 21;
    public static final int TEXPLICIT = 22;
    public static final int TIMPLICIT = 23;
    public static final int TTAGS = 24;
    public static final int TBEGIN = 25;
    public static final int TEND = 26;
    public static final int TEXPORTS = 27;
    public static final int TIMPORTS = 28;
    public static final int TFROM = 29;
    public static final int TMACRO = 30;
    public static final int TINTEGER = 31;
    public static final int TREAL = 32;
    public static final int TBOOLEAN = 33;
    public static final int TNULL = 34;
    public static final int TBIT = 35;
    public static final int TOCTET = 36;
    public static final int TSTRING = 37;
    public static final int TENUMERATED = 38;
    public static final int TSEQUENCE = 39;
    public static final int TSET = 40;
    public static final int TOF = 41;
    public static final int TCHOICE = 42;
    public static final int TUNIVERSAL = 43;
    public static final int TAPPLICATION = 44;
    public static final int TPRIVATE = 45;
    public static final int TANY = 46;
    public static final int TDEFINED = 47;
    public static final int TBY = 48;
    public static final int TOBJECT = 49;
    public static final int TIDENTIFIER = 50;
    public static final int TINCLUDES = 51;
    public static final int TMIN = 52;
    public static final int TMAX = 53;
    public static final int TSIZE = 54;
    public static final int TWITH = 55;
    public static final int TCOMPONENT = 56;
    public static final int TCOMPONENTS = 57;
    public static final int TPRESENT = 58;
    public static final int TABSENT = 59;
    public static final int TOPTIONAL = 60;
    public static final int TDEFAULT = 61;
    public static final int TTRUE = 62;
    public static final int TFALSE = 63;
    public static final int TPLUS_INFINITY = 64;
    public static final int TMINUS_INFINITY = 65;
    public static final int TMODULE_IDENTITY = 66;
    public static final int TOBJECT_IDENTITY = 67;
    public static final int TOBJECT_TYPE = 68;
    public static final int TNOTIFICATION_TYPE = 69;
    public static final int TTRAP_TYPE = 70;
    public static final int TTEXTUAL_CONVENTION = 71;
    public static final int TOBJECT_GROUP = 72;
    public static final int TNOTIFICATION_GROUP = 73;
    public static final int TMODULE_COMPLIANCE = 74;
    public static final int TAGENT_CAPABILITIES = 75;
    public static final int TLAST_UPDATED = 76;
    public static final int TORGANIZATION = 77;
    public static final int TCONTACT_INFO = 78;
    public static final int TDESCRIPTION = 79;
    public static final int TREVISION = 80;
    public static final int TSTATUS = 81;
    public static final int TREFERENCE = 82;
    public static final int TSYNTAX = 83;
    public static final int TBITS = 84;
    public static final int TUNITS = 85;
    public static final int TACCESS = 86;
    public static final int TMAX_ACCESS = 87;
    public static final int TMIN_ACCESS = 88;
    public static final int TINDEX = 89;
    public static final int TAUGMENTS = 90;
    public static final int TIMPLIED = 91;
    public static final int TDEFVAL = 92;
    public static final int TOBJECTS = 93;
    public static final int TENTERPRISE = 94;
    public static final int TVARIABLES = 95;
    public static final int TDISPLAY_HINT = 96;
    public static final int TNOTIFICATIONS = 97;
    public static final int TMODULE = 98;
    public static final int TMANDATORY_GROUPS = 99;
    public static final int TGROUP = 100;
    public static final int TWRITE_SYNTAX = 101;
    public static final int TPRODUCT_RELEASE = 102;
    public static final int TSUPPORTS = 103;
    public static final int TVARIATION = 104;
    public static final int TCREATION_REQUIRES = 105;
    public static final int TBINSTRING = 106;
    public static final int THEXSTRING = 107;
    public static final int TCSTRING = 108;
    public static final int TIDENT = 109;
    public static final int TNUMBER = 110;

    // Production node constants (starting at 200)
    public static final int START = 200;
    public static final int MODULEDEFINITION = 201;
    public static final int TAGDEFAULT = 202;
    public static final int MODULEIDENTIFIER = 203;
    public static final int MODULEBODY = 204;
    public static final int EXPORTS = 205;
    public static final int IMPORTS = 206;
    public static final int SYMBOLSFROMMODULELIST = 207;
    public static final int SYMBOLSFROMMODULE = 208;
    public static final int SYMBOLLIST = 209;
    public static final int SYMBOL = 210;
    public static final int ASSIGNMENTLIST = 211;
    public static final int ASSIGNMENT = 212;
    public static final int MACRODEFINITION = 213;
    public static final int MACROBODY = 214;
    public static final int SKIPTOEND = 215;
    public static final int MACROREFERENCE = 216;
    public static final int TYPEASSIGNMENT = 217;
    public static final int TYPE = 218;
    public static final int BUILTINTYPE = 219;
    public static final int INTEGERTYPE = 220;
    public static final int NAMEDNUMBERLIST = 221;
    public static final int NAMEDNUMBER = 222;
    public static final int SIGNEDNUMBER = 223;
    public static final int STRINGTYPE = 224;
    public static final int BITSTRINGTYPE = 225;
    public static final int SEQUENCETYPE = 226;
    public static final int SEQUENCEOFTYPE = 227;
    public static final int SETTYPE = 228;
    public static final int SETOFTYPE = 229;
    public static final int ELEMENTTYPELIST = 230;
    public static final int ELEMENTTYPE = 231;
    public static final int NAMEDTYPE = 232;
    public static final int CHOICETYPE = 233;
    public static final int ENUMERATEDTYPE = 234;
    public static final int SELECTIONTYPE = 235;
    public static final int TAGGEDTYPE = 236;
    public static final int TAG = 237;
    public static final int CLASSNUMBER = 238;
    public static final int CLASS = 239;
    public static final int ANYTYPE = 240;
    public static final int DEFINEDTYPE = 241;
    public static final int CONSTRAINTLIST = 242;
    public static final int CONSTRAINT = 243;
    public static final int VALUECONSTRAINT = 244;
    public static final int VALUERANGE = 245;
    public static final int LOWERENDPOINT = 246;
    public static final int UPPERENDPOINT = 247;
    public static final int SIZECONSTRAINT = 248;
    public static final int ALPHABETCONSTRAINT = 249;
    public static final int VALUEASSIGNMENT = 250;
    public static final int VALUE = 251;
    public static final int DEFINEDVALUE = 252;
    public static final int BUILTINVALUE = 253;
    public static final int BOOLEANVALUE = 254;
    public static final int SPECIALREALVALUE = 255;
    public static final int NULLVALUE = 256;
    public static final int NAMEDVALUE = 257;
    public static final int OBJECTIDENTIFIERVALUE = 258;
    public static final int OBJIDCOMPONENTLIST = 259;
    public static final int OBJIDCOMPONENT = 260;
    public static final int NAMEANDNUMBERFORM = 261;
    public static final int BINARYSTRING = 262;
    public static final int HEXSTRING = 263;
    public static final int CHARSTRING = 264;
    public static final int NUMBER = 265;
    public static final int IDENTIFIER = 266;
    public static final int MODULEREFERENCE = 267;
    public static final int TYPEREFERENCE = 268;
    public static final int DEFINEDMACROTYPE = 269;
    public static final int DEFINEDMACRONAME = 270;
    public static final int SNMPMODULEIDENTITYMACROTYPE = 271;
    public static final int SNMPOBJECTIDENTITYMACROTYPE = 272;
    public static final int SNMPOBJECTTYPEMACROTYPE = 273;
    public static final int SNMPNOTIFICATIONTYPEMACROTYPE = 274;
    public static final int SNMPTRAPTYPEMACROTYPE = 275;
    public static final int SNMPTEXTUALCONVENTIONMACROTYPE = 276;
    public static final int SNMPOBJECTGROUPMACROTYPE = 277;
    public static final int SNMPNOTIFICATIONGROUPMACROTYPE = 278;
    public static final int SNMPMODULECOMPLIANCEMACROTYPE = 279;
    public static final int SNMPAGENTCAPABILITIESMACROTYPE = 280;
    public static final int SNMPUPDATEPART = 281;
    public static final int SNMPORGANIZATIONPART = 282;
    public static final int SNMPCONTACTPART = 283;
    public static final int SNMPDESCRPART = 284;
    public static final int SNMPREVISIONPART = 285;
    public static final int SNMPSTATUSPART = 286;
    public static final int SNMPREFERPART = 287;
    public static final int SNMPSYNTAXPART = 288;
    public static final int TYPEORBITS = 289;
    public static final int NAMEDBITS = 290;
    public static final int NAMEDBIT = 291;
    public static final int SNMPUNITSPART = 292;
    public static final int SNMPACCESSPART = 293;
    public static final int SNMPINDEXPART = 294;
    public static final int TYPEORVALUELIST = 295;
    public static final int TYPEORVALUE = 296;
    public static final int SNMPDEFVALPART = 297;
    public static final int SNMPOBJECTSPART = 298;
    public static final int VALUELIST = 299;
    public static final int SNMPENTERPRISEPART = 300;
    public static final int SNMPVARPART = 301;
    public static final int VARTYPES = 302;
    public static final int SNMPDISPLAYPART = 303;
    public static final int SNMPNOTIFICATIONSPART = 304;
    public static final int SNMPMODULEPART = 305;
    public static final int SNMPMANDATORYPART = 306;
    public static final int SNMPCOMPLIANCEPART = 307;
    public static final int COMPLIANCEGROUP = 308;
    public static final int COMPLIANCEOBJECT = 309;
    public static final int SNMPWRITESYNTAXPART = 310;
    public static final int SNMPPRODUCTRELEASEPART = 311;
    public static final int SNMPMODULESUPPORTPART = 312;
    public static final int SNMPVARIATIONPART = 313;
    public static final int SNMPCREATIONPART = 314;

    /**
     * A list with all the node names for token nodes.
     */
    public static final String[] tokenNodeName = {
        "EOF",
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        "TDOT",
        "TCOMMA",
        "TSEMI_COLON",
        "TLEFTPAREN",
        "TRIGHTPAREN",
        "TLEFTBRACE",
        "TRIGHTBRACE",
        "TLEFTBRACKET",
        "TRIGHTBRACKET",
        "TMINUS",
        "TLESSTHAN",
        "TBAR",
        "TASSIGN",
        "TDEFINITIONS",
        "TEXPLICIT",
        "TIMPLICIT",
        "TTAGS",
        "TBEGIN",
        "TEND",
        "TEXPORTS",
        "TIMPORTS",
        "TFROM",
        "TMACRO",
        "TINTEGER",
        "TREAL",
        "TBOOLEAN",
        "TNULL",
        "TBIT",
        "TOCTET",
        "TSTRING",
        "TENUMERATED",
        "TSEQUENCE",
        "TSET",
        "TOF",
        "TCHOICE",
        "TUNIVERSAL",
        "TAPPLICATION",
        "TPRIVATE",
        "TANY",
        "TDEFINED",
        "TBY",
        "TOBJECT",
        "TIDENTIFIER",
        "TINCLUDES",
        "TMIN",
        "TMAX",
        "TSIZE",
        "TWITH",
        "TCOMPONENT",
        "TCOMPONENTS",
        "TPRESENT",
        "TABSENT",
        "TOPTIONAL",
        "TDEFAULT",
        "TTRUE",
        "TFALSE",
        "TPLUS_INFINITY",
        "TMINUS_INFINITY",
        "TMODULE_IDENTITY",
        "TOBJECT_IDENTITY",
        "TOBJECT_TYPE",
        "TNOTIFICATION_TYPE",
        "TTRAP_TYPE",
        "TTEXTUAL_CONVENTION",
        "TOBJECT_GROUP",
        "TNOTIFICATION_GROUP",
        "TMODULE_COMPLIANCE",
        "TAGENT_CAPABILITIES",
        "TLAST_UPDATED",
        "TORGANIZATION",
        "TCONTACT_INFO",
        "TDESCRIPTION",
        "TREVISION",
        "TSTATUS",
        "TREFERENCE",
        "TSYNTAX",
        "TBITS",
        "TUNITS",
        "TACCESS",
        "TMAX_ACCESS",
        "TMIN_ACCESS",
        "TINDEX",
        "TAUGMENTS",
        "TIMPLIED",
        "TDEFVAL",
        "TOBJECTS",
        "TENTERPRISE",
        "TVARIABLES",
        "TDISPLAY_HINT",
        "TNOTIFICATIONS",
        "TMODULE",
        "TMANDATORY_GROUPS",
        "TGROUP",
        "TWRITE_SYNTAX",
        "TPRODUCT_RELEASE",
        "TSUPPORTS",
        "TVARIATION",
        "TCREATION_REQUIRES",
        "TBINSTRING",
        "THEXSTRING",
        "TCSTRING",
        "TIDENT",
        "TNUMBER"
    };

    /**
     * A list with all the node names for production nodes.
     */
    public static final String[] productionNodeName = {
        "Start",
        "ModuleDefinition",
        "TagDefault",
        "ModuleIdentifier",
        "ModuleBody",
        "Exports",
        "Imports",
        "SymbolsFromModuleList",
        "SymbolsFromModule",
        "SymbolList",
        "Symbol",
        "AssignmentList",
        "Assignment",
        "MacroDefinition",
        "MacroBody",
        "SkipToEND",
        "MacroReference",
        "TypeAssignment",
        "Type",
        "BuiltinType",
        "IntegerType",
        "NamedNumberList",
        "NamedNumber",
        "SignedNumber",
        "StringType",
        "BitStringType",
        "SequenceType",
        "SequenceOfType",
        "SetType",
        "SetOfType",
        "ElementTypeList",
        "ElementType",
        "NamedType",
        "ChoiceType",
        "EnumeratedType",
        "SelectionType",
        "TaggedType",
        "Tag",
        "ClassNumber",
        "Class",
        "AnyType",
        "DefinedType",
        "ConstraintList",
        "Constraint",
        "ValueConstraint",
        "ValueRange",
        "LowerEndPoint",
        "UpperEndPoint",
        "SizeConstraint",
        "AlphabetConstraint",
        "ValueAssignment",
        "Value",
        "DefinedValue",
        "BuiltinValue",
        "BooleanValue",
        "SpecialRealValue",
        "NullValue",
        "NamedValue",
        "ObjectIdentifierValue",
        "ObjIdComponentList",
        "ObjIdComponent",
        "NameAndNumberForm",
        "BinaryString",
        "HexString",
        "CharString",
        "Number",
        "Identifier",
        "ModuleReference",
        "TypeReference",
        "DefinedMacroType",
        "DefinedMacroName",
        "SnmpModuleIdentityMacroType",
        "SnmpObjectIdentityMacroType",
        "SnmpObjectTypeMacroType",
        "SnmpNotificationTypeMacroType",
        "SnmpTrapTypeMacroType",
        "SnmpTextualConventionMacroType",
        "SnmpObjectGroupMacroType",
        "SnmpNotificationGroupMacroType",
        "SnmpModuleComplianceMacroType",
        "SnmpAgentCapabilitiesMacroType",
        "SnmpUpdatePart",
        "SnmpOrganizationPart",
        "SnmpContactPart",
        "SnmpDescrPart",
        "SnmpRevisionPart",
        "SnmpStatusPart",
        "SnmpReferPart",
        "SnmpSyntaxPart",
        "TypeOrBits",
        "NamedBits",
        "NamedBit",
        "SnmpUnitsPart",
        "SnmpAccessPart",
        "SnmpIndexPart",
        "TypeOrValueList",
        "TypeOrValue",
        "SnmpDefValPart",
        "SnmpObjectsPart",
        "ValueList",
        "SnmpEnterprisePart",
        "SnmpVarPart",
        "VarTypes",
        "SnmpDisplayPart",
        "SnmpNotificationsPart",
        "SnmpModulePart",
        "SnmpMandatoryPart",
        "SnmpCompliancePart",
        "ComplianceGroup",
        "ComplianceObject",
        "SnmpWriteSyntaxPart",
        "SnmpProductReleasePart",
        "SnmpModuleSupportPart",
        "SnmpVariationPart",
        "SnmpCreationPart"
    };
}
