/**
 * Ce programme montre comment il est possible de récupérer du texte demandé
 * à l'utilisateur à l'aide d'un prompt.
 *
 * Pour cela le programme utilise la fonction :
 *
 *------------------------------------------------------------------------------
 * MLV_prompt_wait : Suspend l'exécution du programme, affiche deux zonnes de 
 *                   textes.
 *                   La première zone n'est pas modifiable et sert à afficher un
 *                   message d'information. La deuxième est vide et peut être 
 *                   modifié par l'utilisateur.
 *                   Lorsque l'utilisateur appuie sur la touche entrée, le texte
 *                   qui se trouve dans la zone de texte est renvoyé par la 
 *                   fonction grâce au paramètre text.
 *                   Le texte, la taille et les couleurs des différents éléments
 *                   sont paramétrables grâces aux différents paramètres de la 
 *                   fonction.
 *
 * void MLV_prompt_wait(
 *    int            sommetHautGaucheX,     Coordonnee en X du coin Nord-Ouest 
 *                                          du prompt
 *    int            sommetHautGaucheY,     Coordonnee en Y du coin Nord-Ouest
 *                                          du prompt
 *    int            sommetBasDroitX,       Coordonnee en X du coin Sud-Est du
 *                                          prompt
 *    int            sommetBasDroitY,       Coordonnee en Y du coin Sud-Est du
 *                                          prompt
 *    MLV_Color      borderColor,           Couleur de la bordure du prompt
 *    MLV_Color      textColor,             Couleur du texte du prompt
 *    MLV_Color      backgroundColor,       Couleur de fond du prompt
 *    const char*    informativeMessage,    Message à afficher devant le prompt
 *    char**         text                   Addresse du texte où se trouvera la
 *                                          la réponse donnée par l'utilisateur.
 * );
 *------------------------------------------------------------------------------
 *
 */

#ifdef __cplusplus
extern "C" {
#endif
       #include <MLV/MLV_all.h>
#ifdef __cplusplus
}
#endif

//
// Programme principal
//
// Attention ! 
// Pour pouvoir compiler ce programme sous windows et sous macintosh,
// il faut, pour la déclaration du main, respecter strictement la syntaxe
// suivante :
//
int main(int argc, char *argv[]){
	char* text;     //adresse du texte où se trouvera la réponse entrée dans
	                // le prompt par l'utilisateur.

	//
	// Créé et affiche la fenêtre
	//
	MLV_create_window( "Nom_fenetre", "nom_icone", 640, 480 );

	//
	// Affiche la question
	//
	MLV_draw_text(
		10, 10,
		"Veuillez entrer un message dans la fenêtre ci-dessous.",
		MLV_COLOR_GREEN
	);
	MLV_actualise_window();

	//
	// Demande la réponse à la question en utilisant un prompt
	//
	MLV_prompt_wait(
		10,70,
		200,90,
		MLV_COLOR_RED, MLV_COLOR_GREEN, MLV_COLOR_BLACK,
		"message : ",
		&text
	);

	//
	// Affiche le texte qui a été tapé par l'utilisateur dans le prompt
	//
	MLV_draw_text( 10, 80, text, MLV_COLOR_GREEN );
	MLV_actualise_window();

	//
	// Attend 2 secondes
	//	
	MLV_wait_seconds( 2 );
	
	//
	// Libère la mémoire utilisée
	//	
	free( text );
	
	//
	// Ferme la fenêtre
	//
	MLV_close_window();
	return 0;
}
