// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/unittest.h>

void unittest_core ();
void unittest_crypt ();
void unittest_datetime ();
void unittest_decoder ();
void unittest_imagefile ();
void unittest_io ();
void unittest_os ();
void unittest_string ();
void unittest_system ();

void unittest_bytearray ();
void unittest_charset ();
void unittest_zlib_functions ();

int
main ()
{
  unittest_core ();
  unittest_crypt ();
  unittest_datetime ();
  unittest_decoder ();
  unittest_imagefile ();
  unittest_io ();
  unittest_os ();
  unittest_system ();

  unittest_bytearray ();
  unittest_charset ();
  unittest_string ();
  unittest_zlib_functions ();

  mobius::unittest::final_summary ();
}
