# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode data from emuletorrent.ini
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (f):

  # try to open file
  reader = f.new_reader ()
  if not reader:
    return

  # read preferences.ini
  text = reader.read ()
  group = ''
  config = {}
    
  for line in text.split ('\n'):
    line = line.rstrip ('\r\0 ')

    if line.startswith ('['):
      group = line[1:-1]

    elif line:
      varname, value = line.split ('=', 1)
      key = '%s.%s' % (group.lower (), varname.lower ().replace ('\\', '.'))
      config[key] = value

  # get data
  data = dataholder ()
  data.downloads_savepath = config.get ('preferences.downloads.savepath')
  data.downloads_emule_savepath = config.get ('preferences.downloads.savepathmule')
  data.downloads_temppath = config.get ('preferences.downloads.temppath')
  data.downloads_emule_temppath = config.get ('preferences.downloads.temppathmule')
  data.nickname = config.get ('preferences.edonkey.nick')
  data.guid = config.get ('preferences.edonkey.userhash')
  data.config = config
  
  return data
