#ifndef __MOBIUS_FILESYSTEM_ENTRY_IMPL_BASE_H__
#define __MOBIUS_FILESYSTEM_ENTRY_IMPL_BASE_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/filesystem/stream_impl_base.h>
#include <mobius/datetime/datetime.h>
#include <cstdint>
#include <string>
#include <vector>
#include <memory>

namespace mobius
{
namespace filesystem
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief entry implementation base class
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class entry_impl_base
{
public:
  enum class entry_type { unknown, file, folder, link };
  virtual ~entry_impl_base () = default;

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  // function prototypes
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  bool is_folder () const;
  bool is_file () const;

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  // abstract functions
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  virtual std::uint64_t get_inode () const = 0;
  virtual bool is_deleted () const = 0;
  virtual const std::string get_name () const = 0;
  virtual const std::string get_short_name () const = 0;
  virtual entry_type get_type () const = 0;
  virtual std::uint64_t get_size () const = 0;
  virtual int get_mode () const = 0;
  virtual bool is_reallocated () const = 0;
  virtual int get_uid () const = 0;
  virtual int get_gid () const = 0;
  virtual const mobius::datetime::datetime get_creation_time () const = 0;
  virtual const mobius::datetime::datetime get_last_modification_time () const = 0;
  virtual const mobius::datetime::datetime get_last_access_time () const = 0;
  virtual const mobius::datetime::datetime get_last_metadata_time () const = 0;
  virtual const mobius::datetime::datetime get_deletion_time () const = 0;
  virtual const std::vector <std::shared_ptr <entry_impl_base>> get_children () const = 0;
  virtual std::shared_ptr <entry_impl_base> get_parent () const = 0;
  virtual std::shared_ptr <entry_impl_base> get_child_by_name (const std::string&, bool) const = 0;
  virtual const std::vector <std::shared_ptr <stream_impl_base>> get_streams () const = 0;
  virtual const mobius::io::reader new_reader () const = 0;

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief get path
  //! \return path
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  const std::string
  get_path () const
  {
    return path_;
  }

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief set path
  //! \param path path
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  void
  set_path (const std::string& path)
  {
    path_ = path;
  }

private:
  //! \brief path
  std::string path_;
};

} // namespace filesystem
} // namespace mobius

#endif
