// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.imagefile module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include "imagefile.h"
#include "imagefile_dossier.h"
#include "imagefile_ewf.h"
#include "imagefile_msr.h"
#include "imagefile_raw.h"
#include "imagefile_solo.h"
#include "imagefile_split.h"
#include "imagefile_talon.h"
#include "imagefile_vhd.h"
#include "imagefile_vhdx.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief functions prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject* func_new_imagefile_by_path (PyObject *, PyObject *);
PyObject* func_new_imagefile_by_url (PyObject *, PyObject *);
PyObject* func_new_imagefile_from_file (PyObject *, PyObject *);
PyObject* func_get_imagefile_types (PyObject *, PyObject *);

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    "new_imagefile_by_path",
    func_new_imagefile_by_path,
    METH_VARARGS,
    "Create new imagefile by file path"
  },
  {
    "new_imagefile_by_url",
    func_new_imagefile_by_url,
    METH_VARARGS,
    "Create new imagefile by file URL"
  },
  {
    "new_imagefile_from_file",
    func_new_imagefile_from_file,
    METH_VARARGS,
    "Create new imagefile from file"
  },
  {
    "get_imagefile_types",
    func_get_imagefile_types,
    METH_VARARGS,
    "Get imagefile types available"
  },
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module datatypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static constexpr struct
{
  const char *name;
  PyTypeObject *type;
} types[] =

{
  {"imagefile", &imagefile_imagefile_t},
  {"imagefile_dossier", &imagefile_imagefile_dossier_t},
  {"imagefile_ewf", &imagefile_imagefile_ewf_t},
  {"imagefile_msr", &imagefile_imagefile_msr_t},
  {"imagefile_raw", &imagefile_imagefile_raw_t},
  {"imagefile_solo", &imagefile_imagefile_solo_t},
  {"imagefile_split", &imagefile_imagefile_split_t},
  {"imagefile_talon", &imagefile_imagefile_talon_t},
  {"imagefile_vhd", &imagefile_imagefile_vhd_t},
  {"imagefile_vhdx", &imagefile_imagefile_vhdx_t},
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
new_imagefile_module ()
{
  // initialize module mobius.imagefile
  PyObject* module = Py_InitModule3 (
                       "mobius.imagefile",
                       module_methods,
                       "Mobius Forensic Toolkit mobius.imagefile module"
                     );

  // build types
  for (const auto& t : types)
    {
      if (PyType_Ready (t.type) < 0)
        return nullptr;
    }

  // add types
  for (const auto& t : types)
    {
      Py_INCREF (t.type);
      PyModule_AddObject (module, t.name, (PyObject *) t.type);
    }

  // return module
  return module;
}
