// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/imagefile/imagefile.h>
#include "imagefile_impl.h"
#include <cstdint>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Extension data
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
extern "C"
{
const char *EXTENSION_ID = "imagefile-talon";
const char *EXTENSION_NAME = "Logicube Dossier image file";
const char *EXTENSION_VERSION = "1.0";
const char *EXTENSION_AUTHORS = "Eduardo Aguiar";
const char *EXTENSION_DESCRIPTION = "Logicube Dossier image file support";

std::uint8_t EXTENSION_ICON_DATA[] =
{
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48, 0x44, 0x52,
  0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x3f, 0x08, 0x06, 0x00, 0x00, 0x00, 0xb8, 0x9d, 0x7b,
  0xe1, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x04, 0x7a, 0x00, 0x00, 0x04,
  0x7a, 0x01, 0x66, 0x4a, 0x25, 0xb0, 0x00, 0x00, 0x00, 0x19, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6f,
  0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x6e, 0x6b, 0x73, 0x63,
  0x61, 0x70, 0x65, 0x2e, 0x6f, 0x72, 0x67, 0x9b, 0xee, 0x3c, 0x1a, 0x00, 0x00, 0x0d, 0x21, 0x49,
  0x44, 0x41, 0x54, 0x68, 0x81, 0xed, 0x5b, 0x4b, 0x8c, 0x5d, 0x47, 0x5a, 0xfe, 0xfe, 0xbf, 0x1e,
  0xe7, 0xdc, 0x6b, 0x77, 0xdf, 0x76, 0xfb, 0xd5, 0xb6, 0x13, 0x3b, 0x89, 0x1d, 0x8f, 0xc7, 0x49,
  0xc6, 0x4c, 0x48, 0x66, 0x06, 0x85, 0x91, 0x98, 0x28, 0x08, 0x81, 0xc4, 0x08, 0x24, 0x12, 0x8d,
  0x84, 0x04, 0x2b, 0x8c, 0xc4, 0x88, 0x2c, 0x58, 0xb0, 0xc9, 0xe6, 0xae, 0x40, 0x6c, 0x40, 0xca,
  0xb0, 0x09, 0x12, 0x52, 0x14, 0x84, 0x46, 0x78, 0x11, 0x34, 0x6c, 0x00, 0x31, 0x24, 0x5e, 0x00,
  0xc9, 0xe0, 0xd1, 0xe4, 0x31, 0x93, 0x4c, 0x42, 0x9c, 0xc4, 0xaf, 0x76, 0xbb, 0xdd, 0xef, 0xee,
  0xfb, 0x38, 0xe7, 0x54, 0xd5, 0xff, 0xb3, 0xb8, 0xb7, 0x8d, 0xdd, 0xdd, 0xee, 0x87, 0xdd, 0xdd,
  0xf6, 0xa0, 0xf9, 0xd4, 0x47, 0xad, 0x5b, 0xa7, 0x6e, 0xd5, 0xff, 0x9d, 0xaa, 0x53, 0xf5, 0x7d,
  0x55, 0x75, 0x09, 0x5b, 0x80, 0x6f, 0x7e, 0xe7, 0x3f, 0x0e, 0x3a, 0x54, 0x4f, 0xa8, 0xa1, 0x2f,
  0x22, 0xe1, 0xa8, 0x32, 0x8e, 0x92, 0xd2, 0x41, 0x10, 0xf6, 0x92, 0x22, 0x27, 0x43, 0x0e, 0x50,
  0x07, 0x25, 0xcb, 0x04, 0xab, 0xaa, 0x11, 0x4c, 0x11, 0x8a, 0x00, 0xa0, 0x02, 0x50, 0x00, 0x3a,
  0x0e, 0xc5, 0x28, 0x93, 0x7e, 0x06, 0x36, 0xe7, 0x59, 0xf9, 0x63, 0x18, 0xfb, 0xfe, 0x77, 0xff,
  0xe0, 0x6b, 0xe3, 0x9b, 0x11, 0x23, 0xdd, 0x6d, 0x01, 0xcf, 0x9f, 0xf9, 0xc0, 0xc7, 0xa9, 0xc9,
  0x5f, 0x96, 0xa8, 0xdf, 0x22, 0xc8, 0x33, 0xcc, 0xfc, 0x30, 0x80, 0x1a, 0xdd, 0x52, 0x3a, 0xdd,
  0x52, 0x11, 0xdd, 0xf4, 0x81, 0x96, 0x24, 0xde, 0x3e, 0x5f, 0xef, 0x83, 0xaa, 0xb4, 0x55, 0xf5,
  0x3c, 0x88, 0xde, 0x74, 0xc6, 0xbc, 0x5e, 0x97, 0xfc, 0xed, 0xbf, 0xf9, 0xc3, 0xa7, 0xc2, 0x46,
  0xe3, 0xbe, 0x23, 0xe2, 0xcf, 0x9f, 0xf9, 0xc0, 0x57, 0x93, 0x13, 0xbf, 0x4b, 0x8a, 0x3f, 0x26,
  0xe0, 0x09, 0x02, 0xec, 0x8a, 0x05, 0x6f, 0x90, 0xf8, 0xd2, 0x60, 0x56, 0x22, 0xbe, 0x34, 0x5d,
  0x81, 0x4a, 0x52, 0xfa, 0xa1, 0x33, 0xfc, 0x97, 0x57, 0xae, 0xa6, 0xef, 0x9d, 0x6d, 0x7e, 0x23,
  0xae, 0x87, 0xc3, 0x86, 0x88, 0x3f, 0xff, 0xca, 0xbf, 0x35, 0xaa, 0xca, 0xfd, 0x15, 0x13, 0xbe,
  0x45, 0x84, 0xda, 0x9a, 0x05, 0xaf, 0x9b, 0x38, 0x2d, 0xfe, 0xdd, 0x5a, 0xc6, 0x3a, 0x88, 0xff,
  0x5f, 0x5d, 0x04, 0x11, 0x69, 0x41, 0xf5, 0x6f, 0x6d, 0xbd, 0x78, 0xe9, 0xef, 0x7e, 0xef, 0xd7,
  0xda, 0x6b, 0xc6, 0xb7, 0x1e, 0xfc, 0xf6, 0x5f, 0xbf, 0xf1, 0x27, 0x00, 0xfd, 0x19, 0x11, 0x65,
  0xeb, 0xc9, 0xbf, 0x5d, 0xc4, 0x57, 0x7a, 0x55, 0x44, 0xa4, 0x9d, 0x62, 0xfc, 0xa3, 0x7f, 0xf8,
  0xf6, 0xb3, 0xaf, 0xad, 0x1a, 0xdf, 0xaa, 0x50, 0xa5, 0xdf, 0xfc, 0xce, 0x1b, 0xff, 0xe9, 0x8c,
  0xf9, 0xa5, 0x35, 0xf3, 0x2e, 0x2d, 0xf8, 0x1e, 0x11, 0x5f, 0x44, 0x55, 0x55, 0xaf, 0x9d, 0xf9,
  0xf6, 0xb3, 0xbf, 0xbf, 0x52, 0x7c, 0x66, 0xf5, 0xf0, 0x81, 0x5f, 0xdf, 0xf5, 0xf5, 0xd7, 0x33,
  0x6b, 0x7f, 0x75, 0xad, 0x7c, 0x4b, 0x71, 0x3f, 0x10, 0xb7, 0xd6, 0x9c, 0x7a, 0xf8, 0x1b, 0xbf,
  0xd3, 0xfe, 0xf8, 0x5f, 0xff, 0xfe, 0xbf, 0x96, 0xc6, 0xc7, 0xab, 0x05, 0xff, 0x2b, 0x7f, 0xfe,
  0xcf, 0x0f, 0x39, 0xe6, 0xdf, 0x5a, 0x2d, 0xcf, 0xb6, 0x63, 0x83, 0xc3, 0xb1, 0x35, 0xfe, 0xa5,
  0x95, 0xd2, 0x57, 0x25, 0x6e, 0x1c, 0x3f, 0xb5, 0xf1, 0xaa, 0x96, 0xe3, 0xae, 0x0b, 0xb8, 0x0b,
  0xa8, 0xca, 0xd0, 0x37, 0xff, 0xe2, 0x7b, 0x03, 0x4b, 0xd3, 0x57, 0x25, 0x3e, 0x75, 0xe1, 0x32,
  0x55, 0x41, 0xb6, 0x2e, 0xaa, 0x6d, 0x40, 0xbb, 0xd3, 0x99, 0xcc, 0x1e, 0x3e, 0xb4, 0x8c, 0xe7,
  0xaa, 0xc4, 0x27, 0x3e, 0xfd, 0xa4, 0xd6, 0x9e, 0x9b, 0x7f, 0xab, 0x0a, 0x69, 0xf3, 0x22, 0x59,
  0x67, 0xf3, 0x6f, 0x46, 0x2f, 0x99, 0x9d, 0x99, 0x45, 0x36, 0x34, 0x78, 0x69, 0xa5, 0x7b, 0xab,
  0x12, 0x07, 0x80, 0x0b, 0xef, 0xfe, 0xe8, 0x17, 0xe7, 0x66, 0x17, 0xfe, 0xbb, 0x5b, 0x06, 0xa8,
  0x6e, 0x42, 0x34, 0x5b, 0x88, 0xc5, 0x87, 0x95, 0x52, 0xc4, 0xc4, 0xc4, 0x64, 0x54, 0x6f, 0xcf,
  0x0d, 0xee, 0x19, 0x7e, 0x72, 0xa5, 0xbc, 0xcb, 0x14, 0xd7, 0x52, 0xa8, 0x88, 0xbf, 0xf8, 0xa3,
  0x73, 0x5f, 0x19, 0x1c, 0x19, 0x79, 0x6f, 0xff, 0xd1, 0xe3, 0xfb, 0x73, 0x6f, 0x46, 0xbc, 0xb3,
  0xcb, 0x44, 0xc4, 0xfd, 0x80, 0x94, 0x04, 0x0b, 0xad, 0x16, 0xda, 0xad, 0xd6, 0x87, 0x7b, 0x8e,
  0x1c, 0x1a, 0xf2, 0xf5, 0xda, 0xd3, 0xb7, 0xcb, 0xbb, 0x26, 0xf1, 0x45, 0x2c, 0x5c, 0xbf, 0x7e,
  0xaa, 0x33, 0x33, 0x1b, 0x76, 0x1d, 0x3c, 0xf4, 0x83, 0xc6, 0xc8, 0xc8, 0x70, 0x96, 0xb9, 0x47,
  0x9d, 0xb5, 0x30, 0x66, 0xb9, 0xd4, 0xdc, 0x4e, 0xa8, 0x28, 0x8a, 0xaa, 0x44, 0xbb, 0xdd, 0x4d,
  0x21, 0x85, 0xf7, 0x76, 0xec, 0x1e, 0xae, 0xef, 0x3f, 0xb0, 0xf7, 0x24, 0xf3, 0xea, 0x51, 0xad,
  0x9b, 0x38, 0x00, 0x48, 0x8a, 0x6e, 0x66, 0xf4, 0xf2, 0x57, 0x67, 0xc7, 0x46, 0x91, 0x0f, 0xee,
  0xbc, 0xdc, 0xd8, 0x37, 0x72, 0x39, 0x1f, 0x68, 0xec, 0xb1, 0xde, 0x3d, 0xea, 0x0c, 0x93, 0x31,
  0x04, 0x43, 0x04, 0xda, 0xc2, 0xee, 0x20, 0x22, 0x88, 0x31, 0xa2, 0x2c, 0x2b, 0x14, 0x55, 0x55,
  0xa6, 0x10, 0x3f, 0xf2, 0x79, 0x56, 0xd6, 0xf7, 0x0e, 0x9d, 0x70, 0xce, 0x3d, 0x49, 0xbc, 0xe6,
  0xdb, 0x0b, 0x60, 0x83, 0xc4, 0x6f, 0x46, 0xd9, 0x6a, 0x3f, 0x38, 0xd9, 0xf9, 0xfc, 0x41, 0x62,
  0x06, 0x5b, 0xaf, 0x59, 0xcd, 0xc1, 0xe6, 0x19, 0x5c, 0x5e, 0x47, 0x6d, 0x60, 0x10, 0x2e, 0xcb,
  0xc1, 0x44, 0x60, 0x22, 0x18, 0x26, 0x30, 0x71, 0xef, 0xf5, 0x60, 0x02, 0xf7, 0xc5, 0xca, 0xcd,
  0x0f, 0x48, 0x55, 0xa1, 0xe8, 0xb5, 0xa0, 0x42, 0x21, 0x22, 0x90, 0x94, 0x90, 0x44, 0x21, 0x92,
  0x10, 0x42, 0x42, 0x55, 0x74, 0x91, 0x52, 0x84, 0xb1, 0x8c, 0xac, 0x96, 0xa3, 0xbe, 0xab, 0x91,
  0x59, 0x63, 0x4e, 0x11, 0x13, 0xd6, 0x4b, 0xf8, 0xae, 0x89, 0xdf, 0x0c, 0x95, 0x48, 0x55, 0x57,
  0x10, 0xca, 0x0a, 0xc5, 0x42, 0x1b, 0xed, 0xa9, 0x29, 0x30, 0x1b, 0x90, 0x65, 0x30, 0x33, 0xc8,
  0x18, 0xb0, 0x31, 0x60, 0x66, 0x80, 0x18, 0x44, 0x0c, 0x10, 0x7a, 0xf7, 0x08, 0x10, 0x55, 0x90,
  0x6a, 0x6f, 0xf0, 0x24, 0x80, 0x14, 0x00, 0xf7, 0xee, 0x5b, 0x67, 0x61, 0xbc, 0x87, 0xcb, 0x33,
  0xf8, 0x7a, 0x03, 0xc4, 0xd4, 0xfb, 0x1e, 0xf3, 0x5d, 0xf5, 0xac, 0x4d, 0x21, 0xbe, 0x12, 0x54,
  0x15, 0x48, 0x0a, 0x55, 0x01, 0x14, 0x10, 0x51, 0xa0, 0x1f, 0x30, 0xfa, 0xc1, 0x03, 0xbd, 0x34,
  0xcb, 0x8c, 0xc5, 0x56, 0xbb, 0x41, 0x8a, 0x19, 0xdc, 0x4f, 0x23, 0xe6, 0x4d, 0x1f, 0x47, 0x36,
  0xd6, 0x3f, 0xfe, 0x1f, 0xe1, 0xe7, 0xc4, 0x57, 0x84, 0xca, 0xee, 0x6d, 0x8a, 0x63, 0xdb, 0xb1,
  0x2a, 0x71, 0x57, 0xe3, 0xc7, 0xb7, 0x2b, 0x90, 0xad, 0x82, 0x88, 0x60, 0xfa, 0xfc, 0xa5, 0x65,
  0x63, 0xd9, 0xaa, 0xc4, 0x07, 0x77, 0x0f, 0x7f, 0x04, 0xfc, 0x6c, 0x9b, 0x94, 0xd6, 0xd4, 0x14,
  0xf2, 0x9a, 0x6f, 0x2c, 0x4d, 0x5f, 0x95, 0x78, 0x6b, 0xbe, 0xfb, 0x41, 0xad, 0xee, 0x22, 0x70,
  0x9f, 0x8b, 0xf4, 0xdb, 0xa0, 0xec, 0x76, 0x30, 0x7d, 0xe5, 0xea, 0xc4, 0xde, 0x87, 0x0e, 0x2d,
  0x6b, 0xbd, 0x55, 0x89, 0x17, 0x0b, 0x5d, 0xe3, 0x06, 0x77, 0xbf, 0x9f, 0xd5, 0x48, 0x55, 0xd7,
  0xb5, 0x78, 0x79, 0xdf, 0x60, 0x61, 0x72, 0x12, 0xa3, 0x3f, 0x3d, 0x5f, 0x8d, 0x7c, 0xe1, 0x78,
  0x6b, 0xa5, 0xfb, 0x6b, 0xce, 0xe3, 0xf3, 0xd7, 0xc6, 0x9f, 0x6c, 0x1c, 0x38, 0xf8, 0xee, 0xe0,
  0x88, 0x7d, 0x64, 0xea, 0xc2, 0xa7, 0x83, 0x4a, 0x75, 0xd0, 0x7d, 0x3c, 0x19, 0x14, 0xed, 0x16,
  0xa6, 0x2f, 0x5d, 0x41, 0x52, 0x8c, 0x1e, 0x3a, 0x71, 0xac, 0xca, 0xeb, 0xb5, 0x87, 0x57, 0xea,
  0xb1, 0xeb, 0x12, 0x30, 0xf3, 0xe3, 0xd7, 0x7e, 0xa1, 0xe3, 0x5d, 0x77, 0xe4, 0xc4, 0xa9, 0x73,
  0x65, 0x6b, 0xfa, 0xcb, 0x73, 0x63, 0x57, 0xad, 0xb0, 0x03, 0xfb, 0xfa, 0xa6, 0x07, 0x7e, 0x27,
  0x90, 0x94, 0xd0, 0x9a, 0xb8, 0x8e, 0xf6, 0xcc, 0x0c, 0x92, 0x70, 0x77, 0xd7, 0xc8, 0xfe, 0xf7,
  0x86, 0x0e, 0xec, 0xfb, 0x8a, 0x31, 0xe6, 0xb6, 0x2d, 0xb4, 0x6e, 0xe5, 0x26, 0x31, 0xd5, 0xae,
  0x7d, 0x72, 0xfe, 0x69, 0xe3, 0xfc, 0xc2, 0xee, 0x23, 0x27, 0xde, 0x25, 0x83, 0x63, 0x9d, 0xe9,
  0xf1, 0x03, 0xc5, 0xc2, 0x1c, 0x14, 0x0c, 0x97, 0xef, 0x84, 0x61, 0xbf, 0x39, 0x4c, 0xd6, 0x80,
  0xaa, 0xa2, 0x6a, 0x2d, 0xa0, 0xb3, 0xb0, 0x80, 0xaa, 0xdb, 0x85, 0x24, 0x81, 0xab, 0xed, 0xbc,
  0xd0, 0x18, 0x79, 0x60, 0x6a, 0x60, 0x78, 0xe8, 0x4b, 0x6c, 0xf9, 0x6b, 0x6b, 0xc9, 0xd9, 0x0d,
  0x4b, 0x56, 0x49, 0x71, 0x60, 0x7a, 0xf4, 0xf2, 0xd7, 0x89, 0x18, 0xbe, 0x56, 0xbf, 0x38, 0x7c,
  0xf8, 0xe4, 0x45, 0xe3, 0x68, 0x77, 0xe8, 0xce, 0x7f, 0xa1, 0x68, 0xcd, 0xdb, 0xd8, 0xe9, 0x22,
  0xc5, 0x00, 0x63, 0x33, 0xb0, 0xcf, 0x60, 0xbd, 0x87, 0xb5, 0x1e, 0xb4, 0xd1, 0x87, 0xa2, 0x8a,
  0x54, 0x05, 0x48, 0x8a, 0x90, 0x94, 0x10, 0x43, 0x81, 0x54, 0x45, 0x24, 0x15, 0x40, 0x15, 0xc6,
  0xd5, 0x82, 0xaf, 0x0f, 0x5c, 0x1c, 0xd8, 0x3b, 0xd4, 0xaa, 0xef, 0xac, 0x1d, 0x76, 0xb5, 0xfc,
  0x21, 0x62, 0x7e, 0x88, 0xd6, 0xb0, 0xa3, 0x77, 0x4c, 0xfc, 0x66, 0x84, 0xb2, 0x38, 0x32, 0x77,
  0x6d, 0xf4, 0x08, 0x31, 0x83, 0x0d, 0xc3, 0xfa, 0x1a, 0x6a, 0xbb, 0x06, 0xe0, 0xf2, 0x1c, 0x44,
  0x04, 0x85, 0x40, 0x44, 0xa1, 0xa1, 0x42, 0x28, 0x16, 0xa0, 0x31, 0x00, 0x04, 0x28, 0x08, 0x80,
  0x82, 0x89, 0xa0, 0xe8, 0x99, 0x11, 0x05, 0xc1, 0x18, 0x86, 0x2a, 0xf5, 0xb4, 0xbc, 0xb5, 0x60,
  0x76, 0x60, 0x63, 0x7b, 0xc6, 0xc4, 0x66, 0x70, 0x3b, 0x6a, 0xa8, 0x7b, 0x07, 0xb7, 0xa3, 0x8e,
  0x3c, 0xaf, 0x3b, 0x32, 0x7c, 0x8c, 0x6e, 0xe8, 0xfe, 0x8d, 0x61, 0xd3, 0x4c, 0x8a, 0xaa, 0x22,
  0x85, 0x08, 0x49, 0x82, 0x58, 0xc5, 0xbe, 0xd9, 0x58, 0x34, 0x19, 0x16, 0xae, 0x36, 0xd0, 0x23,
  0xca, 0x00, 0x93, 0x01, 0x91, 0x82, 0xd8, 0x00, 0x0a, 0x50, 0xdf, 0xa7, 0x12, 0x1b, 0x10, 0xf5,
  0xee, 0xf7, 0x5c, 0x99, 0x03, 0x1b, 0xb3, 0xa2, 0x69, 0xb9, 0x5b, 0xd7, 0xb2, 0x65, 0xee, 0xec,
  0x66, 0x10, 0x14, 0x50, 0x82, 0x12, 0x81, 0xd1, 0x5b, 0xa8, 0x20, 0x36, 0x37, 0x39, 0x31, 0x5a,
  0xe2, 0xca, 0xb8, 0xff, 0x30, 0xb6, 0x6e, 0x41, 0xe3, 0xfe, 0x9d, 0x97, 0xb6, 0x18, 0x3f, 0x27,
  0xbe, 0x12, 0xac, 0xd5, 0x87, 0xb7, 0x2b, 0x90, 0xad, 0x84, 0x22, 0x2d, 0xdb, 0x23, 0x5c, 0x95,
  0x78, 0x3e, 0xd4, 0x38, 0xb6, 0x75, 0xe1, 0x6c, 0x0f, 0x54, 0x04, 0xa3, 0x1f, 0x5d, 0x5c, 0x26,
  0xdd, 0xd6, 0x70, 0x67, 0xfb, 0xcf, 0x91, 0x6e, 0xf8, 0x94, 0xc5, 0x7d, 0x85, 0xe9, 0xab, 0x63,
  0x7a, 0xe0, 0xd0, 0xb1, 0x65, 0x7a, 0x7d, 0x55, 0xe2, 0xe3, 0x9f, 0x7c, 0x16, 0x86, 0x0f, 0x1f,
  0xbe, 0xfe, 0xb3, 0x66, 0x50, 0x16, 0x31, 0x3f, 0x31, 0x81, 0xce, 0x7c, 0xeb, 0x27, 0xd1, 0x2e,
  0xdf, 0x00, 0x5c, 0x95, 0x78, 0x52, 0xa1, 0x85, 0x89, 0xf9, 0xb4, 0xef, 0xa1, 0x23, 0x33, 0x48,
  0x1d, 0xdc, 0xf7, 0x7b, 0x48, 0x7d, 0xa4, 0x2a, 0x60, 0xfc, 0xfc, 0x79, 0xcc, 0x8d, 0x5d, 0xff,
  0xe4, 0xc1, 0x13, 0xc7, 0xbf, 0xb8, 0x52, 0x9e, 0x35, 0x47, 0xf5, 0xaa, 0xe8, 0x1c, 0x98, 0xbe,
  0x7a, 0x9d, 0xf7, 0x9f, 0x7c, 0xf2, 0x87, 0xb5, 0x01, 0xaf, 0x12, 0x5a, 0xbd, 0x15, 0xd4, 0xfb,
  0x10, 0x31, 0x54, 0x98, 0xba, 0x7c, 0x19, 0x57, 0x3e, 0xf8, 0xa8, 0xca, 0xea, 0x83, 0xe7, 0x1e,
  0x7c, 0xe2, 0xb1, 0x63, 0x60, 0x5a, 0x51, 0xab, 0xac, 0x4b, 0xc0, 0xa4, 0x10, 0x1a, 0xe3, 0x1f,
  0x7f, 0xf4, 0x54, 0x6d, 0x68, 0xd7, 0x67, 0x0f, 0x3c, 0x7e, 0xac, 0xd5, 0x9e, 0xb9, 0xf6, 0xf8,
  0xfc, 0xb5, 0xab, 0x0c, 0xce, 0xee, 0xb9, 0x43, 0x93, 0x18, 0xd1, 0x6e, 0xcd, 0xa3, 0x3d, 0x3d,
  0x8b, 0xaa, 0x0c, 0xe5, 0xce, 0xe1, 0xe1, 0x1f, 0x3f, 0xf0, 0xf8, 0x63, 0xc7, 0x5c, 0x66, 0x9f,
  0x5e, 0x4d, 0xdd, 0x6d, 0x48, 0xb9, 0x15, 0xf3, 0x73, 0x8f, 0x5c, 0x6d, 0x2d, 0xc0, 0xd7, 0x6a,
  0xb3, 0x7b, 0x1e, 0xfd, 0xd2, 0xc7, 0xa4, 0xf1, 0x50, 0x77, 0x76, 0xf2, 0x81, 0xee, 0xdc, 0x0c,
  0x54, 0x04, 0xc6, 0xd5, 0x60, 0x7c, 0x1d, 0xe6, 0x0e, 0xb4, 0xf3, 0x7a, 0x11, 0xaa, 0x12, 0xb1,
  0x28, 0x50, 0x75, 0xda, 0xa8, 0x8a, 0x02, 0x02, 0x44, 0xef, 0xeb, 0x17, 0x06, 0xf6, 0x8d, 0xcc,
  0x0e, 0x0c, 0x35, 0x4e, 0xb1, 0x35, 0x4f, 0xad, 0x67, 0x57, 0xe5, 0x8e, 0x24, 0x6b, 0x2c, 0xcb,
  0xa1, 0xe9, 0x8b, 0x17, 0xbe, 0x4a, 0xcc, 0xb0, 0xce, 0x77, 0x77, 0xee, 0x3b, 0x3c, 0xef, 0xbd,
  0x1b, 0x4c, 0x12, 0x73, 0x89, 0x25, 0x55, 0x9d, 0x16, 0xca, 0x4e, 0xd1, 0xdb, 0x4c, 0x20, 0x03,
  0x6b, 0x1d, 0x8c, 0xcf, 0x60, 0x9c, 0xef, 0xed, 0xa8, 0x18, 0x0b, 0x32, 0x06, 0x30, 0x16, 0x04,
  0x05, 0x81, 0xa0, 0x29, 0xdd, 0x38, 0x07, 0xa3, 0xaa, 0x50, 0x8d, 0x90, 0xd8, 0x73, 0x66, 0x2a,
  0x02, 0x55, 0x81, 0x82, 0x41, 0xc6, 0xc1, 0x58, 0x27, 0x3e, 0xcf, 0x5a, 0x43, 0x07, 0x76, 0x17,
  0xf5, 0xc1, 0xc1, 0xdd, 0x6c, 0xf8, 0xd8, 0xa2, 0xf4, 0x5d, 0x2f, 0xee, 0x5a, 0xab, 0x4b, 0x8a,
  0xb5, 0xee, 0xdc, 0x5c, 0xad, 0xb8, 0x61, 0x22, 0x0c, 0xac, 0xdf, 0x09, 0xbf, 0x63, 0x08, 0xc6,
  0x5a, 0x30, 0x9b, 0xde, 0xfa, 0x87, 0x44, 0xa8, 0x68, 0xff, 0x3c, 0x5a, 0x04, 0x25, 0x20, 0x55,
  0x45, 0xaf, 0x10, 0x22, 0x90, 0xb1, 0x20, 0xed, 0xef, 0xb6, 0x80, 0x40, 0x86, 0xc1, 0xc6, 0xc3,
  0x79, 0x0b, 0x62, 0x86, 0xb5, 0x16, 0x59, 0x7d, 0x07, 0x6c, 0xee, 0xc0, 0xcc, 0x4c, 0xcc, 0x83,
  0xc4, 0x3c, 0x78, 0xa7, 0xdb, 0x48, 0x9b, 0x6f, 0x52, 0x54, 0x91, 0xa2, 0x40, 0x25, 0x42, 0x82,
  0xdc, 0xe2, 0xa8, 0x98, 0x7b, 0x4e, 0xcb, 0x58, 0xd7, 0x37, 0x22, 0xf5, 0x7e, 0x1a, 0xad, 0xb9,
  0x85, 0xb4, 0x98, 0xbe, 0x59, 0xb8, 0xe7, 0x5a, 0x5d, 0xef, 0xd1, 0x0a, 0xee, 0x3d, 0x27, 0x7e,
  0xaf, 0xb0, 0x2a, 0x71, 0x22, 0xda, 0x9e, 0x45, 0xb4, 0x7b, 0x80, 0xd5, 0x5b, 0x5c, 0x8a, 0xe3,
  0xdb, 0x14, 0xc7, 0x96, 0x62, 0x6a, 0x6e, 0x6a, 0x63, 0xc7, 0xbd, 0x54, 0xe3, 0x4f, 0xb6, 0x2e,
  0x9c, 0xed, 0x41, 0xd1, 0x6a, 0x6b, 0x35, 0xfe, 0xd6, 0xf4, 0xd2, 0xf4, 0x15, 0x47, 0xf5, 0x66,
  0xb3, 0x69, 0xf7, 0xee, 0xdd, 0x9b, 0xff, 0xcf, 0xe8, 0xec, 0x1b, 0xaf, 0xbf, 0x3b, 0x39, 0x03,
  0xae, 0xef, 0x5a, 0x57, 0x2d, 0xfd, 0x13, 0x0d, 0xf7, 0x0b, 0x54, 0x04, 0x53, 0x97, 0x2e, 0xfd,
  0xd3, 0xd9, 0x66, 0x73, 0x99, 0xcb, 0xba, 0x25, 0xcc, 0x57, 0x5e, 0x79, 0xc5, 0xcd, 0xce, 0xce,
  0xe6, 0x29, 0xa5, 0xdc, 0x18, 0x93, 0x55, 0x55, 0x95, 0xbd, 0xfd, 0xf9, 0xe4, 0x63, 0xef, 0x8f,
  0xe3, 0xbb, 0xec, 0x06, 0xeb, 0x4b, 0xd7, 0xc4, 0x96, 0x4d, 0x3f, 0xb4, 0x7c, 0xfa, 0x59, 0x69,
  0x4a, 0xba, 0xdd, 0x1a, 0xdb, 0x7a, 0xa6, 0xb3, 0xf5, 0x7e, 0x57, 0x53, 0xc4, 0xc4, 0x67, 0x9f,
  0x7e, 0xf8, 0x65, 0x3b, 0xfb, 0x1b, 0x47, 0x06, 0x65, 0x66, 0x64, 0x64, 0xa4, 0x78, 0xe1, 0x85,
  0x17, 0xaa, 0x45, 0xae, 0x06, 0x00, 0x54, 0x95, 0x1a, 0x8d, 0x46, 0xad, 0xd5, 0x6a, 0xd5, 0x53,
  0x4a, 0x75, 0x11, 0xa9, 0x03, 0xa8, 0xc7, 0x18, 0x77, 0x1c, 0x6a, 0xd4, 0xca, 0x5d, 0x75, 0xfa,
  0xf7, 0xb1, 0xe9, 0xb9, 0x47, 0x22, 0xf8, 0x20, 0x19, 0xd7, 0x5b, 0x2c, 0x5c, 0xe9, 0xe2, 0xdb,
  0xa4, 0x6f, 0xe7, 0x05, 0x60, 0x7e, 0x7c, 0x5c, 0xe6, 0x3e, 0xfd, 0xe9, 0x6b, 0xa7, 0x30, 0xfa,
  0xa7, 0xfb, 0xf2, 0x14, 0x52, 0x4a, 0xdc, 0x6e, 0xb7, 0xf9, 0xb9, 0xe7, 0x9e, 0xe3, 0x67, 0x9e,
  0x79, 0x26, 0x9d, 0x3d, 0x7b, 0x56, 0x0d, 0x00, 0x6a, 0x34, 0x1a, 0x79, 0x59, 0x96, 0xb9, 0x88,
  0xe4, 0x22, 0x92, 0x03, 0xc8, 0x45, 0xa4, 0x16, 0x63, 0xac, 0x01, 0xa8, 0xed, 0xb4, 0xaa, 0x27,
  0xf6, 0xfa, 0xb7, 0x52, 0xd5, 0xfe, 0x7c, 0xb6, 0xdd, 0x3d, 0x9c, 0xa0, 0x0d, 0xb6, 0x1e, 0x44,
  0x7c, 0xef, 0x89, 0xf6, 0xaf, 0x14, 0x02, 0xe6, 0xc6, 0xc6, 0x64, 0xfe, 0xe2, 0x27, 0x6f, 0x3f,
  0xd8, 0xfa, 0xfc, 0xa5, 0x53, 0x3b, 0x3b, 0xdf, 0xcf, 0x0d, 0x92, 0x31, 0xbd, 0x55, 0x27, 0x55,
  0x85, 0xb5, 0x16, 0x65, 0x59, 0xe2, 0xcd, 0x37, 0xdf, 0x8c, 0xb4, 0xf8, 0x3e, 0x77, 0xbb, 0xdd,
  0x3c, 0xa5, 0x94, 0x57, 0x55, 0x55, 0x53, 0xd5, 0x3c, 0x04, 0xe4, 0x40, 0xc8, 0x53, 0xa2, 0x3c,
  0xc6, 0x50, 0x23, 0x92, 0x3c, 0x04, 0xc9, 0x55, 0x25, 0xbf, 0xba, 0x50, 0x1e, 0xfe, 0x78, 0x2a,
  0x3e, 0x3b, 0xaf, 0xb5, 0x53, 0x64, 0xeb, 0x75, 0x9b, 0xed, 0x00, 0x3b, 0xbf, 0xbd, 0x5d, 0x9d,
  0x18, 0xa1, 0xe8, 0xa2, 0xbb, 0x30, 0x87, 0xd0, 0x9a, 0xbb, 0x9e, 0xb5, 0x26, 0xdf, 0x38, 0x96,
  0x77, 0xbe, 0x3f, 0xe4, 0x65, 0xd2, 0x18, 0x53, 0x10, 0xf9, 0xae, 0x73, 0x28, 0x00, 0x57, 0x78,
  0x4f, 0x05, 0x33, 0x17, 0xc6, 0x98, 0x42, 0x44, 0xba, 0x43, 0x43, 0x43, 0x85, 0x3d, 0x79, 0xf2,
  0xa4, 0x5e, 0xbc, 0x78, 0x51, 0x17, 0x35, 0xaf, 0xb5, 0x56, 0xcb, 0x52, 0xd4, 0x98, 0xa0, 0x80,
  0xd1, 0x94, 0x2a, 0x10, 0x89, 0x8a, 0x90, 0x12, 0x89, 0x02, 0xaa, 0xfb, 0xeb, 0x76, 0x7c, 0x5f,
  0x8d, 0xfe, 0x31, 0xc6, 0xe2, 0x5f, 0x26, 0xda, 0xdd, 0x83, 0xe3, 0xdd, 0xeb, 0x8f, 0xce, 0x74,
  0xb2, 0xe3, 0x25, 0xe7, 0x7b, 0x60, 0xb2, 0xdc, 0xf8, 0x3a, 0x5c, 0x56, 0x83, 0xf1, 0xeb, 0xfa,
  0x15, 0xc7, 0x3a, 0x46, 0x29, 0x45, 0x28, 0xba, 0x08, 0x45, 0x81, 0x50, 0x74, 0x54, 0x43, 0x31,
  0x6f, 0x3a, 0xb3, 0x97, 0x06, 0xa4, 0xf3, 0xe3, 0xa3, 0x59, 0xf9, 0xc1, 0x80, 0xc5, 0x24, 0xd5,
  0xb8, 0x70, 0x8e, 0x0b, 0x66, 0x56, 0x11, 0x56, 0x63, 0x02, 0x00, 0x07, 0xe6, 0xa4, 0x29, 0x91,
  0x8a, 0x88, 0x8a, 0x88, 0x1a, 0x63, 0x30, 0x36, 0x76, 0x5c, 0x09, 0x00, 0x5e, 0x7e, 0xf9, 0xe5,
  0xac, 0xd3, 0xe9, 0xe4, 0x29, 0xa5, 0x5c, 0x55, 0x6f, 0x5c, 0x21, 0x84, 0x1c, 0xc0, 0x62, 0x7a,
  0x26, 0xb2, 0xd8, 0xea, 0x31, 0x4f, 0x49, 0x33, 0xd5, 0x94, 0xa7, 0x94, 0x72, 0x11, 0xc9, 0x62,
  0x94, 0x5c, 0x55, 0xb3, 0x32, 0xc5, 0x81, 0xc9, 0x82, 0xf6, 0xb7, 0x02, 0xed, 0x29, 0x93, 0x69,
  0x54, 0xd6, 0x0d, 0x08, 0x67, 0x75, 0x31, 0x99, 0x87, 0xf5, 0x9e, 0x8c, 0x27, 0x30, 0xc8, 0x18,
  0xd7, 0x6b, 0xc1, 0xbe, 0x43, 0xeb, 0x1d, 0x78, 0x13, 0x10, 0x43, 0x48, 0x44, 0x48, 0x62, 0x49,
  0xa9, 0xe8, 0x1a, 0x09, 0x0b, 0x2e, 0x95, 0x33, 0xb9, 0xc6, 0xe9, 0x86, 0x4b, 0x63, 0xbb, 0x5c,
  0x1a, 0x35, 0x44, 0x5d, 0x63, 0xa8, 0x60, 0xe6, 0x92, 0xc8, 0x16, 0xd6, 0xf6, 0x5a, 0x94, 0xc8,
  0x96, 0xcc, 0x5a, 0x58, 0x6b, 0x0b, 0x6b, 0x6d, 0x01, 0xa0, 0xf0, 0xde, 0x17, 0x44, 0x54, 0x18,
  0x63, 0x0a, 0xe7, 0x5c, 0x31, 0x37, 0x37, 0x57, 0x34, 0x9b, 0xcd, 0xe2, 0xc6, 0xa8, 0xde, 0x6c,
  0x36, 0xfd, 0xf0, 0xf0, 0x70, 0x5e, 0x96, 0x65, 0x5e, 0x96, 0x9c, 0xa9, 0x76, 0x72, 0x66, 0xce,
  0x42, 0x08, 0x79, 0x4a, 0x29, 0x4b, 0x89, 0x72, 0xd5, 0x90, 0xa9, 0x6a, 0x16, 0x42, 0xca, 0x55,
  0x53, 0x96, 0x12, 0x32, 0x55, 0xf1, 0x22, 0x92, 0x89, 0x48, 0xa6, 0x9a, 0x7c, 0x4a, 0xea, 0x55,
  0x93, 0x57, 0x85, 0x13, 0x51, 0x27, 0x22, 0x0e, 0x10, 0xab, 0xaa, 0x56, 0x04, 0x46, 0x55, 0x19,
  0x10, 0x4e, 0x30, 0x36, 0x09, 0x19, 0x90, 0xaa, 0x82, 0x34, 0x33, 0x5a, 0x1a, 0x42, 0x00, 0x38,
  0x11, 0x21, 0x12, 0x71, 0x60, 0xe6, 0xc0, 0xcc, 0x15, 0x33, 0x02, 0x91, 0xa9, 0x98, 0xb9, 0x34,
  0x86, 0x2a, 0x66, 0x2e, 0x99, 0xb9, 0x02, 0x4c, 0x69, 0x0c, 0x4a, 0x66, 0x57, 0x58, 0x4b, 0x65,
  0xef, 0x41, 0x50, 0x09, 0xb8, 0xc2, 0x18, 0x29, 0xbd, 0xf7, 0x05, 0x33, 0x17, 0x29, 0xa5, 0xd2,
  0x18, 0x53, 0xd4, 0xeb, 0xf5, 0xe2, 0xc5, 0x17, 0x5f, 0x2c, 0x97, 0x4d, 0x67, 0xaa, 0x4a, 0xaf,
  0xbe, 0xfa, 0x6a, 0x36, 0x3b, 0x3b, 0x9b, 0x77, 0x3a, 0x9d, 0xcc, 0x18, 0x93, 0x85, 0x10, 0x32,
  0x66, 0xce, 0x52, 0x4a, 0x59, 0xaf, 0x65, 0xe1, 0x45, 0xaa, 0x2c, 0x25, 0xf2, 0xaa, 0x21, 0x13,
  0x11, 0xaf, 0xaa, 0x4e, 0x55, 0x7d, 0x4a, 0xea, 0x54, 0x93, 0x13, 0x81, 0x53, 0x4d, 0x4e, 0x55,
  0x6d, 0xff, 0x32, 0x22, 0x30, 0x80, 0xb0, 0x2a, 0x31, 0x91, 0x92, 0xaa, 0xf6, 0x7f, 0x35, 0x45,
  0xaa, 0x4a, 0x4a, 0xa4, 0x02, 0xb0, 0x30, 0x23, 0x11, 0x51, 0x22, 0xa2, 0x48, 0x44, 0x91, 0x99,
  0x23, 0x60, 0x82, 0x31, 0x08, 0x44, 0x14, 0x88, 0x6c, 0xd5, 0x7b, 0x18, 0x5a, 0x19, 0x63, 0x2a,
  0x55, 0x53, 0x79, 0xcf, 0xa5, 0xaa, 0x56, 0xc6, 0x98, 0x92, 0x99, 0x4b, 0x6b, 0x6d, 0x29, 0xe2,
  0x4b, 0xef, 0xa5, 0x4c, 0x29, 0x95, 0x65, 0x59, 0x96, 0x00, 0x8a, 0x66, 0xb3, 0x79, 0x63, 0xd1,
  0xf1, 0xb6, 0x72, 0xe3, 0xf4, 0xe9, 0xd3, 0xee, 0xe8, 0xd1, 0xa3, 0x79, 0x4a, 0x3b, 0xbc, 0x31,
  0xed, 0x45, 0x82, 0x5e, 0x55, 0x7d, 0x08, 0xc1, 0x03, 0xf0, 0x29, 0x25, 0x97, 0x52, 0xf2, 0x22,
  0xe2, 0x54, 0xd5, 0x11, 0x91, 0x4d, 0x09, 0x56, 0x35, 0x3a, 0x55, 0x36, 0x22, 0x62, 0x55, 0xd5,
  0x10, 0x81, 0x55, 0x93, 0x51, 0x25, 0xea, 0x93, 0xbf, 0xa5, 0x5e, 0x22, 0x55, 0x22, 0x52, 0x00,
  0xa2, 0xca, 0xd2, 0x27, 0x9e, 0x88, 0x28, 0x31, 0x6b, 0x34, 0xc6, 0x44, 0x55, 0x8d, 0x44, 0x2e,
  0x10, 0x51, 0x60, 0xe6, 0xd0, 0xeb, 0x11, 0x29, 0x38, 0xe7, 0x2a, 0x00, 0x15, 0x11, 0xdd, 0xf8,
  0x9f, 0xe7, 0x79, 0xe9, 0xbd, 0xaf, 0xa6, 0xa7, 0xa7, 0x8b, 0x66, 0xb3, 0x19, 0xb0, 0xc2, 0x91,
  0x88, 0x75, 0xe9, 0xac, 0x33, 0x67, 0xce, 0x98, 0x2b, 0x57, 0xae, 0x78, 0x22, 0xca, 0x62, 0x8c,
  0xbe, 0x2c, 0x4b, 0x67, 0x8c, 0x71, 0x31, 0x46, 0x07, 0xc0, 0xa6, 0x94, 0x1c, 0x7a, 0x2a, 0xd0,
  0xf6, 0x3f, 0x9b, 0x94, 0xc8, 0x32, 0x8b, 0x01, 0xc0, 0x31, 0x82, 0x89, 0x12, 0x03, 0x60, 0x11,
  0x26, 0x66, 0xb9, 0xa5, 0x5e, 0x11, 0x56, 0x66, 0x51, 0xc0, 0x08, 0x91, 0x28, 0x33, 0x27, 0x00,
  0xc2, 0xcc, 0x29, 0x25, 0x4e, 0xcc, 0x29, 0x01, 0x88, 0x80, 0x8b, 0xce, 0x21, 0x5a, 0x6b, 0x43,
  0x55, 0x21, 0x1a, 0x93, 0x82, 0xf7, 0x3e, 0x30, 0x73, 0x15, 0x63, 0x0c, 0xc3, 0xc3, 0xc3, 0xe5,
  0xd8, 0xd8, 0x58, 0xd5, 0x5c, 0x41, 0xa9, 0xdd, 0x11, 0xf1, 0xa5, 0x50, 0x55, 0x3a, 0x7b, 0xf6,
  0xac, 0x79, 0xe7, 0x9d, 0x77, 0x5c, 0x55, 0x55, 0xbe, 0xdf, 0xb2, 0xd6, 0x5a, 0x6b, 0x54, 0xd5,
  0x86, 0x10, 0x0c, 0x00, 0x36, 0xbd, 0x49, 0x94, 0xab, 0x0a, 0x0c, 0x54, 0xcc, 0xcc, 0x24, 0x22,
  0xe4, 0x9c, 0x43, 0x4a, 0xe9, 0x46, 0xdd, 0x22, 0xa2, 0xbd, 0xd1, 0x58, 0xd4, 0x7b, 0x2f, 0xe8,
  0x9d, 0x31, 0x13, 0x22, 0x92, 0x18, 0x63, 0x72, 0xce, 0xa5, 0x18, 0x63, 0x22, 0xa2, 0x98, 0x65,
  0x59, 0x6a, 0xb5, 0x4c, 0x04, 0xe6, 0xaa, 0x03, 0x07, 0x0e, 0x84, 0xd3, 0xa7, 0x4f, 0xc7, 0x7e,
  0x6f, 0xd9, 0x10, 0xb6, 0x44, 0x59, 0x37, 0x9b, 0x4d, 0x3e, 0x79, 0xf2, 0x24, 0x7d, 0xf8, 0xe1,
  0x87, 0x06, 0x3d, 0x23, 0xc4, 0x3b, 0x76, 0xec, 0x20, 0x11, 0xe1, 0x6e, 0xb7, 0x4b, 0xc3, 0xc3,
  0xc3, 0x98, 0x9e, 0x4e, 0x0c, 0x00, 0xc3, 0xc3, 0x46, 0xa6, 0xa7, 0xa7, 0x51, 0xab, 0xd5, 0x94,
  0x99, 0xa5, 0xdd, 0x6e, 0x2b, 0xfa, 0xc4, 0x17, 0xaf, 0x9b, 0xdf, 0xcd, 0xcd, 0xc2, 0xff, 0x02,
  0xd8, 0xfd, 0x75, 0xe1, 0x77, 0xe3, 0x0f, 0x58, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
  0xae, 0x42, 0x60, 0x82,
};

std::uint32_t EXTENSION_ICON_DATA_SIZE = sizeof (EXTENSION_ICON_DATA);
} // extern "C"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Start extension
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
extern "C" void
start ()
{
  mobius::imagefile::add_implementation <mobius::talon::imagefile_impl> ();
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Stop extension
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
extern "C" void
stop ()
{
  mobius::imagefile::remove_implementation <mobius::talon::imagefile_impl> ();
}
