// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.model module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "module.h"
#include <pymobius.h>
#include "ant.h"
#include "application.h"
#include "bookmarked_url.h"
#include "call.h"
#include "case.h"
#include "case_manager.h"
#include "chat_message.h"
#include "cookie.h"
#include "encryption_key.h"
#include "item.h"
#include "opened_file.h"
#include "password.h"
#include "password_hash.h"
#include "profile.h"
#include "text_autocomplete.h"
#include "text_search.h"
#include "trash_can_entry.h"
#include "visited_url.h"

namespace
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Module definition structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyModuleDef module_def =
{
  PyModuleDef_HEAD_INIT,
  "mobius.model",
  "Mobius Forensic Toolkit mobius.model module",
  -1,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr
};

} // namespace

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Create module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
mobius::py::pymodule
new_model_module ()
{
  // Initialize module
  mobius::py::pymodule module (&module_def);

  // Add types
  module.add_type ("ant", &model_ant_t);
  module.add_type ("application", &model_application_t);
  module.add_type ("bookmarked_url", &model_bookmarked_url_t);
  module.add_type ("call", &model_call_t);
  module.add_type ("case", &model_case_t);
  module.add_type ("case_manager", &model_case_manager_t);
  module.add_type ("chat_message", &model_chat_message_t);
  module.add_type ("cookie", &model_cookie_t);
  module.add_type ("encryption_key", &model_encryption_key_t);
  module.add_type ("item", &model_item_t);
  module.add_type ("opened_file", &model_opened_file_t);
  module.add_type ("password", &model_password_t);
  module.add_type ("password_hash", &model_password_hash_t);
  module.add_type ("profile", &model_profile_t);
  module.add_type ("text_autocomplete", &model_text_autocomplete_t);
  module.add_type ("text_search", &model_text_search_t);
  module.add_type ("trash_can_entry", &model_trash_can_entry_t);
  module.add_type ("visited_url", &model_visited_url_t);

  // Return module
  return module;
}
