// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API mobius.ui module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "module.h"
#include <pymobius.h>
#include "ui.h"
#include "message_dialog.h"
#include <map>
#include <string>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Function prototypes
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject* func_set_implementation (PyObject *, PyObject *);

namespace
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    "set_implementation",
    func_set_implementation,
    METH_VARARGS,
    "Set UI implementation"
  },
  {
    nullptr,
    nullptr,
    0,
    nullptr
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Module definition structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyModuleDef module_def =
{
  PyModuleDef_HEAD_INIT,
  "mobius.ui",
  "Mobius Forensic Toolkit mobius.ui module",
  -1,
  module_methods,
  nullptr,
  nullptr,
  nullptr,
  nullptr
};

} // namespace

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Create mobius.ui module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
mobius::py::pymodule
new_ui_module ()
{
  // Initialize module
  mobius::py::pymodule module (&module_def);

  // Add types
  module.add_type ("ui", &ui_ui_t);
  module.add_type ("message_dialog", &ui_message_dialog_t);

  // Add constants
  module.add_constant ("MESSAGE_DIALOG_TYPE_INFO", 1);
  module.add_constant ("MESSAGE_DIALOG_TYPE_WARNING", 2);
  module.add_constant ("MESSAGE_DIALOG_TYPE_QUESTION", 3);
  module.add_constant ("MESSAGE_DIALOG_TYPE_ERROR", 4);
  module.add_constant ("BUTTON_OK", 1);
  module.add_constant ("BUTTON_CANCEL", 2);
  module.add_constant ("BUTTON_YES", 3);
  module.add_constant ("BUTTON_NO", 4);
  module.add_constant ("BUTTON_OPEN", 5);
  module.add_constant ("BUTTON_SAVE", 6);
  module.add_constant ("BUTTON_CLOSE", 7);
  module.add_constant ("BUTTON_DISCARD", 8);
  module.add_constant ("BUTTON_APPLY", 9);
  module.add_constant ("BUTTON_RESET", 10);
  module.add_constant ("BUTTON_RESTORE_DEFAULTS", 11);
  module.add_constant ("BUTTON_HELP", 12);
  module.add_constant ("BUTTON_SAVE_ALL", 13);
  module.add_constant ("BUTTON_YES_TO_ALL", 14);
  module.add_constant ("BUTTON_NO_TO_ALL", 15);
  module.add_constant ("BUTTON_ABORT", 16);
  module.add_constant ("BUTTON_RETRY", 17);
  module.add_constant ("BUTTON_IGNORE", 18);

  // Return module
  return module;
}
