// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/partition/partition_system.h>
#include <mobius/partition/partition_system_impl_apm.h>
#include <mobius/partition/partition_system_impl_dos.h>
#include <mobius/partition/partition_system_impl_gpt.h>
#include <mobius/partition/partition_system_impl_null.h>
#include <mobius/exception.inc>
#include <stdexcept>

namespace mobius
{
namespace partition
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief constructor
//! \param reader stream reader
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
partition_system::partition_system (const mobius::disk::disk disk)
{
  // check sector size
  if (disk.get_sector_size () == 0)
    throw std::runtime_error (
      MOBIUS_EXCEPTION_MSG ("disk.sector_size must be greater than zero")
    );

  // check partition system
  if (partition_system_impl_gpt::is_instance (disk))
    impl_ = std::make_shared <partition_system_impl_gpt> (disk);

  else if (partition_system_impl_dos::is_instance (disk))
    impl_ = std::make_shared <partition_system_impl_dos> (disk);

  else if (partition_system_impl_apm::is_instance (disk))
    impl_ = std::make_shared <partition_system_impl_apm> (disk);

  else
    impl_ = std::make_shared <partition_system_impl_null> (disk);
}

} // namespace partition
} // namespace mobius
