#ifndef MOBIUS_CRYPT_CIPHER_BLOWFISH_H
#define MOBIUS_CRYPT_CIPHER_BLOWFISH_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block.h>
#include <mobius/bytearray.h>
#include <cstdint>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Blowfish cipher cryptographic algorithm
//! \author Eduardo Aguiar
//! \see https://www.schneier.com/academic/blowfish/
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_blowfish : public cipher_block
{
public:
  explicit cipher_blowfish (const mobius::bytearray&, const std::string& = "ecb", const mobius::bytearray& = {0, 0, 0, 0, 0, 0, 0, 0});

  void encrypt_block (mobius::bytearray& b) noexcept override;
  void decrypt_block (mobius::bytearray& b) noexcept override;

private:
  std::uint32_t p_[18];
  std::uint32_t s_[4][256];

  // helper functions
  void _encrypt_block (std::uint32_t&, std::uint32_t&) noexcept;
  void _decrypt_block (std::uint32_t&, std::uint32_t&) noexcept;
};

} // namespace crypt
} // namespace mobius

#endif
