// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "hash.h"
#include "hash_adler32.h"
#include "hash_crc32.h"
#include "hash_ed2k.h"
#include "hash_md4.h"
#include "hash_md5.h"
#include "hash_sha1.h"
#include "hash_sha2_224.h"
#include "hash_sha2_256.h"
#include "hash_sha2_384.h"
#include "hash_sha2_512.h"
#include "hash_sha2_512_224.h"
#include "hash_sha2_512_256.h"
#include "hash_zip.h"
#include <mobius/exception.inc>
#include <stdexcept>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Assign from another hash
//! \param h hash object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
hash::_assign (const hash& h)
{
  hash_id_ = h.hash_id_;

  if (hash_id_ == "adler32")
    pimpl_ = std::make_unique <hash_adler32> (static_cast <hash_adler32&> (*h.pimpl_));

  else if (hash_id_ == "crc32")
    pimpl_ = std::make_unique <hash_crc32> (static_cast <hash_crc32&> (*h.pimpl_));

  else if (hash_id_ == "ed2k")
    pimpl_ = std::make_unique <hash_ed2k> (static_cast <hash_ed2k&> (*h.pimpl_));

  else if (hash_id_ == "md4")
    pimpl_ = std::make_unique <hash_md4> (static_cast <hash_md4&> (*h.pimpl_));

  else if (hash_id_ == "md5")
    pimpl_ = std::make_unique <hash_md5> (static_cast <hash_md5&> (*h.pimpl_));

  else if (hash_id_ == "sha1")
    pimpl_ = std::make_unique <hash_sha1> (static_cast <hash_sha1&> (*h.pimpl_));

  else if (hash_id_ == "sha2_224")
    pimpl_ = std::make_unique <hash_sha2_224> (static_cast <hash_sha2_224&> (*h.pimpl_));

  else if (hash_id_ == "sha2_256")
    pimpl_ = std::make_unique <hash_sha2_256> (static_cast <hash_sha2_256&> (*h.pimpl_));

  else if (hash_id_ == "sha2_384")
    pimpl_ = std::make_unique <hash_sha2_384> (static_cast <hash_sha2_384&> (*h.pimpl_));

  else if (hash_id_ == "sha2_512")
    pimpl_ = std::make_unique <hash_sha2_512> (static_cast <hash_sha2_512&> (*h.pimpl_));

  else if (hash_id_ == "sha2_512_224")
    pimpl_ = std::make_unique <hash_sha2_512_224> (static_cast <hash_sha2_512_224&> (*h.pimpl_));

  else if (hash_id_ == "sha2_512_256")
    pimpl_ = std::make_unique <hash_sha2_512_256> (static_cast <hash_sha2_512_256&> (*h.pimpl_));

  else if (hash_id_ == "zip")
    pimpl_ = std::make_unique <hash_zip> (static_cast <hash_zip&> (*h.pimpl_));

  else
    throw std::invalid_argument (MOBIUS_EXCEPTION_MSG ("Invalid hash ID"));
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Initialize object
//! \param hash_id hash class ID (md5, sha1, ...)
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
hash::hash (const std::string& hash_id)
  : hash_id_ (hash_id)
{
  if (hash_id_ == "adler32")
    pimpl_ = std::make_unique <hash_adler32> ();

  else if (hash_id_ == "crc32")
    pimpl_ = std::make_unique <hash_crc32> ();

  else if (hash_id_ == "ed2k")
    pimpl_ = std::make_unique <hash_ed2k> ();

  else if (hash_id_ == "md4")
    pimpl_ = std::make_unique <hash_md4> ();

  else if (hash_id_ == "md5")
    pimpl_ = std::make_unique <hash_md5> ();

  else if (hash_id_ == "sha1")
    pimpl_ = std::make_unique <hash_sha1> ();

  else if (hash_id_ == "sha2_224")
    pimpl_ = std::make_unique <hash_sha2_224> ();

  else if (hash_id_ == "sha2_256")
    pimpl_ = std::make_unique <hash_sha2_256> ();

  else if (hash_id_ == "sha2_384")
    pimpl_ = std::make_unique <hash_sha2_384> ();

  else if (hash_id_ == "sha2_512")
    pimpl_ = std::make_unique <hash_sha2_512> ();

  else if (hash_id_ == "sha2_512_224")
    pimpl_ = std::make_unique <hash_sha2_512_224> ();

  else if (hash_id_ == "sha2_512_256")
    pimpl_ = std::make_unique <hash_sha2_512_256> ();

  else if (hash_id_ == "zip")
    pimpl_ = std::make_unique <hash_zip> ();

  else
    throw std::invalid_argument (MOBIUS_EXCEPTION_MSG ("Invalid hash ID"));
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Copy constructor
//! \param hash_id hash class ID (md5, sha1, ...)
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
hash::hash (const hash& h)
{
  _assign (h);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Copy constructor
//! \param hash_id hash class ID (md5, sha1, ...)
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
hash&
hash::operator= (const hash& h)
{
  _assign (h);

  return *this;
}

} // namespace crypt
} // namespace mobius

