/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file round_modes.cpp
 * @date 2007-04-03
 * Example of using different round modes with MPFRCPP library.
 */

#include "../misc/copyleft.hpp" // internal::copyleft();
#include <iostream>
#include <mpfrcpp/mpfrcpp.hpp>

using namespace std;
using namespace mpfrcpp;

int main () {
    internal::copyleft();
    Library.setPrecision( Precision( 20 ) );
    cout.precision( 0 );

    cout << "Example of calculating acos(0.5) with precision "
    << Library.getPrecision().getMpfrPrecT ()
    << " and different round modes" << endl;

    cout << endl;

    //------------------------------------------------------------

    // 1. We can construct our own functors:

    AcosClass AcosMInf ( roundTowardNegInfinity );
    AcosClass AcosPInf ( roundTowardInfinity );

    cout << roundTowardNegInfinity.toString() << " :" << endl;
    cout << "\t" << AcosMInf( Real( "0.5" ) ) << endl;

    cout << roundTowardInfinity.toString() << " :" << endl;
    cout << "\t" << AcosPInf( Real( "0.5" ) ) << endl;

    cout << endl;

    //------------------------------------------------------------

    // 2. We can specify round mode via functor parameters:

    cout << roundTowardNegInfinity.toString() << ":" << endl;
    cout << "\t" << Acos ( Real( "0.5" ), roundTowardNegInfinity ) << endl;

    cout << roundTowardInfinity.toString() << ":" << endl;
    cout << "\t" << Acos ( Real( "0.5" ), roundTowardInfinity ) << endl;

    cout << endl;

    //------------------------------------------------------------

    // 3. <mpfrcpp/extra/pminf.hpp> defines functors rounding to
    // +/- infinity

    //------------------------------------------------------------

    return 0;
}
