/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file pminf.hpp
 * @date 2007-04-03
 * Functors rounding to +/- infinity.
 * OPTIONAL HEADER, INCLUDE ONLY IF NEEDED.
 */

#ifndef MPFRCPP_EXTRA_PMINF
#define MPFRCPP_EXTRA_PMINF

#include <mpfrcpp/mpfrcpp.hpp>

namespace mpfrcpp {

    //------------------------------------------------------------

    extern AbsClass AbsMInf;
    extern AbsClass AbsPInf;
    AbsClass AbsMInf = AbsClass ( roundTowardNegInfinity );
    AbsClass AbsPInf = AbsClass ( roundTowardInfinity );

    extern AcosClass AcosMInf;
    extern AcosClass AcosPInf;
    AcosClass AcosMInf = AcosClass ( roundTowardNegInfinity );
    AcosClass AcosPInf = AcosClass ( roundTowardInfinity );

    extern AcoshClass AcoshMInf;
    extern AcoshClass AcoshPInf;
    AcoshClass AcoshMInf = AcoshClass ( roundTowardNegInfinity );
    AcoshClass AcoshPInf = AcoshClass ( roundTowardInfinity );

    extern AgmClass AgmMInf;
    extern AgmClass AgmPInf;
    AgmClass AgmMInf = AgmClass ( roundTowardNegInfinity );
    AgmClass AgmPInf = AgmClass ( roundTowardInfinity );

    extern AsinhClass AsinhMInf;
    extern AsinhClass AsinhPInf;
    AsinhClass AsinhMInf = AsinhClass ( roundTowardNegInfinity );
    AsinhClass AsinhPInf = AsinhClass ( roundTowardInfinity );

    extern AtanClass AtanMInf;
    extern AtanClass AtanPInf;
    AtanClass AtanMInf = AtanClass ( roundTowardNegInfinity );
    AtanClass AtanPInf = AtanClass ( roundTowardInfinity );

    extern AtanhClass AtanhMInf;
    extern AtanhClass AtanhPInf;
    AtanhClass AtanhMInf = AtanhClass ( roundTowardNegInfinity );
    AtanhClass AtanhPInf = AtanhClass ( roundTowardInfinity );

    extern CbrtClass CbrtMInf;
    extern CbrtClass CbrtPInf;
    CbrtClass CbrtMInf = CbrtClass ( roundTowardNegInfinity );
    CbrtClass CbrtPInf = CbrtClass ( roundTowardInfinity );

    extern ConstantClass ConstantMInf;
    extern ConstantClass ConstantPInf;
    ConstantClass ConstantMInf = ConstantClass ( roundTowardNegInfinity );
    ConstantClass ConstantPInf = ConstantClass ( roundTowardInfinity );

    extern CosClass CosMInf;
    extern CosClass CosPInf;
    CosClass CosMInf = CosClass ( roundTowardNegInfinity );
    CosClass CosPInf = CosClass ( roundTowardInfinity );

    extern CoshClass CoshMInf;
    extern CoshClass CoshPInf;
    CoshClass CoshMInf = CoshClass ( roundTowardNegInfinity );
    CoshClass CoshPInf = CoshClass ( roundTowardInfinity );

    extern CotClass CotMInf;
    extern CotClass CotPInf;
    CotClass CotMInf = CotClass ( roundTowardNegInfinity );
    CotClass CotPInf = CotClass ( roundTowardInfinity );

    extern CothClass CothMInf;
    extern CothClass CothPInf;
    CothClass CothMInf = CothClass ( roundTowardNegInfinity );
    CothClass CothPInf = CothClass ( roundTowardInfinity );

    extern CscClass CscMInf;
    extern CscClass CscPInf;
    CscClass CscMInf = CscClass ( roundTowardNegInfinity );
    CscClass CscPInf = CscClass ( roundTowardInfinity );

    extern CschClass CschMInf;
    extern CschClass CschPInf;
    CschClass CschMInf = CschClass ( roundTowardNegInfinity );
    CschClass CschPInf = CschClass ( roundTowardInfinity );

    extern DivClass DivMInf;
    extern DivClass DivPInf;
    DivClass DivMInf = DivClass ( roundTowardNegInfinity );
    DivClass DivPInf = DivClass ( roundTowardInfinity );

    extern EintClass EintMInf;
    extern EintClass EintPInf;
    EintClass EintMInf = EintClass ( roundTowardNegInfinity );
    EintClass EintPInf = EintClass ( roundTowardInfinity );

    extern ErfClass ErfMInf;
    extern ErfClass ErfPInf;
    ErfClass ErfMInf = ErfClass ( roundTowardNegInfinity );
    ErfClass ErfPInf = ErfClass ( roundTowardInfinity );

    extern ErfcClass ErfcMInf;
    extern ErfcClass ErfcPInf;
    ErfcClass ErfcMInf = ErfcClass ( roundTowardNegInfinity );
    ErfcClass ErfcPInf = ErfcClass ( roundTowardInfinity );

    extern ExpClass ExpMInf;
    extern ExpClass ExpPInf;
    ExpClass ExpMInf = ExpClass ( roundTowardNegInfinity );
    ExpClass ExpPInf = ExpClass ( roundTowardInfinity );

    extern Exp10Class Exp10MInf;
    extern Exp10Class Exp10PInf;
    Exp10Class Exp10MInf = Exp10Class ( roundTowardNegInfinity );
    Exp10Class Exp10PInf = Exp10Class ( roundTowardInfinity );

    extern Exp2Class Exp2MInf;
    extern Exp2Class Exp2PInf;
    Exp2Class Exp2MInf = Exp2Class ( roundTowardNegInfinity );
    Exp2Class Exp2PInf = Exp2Class ( roundTowardInfinity );

    extern Expm1Class Expm1MInf;
    extern Expm1Class Expm1PInf;
    Expm1Class Expm1MInf = Expm1Class ( roundTowardNegInfinity );
    Expm1Class Expm1PInf = Expm1Class ( roundTowardInfinity );

    extern FactorialClass FactorialMInf;
    extern FactorialClass FactorialPInf;
    FactorialClass FactorialMInf = FactorialClass ( roundTowardNegInfinity );
    FactorialClass FactorialPInf = FactorialClass ( roundTowardInfinity );

    extern FmaClass FmaMInf;
    extern FmaClass FmaPInf;
    FmaClass FmaMInf = FmaClass ( roundTowardNegInfinity );
    FmaClass FmaPInf = FmaClass ( roundTowardInfinity );

    extern FracClass FracMInf;
    extern FracClass FracPInf;
    FracClass FracMInf = FracClass ( roundTowardNegInfinity );
    FracClass FracPInf = FracClass ( roundTowardInfinity );

    extern GammaClass GammaMInf;
    extern GammaClass GammaPInf;
    GammaClass GammaMInf = GammaClass ( roundTowardNegInfinity );
    GammaClass GammaPInf = GammaClass ( roundTowardInfinity );

    extern HypotClass HypotMInf;
    extern HypotClass HypotPInf;
    HypotClass HypotMInf = HypotClass ( roundTowardNegInfinity );
    HypotClass HypotPInf = HypotClass ( roundTowardInfinity );

    extern LngammaClass LngammaMInf;
    extern LngammaClass LngammaPInf;
    LngammaClass LngammaMInf = LngammaClass ( roundTowardNegInfinity );
    LngammaClass LngammaPInf = LngammaClass ( roundTowardInfinity );

    extern LogClass LogMInf;
    extern LogClass LogPInf;
    LogClass LogMInf = LogClass ( roundTowardNegInfinity );
    LogClass LogPInf = LogClass ( roundTowardInfinity );

    extern Log10Class Log10MInf;
    extern Log10Class Log10PInf;
    Log10Class Log10MInf = Log10Class ( roundTowardNegInfinity );
    Log10Class Log10PInf = Log10Class ( roundTowardInfinity );

    extern Log1pClass Log1pMInf;
    extern Log1pClass Log1pPInf;
    Log1pClass Log1pMInf = Log1pClass ( roundTowardNegInfinity );
    Log1pClass Log1pPInf = Log1pClass ( roundTowardInfinity );

    extern Log2Class Log2MInf;
    extern Log2Class Log2PInf;
    Log2Class Log2MInf = Log2Class ( roundTowardNegInfinity );
    Log2Class Log2PInf = Log2Class ( roundTowardInfinity );

    extern MulClass MulMInf;
    extern MulClass MulPInf;
    MulClass MulMInf = MulClass ( roundTowardNegInfinity );
    MulClass MulPInf = MulClass ( roundTowardInfinity );

    extern NegClass NegMInf;
    extern NegClass NegPInf;
    NegClass NegMInf = NegClass ( roundTowardNegInfinity );
    NegClass NegPInf = NegClass ( roundTowardInfinity );

    extern PowClass PowMInf;
    extern PowClass PowPInf;
    PowClass PowMInf = PowClass ( roundTowardNegInfinity );
    PowClass PowPInf = PowClass ( roundTowardInfinity );

    extern RootClass RootMInf;
    extern RootClass RootPInf;
    RootClass RootMInf = RootClass ( roundTowardNegInfinity );
    RootClass RootPInf = RootClass ( roundTowardInfinity );

    extern SecClass SecMInf;
    extern SecClass SecPInf;
    SecClass SecMInf = SecClass ( roundTowardNegInfinity );
    SecClass SecPInf = SecClass ( roundTowardInfinity );

    extern SechClass SechMInf;
    extern SechClass SechPInf;
    SechClass SechMInf = SechClass ( roundTowardNegInfinity );
    SechClass SechPInf = SechClass ( roundTowardInfinity );

    extern SinClass SinMInf;
    extern SinClass SinPInf;
    SinClass SinMInf = SinClass ( roundTowardNegInfinity );
    SinClass SinPInf = SinClass ( roundTowardInfinity );

    extern SinCosClass SinCosMInf;
    extern SinCosClass SinCosPInf;
    SinCosClass SinCosMInf = SinCosClass ( roundTowardNegInfinity );
    SinCosClass SinCosPInf = SinCosClass ( roundTowardInfinity );

    extern SinhClass SinhMInf;
    extern SinhClass SinhPInf;
    SinhClass SinhMInf = SinhClass ( roundTowardNegInfinity );
    SinhClass SinhPInf = SinhClass ( roundTowardInfinity );

    extern SqrClass SqrMInf;
    extern SqrClass SqrPInf;
    SqrClass SqrMInf = SqrClass ( roundTowardNegInfinity );
    SqrClass SqrPInf = SqrClass ( roundTowardInfinity );

    extern SqrtClass SqrtMInf;
    extern SqrtClass SqrtPInf;
    SqrtClass SqrtMInf = SqrtClass ( roundTowardNegInfinity );
    SqrtClass SqrtPInf = SqrtClass ( roundTowardInfinity );

    extern SubClass SubMInf;
    extern SubClass SubPInf;
    SubClass SubMInf = SubClass ( roundTowardNegInfinity );
    SubClass SubPInf = SubClass ( roundTowardInfinity );

    extern TanClass TanMInf;
    extern TanClass TanPInf;
    TanClass TanMInf = TanClass ( roundTowardNegInfinity );
    TanClass TanPInf = TanClass ( roundTowardInfinity );

    extern TanhClass TanhMInf;
    extern TanhClass TanhPInf;
    TanhClass TanhMInf = TanhClass ( roundTowardNegInfinity );
    TanhClass TanhPInf = TanhClass ( roundTowardInfinity );

    extern ZetaClass ZetaMInf;
    extern ZetaClass ZetaPInf;
    ZetaClass ZetaMInf = ZetaClass ( roundTowardNegInfinity );
    ZetaClass ZetaPInf = ZetaClass ( roundTowardInfinity );

    //------------------------------------------------------------

    class ExtraNumericFunctions : public NumericFunctions {
        public:
            ExtraNumericFunctions () throw() {
                insert ( AbsMInf );
                insert ( AbsPInf );
                insert ( AcosMInf );
                insert ( AcosPInf );
                insert ( AcoshMInf );
                insert ( AcoshPInf );
                insert ( AgmMInf );
                insert ( AgmPInf );
                insert ( AsinhMInf );
                insert ( AsinhPInf );
                insert ( AtanMInf );
                insert ( AtanPInf );
                insert ( AtanhMInf );
                insert ( AtanhPInf );
                insert ( CbrtMInf );
                insert ( CbrtPInf );
                insert ( ConstantMInf );
                insert ( ConstantPInf );
                insert ( CosMInf );
                insert ( CosPInf );
                insert ( CoshMInf );
                insert ( CoshPInf );
                insert ( CotMInf );
                insert ( CotPInf );
                insert ( CothMInf );
                insert ( CothPInf );
                insert ( CscMInf );
                insert ( CscPInf );
                insert ( CschMInf );
                insert ( CschPInf );
                insert ( DivMInf );
                insert ( DivPInf );
                insert ( EintMInf );
                insert ( EintPInf );
                insert ( ErfMInf );
                insert ( ErfPInf );
                insert ( ErfcMInf );
                insert ( ErfcPInf );
                insert ( ExpMInf );
                insert ( ExpPInf );
                insert ( Exp10MInf );
                insert ( Exp10PInf );
                insert ( Exp2MInf );
                insert ( Exp2PInf );
                insert ( Expm1MInf );
                insert ( Expm1PInf );
                insert ( FactorialMInf );
                insert ( FactorialPInf );
                insert ( FmaMInf );
                insert ( FmaPInf );
                insert ( FracMInf );
                insert ( FracPInf );
                insert ( GammaMInf );
                insert ( GammaPInf );
                insert ( HypotMInf );
                insert ( HypotPInf );
                insert ( LngammaMInf );
                insert ( LngammaPInf );
                insert ( LogMInf );
                insert ( LogPInf );
                insert ( Log10MInf );
                insert ( Log10PInf );
                insert ( Log1pMInf );
                insert ( Log1pPInf );
                insert ( Log2MInf );
                insert ( Log2PInf );
                insert ( MulMInf );
                insert ( MulPInf );
                insert ( NegMInf );
                insert ( NegPInf );
                insert ( PowMInf );
                insert ( PowPInf );
                insert ( RootMInf );
                insert ( RootPInf );
                insert ( SecMInf );
                insert ( SecPInf );
                insert ( SechMInf );
                insert ( SechPInf );
                insert ( SinMInf );
                insert ( SinPInf );
                insert ( SinCosMInf );
                insert ( SinCosPInf );
                insert ( SinhMInf );
                insert ( SinhPInf );
                insert ( SqrMInf );
                insert ( SqrPInf );
                insert ( SqrtMInf );
                insert ( SqrtPInf );
                insert ( SubMInf );
                insert ( SubPInf );
                insert ( TanMInf );
                insert ( TanPInf );
                insert ( TanhMInf );
                insert ( TanhPInf );
                insert ( ZetaMInf );
                insert ( ZetaPInf );
            }
    };

    extern ExtraNumericFunctions ExtraFunctions;
    ExtraNumericFunctions ExtraFunctions = ExtraNumericFunctions ();

    //------------------------------------------------------------

}    // namespace mpfrcpp

#endif    // MPFRCPP_EXTRA_PMINF
