<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="main/css" href="main.css"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xhtml="http://www.w3.org/1999/xhtml">

<xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <link rel="stylesheet" type="text/css" href="main.css" />
            <link href="favicon.ico" rel="shortcut icon" media="all" />
            <title><xsl:if test="/xhtml:html/@id != 'index'">MPFRCPP </xsl:if><xsl:value-of select="/xhtml:html/xhtml:head/xhtml:title"/></title>
        </head>
        <body>
            <h1><xsl:if test="/xhtml:html/@id != 'index'"><acronym title="The Multiple Precision Floating-Point Reliable Library C++ Interface"><a href="index.html">MPFRCPP</a></acronym><xsl:text> </xsl:text></xsl:if><xsl:value-of select="/xhtml:html/xhtml:head/xhtml:title"/></h1>

            <div class="body">
                <p class="nav"><xsl:choose><xsl:when test="/xhtml:html/@id = 'copying'"><span class="active">Copying</span></xsl:when><xsl:otherwise><a href="copying.html">Copying</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'installation'"><span class="active">Installation</span></xsl:when><xsl:otherwise><a href="installation.html">Installation</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'interface'"><span class="active">Interface</span></xsl:when><xsl:otherwise><a href="interface.html">Interface</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'extra'"><span class="active">Extra Modules</span></xsl:when><xsl:otherwise><a href="extra.html">Extra Modules</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'faq'"><span class="active"><acronym title="Frequently Asked Questions">FAQ</acronym></span></xsl:when><xsl:otherwise><a href="faq.html"><acronym title="Frequently Asked Questions">FAQ</acronym></a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'nacre'"><span class="active"><acronym title="Numeric Analysis / Computer Research">NACRE</acronym></span></xsl:when><xsl:otherwise><a href="nacre.html"><acronym title="Numeric Analysis / Computer Research">NACRE</acronym></a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'tests'"><span class="active">Tests</span></xsl:when><xsl:otherwise><a href="tests.html">Tests</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'bugs'"><span class="active">Bugs</span></xsl:when><xsl:otherwise><a href="bugs.html">Bugs</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'tasks'"><span class="active">Tasks</span></xsl:when><xsl:otherwise><a href="tasks.html">Tasks</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'authors'"><span class="active">Authors</span></xsl:when><xsl:otherwise><a href="authors.html">Authors</a></xsl:otherwise></xsl:choose><xsl:text> </xsl:text><xsl:choose><xsl:when test="/xhtml:html/@id = 'references'"><span class="active">References</span></xsl:when><xsl:otherwise><a href="references.html">References</a></xsl:otherwise></xsl:choose></p>

                <xsl:for-each select="/xhtml:html/xhtml:body/*">
                    <xsl:copy-of select="."/>
                </xsl:for-each>

                <div class="footer">
                    <p>Last modified 2007-07-04.</p>
                    <p>© 2006–2007 <a href="http://beshenov.ru/">Alexey&#x00a0;V.&#x00a0;Beshenov</a>&#x00a0;&lt;<a href="mailto:al@beshenov.ru">al@beshenov.ru</a>&gt;.</p>
                    <p>Permission is granted to copy, distribute and / or modify this document under the terms of the <a href="http://www.gnu.org/licenses/fdl.html">GNU Free Documentation License</a>, Version 1.2 or any later version published by the Free Software Foundation; with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.</p>
                </div>
            </div>
        </body>
    </html>
</xsl:template>
</xsl:stylesheet>