/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import java.util.Random;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.rewire.AbstractRewire;
import org.nongnu.multigraph.rewire.EdgeLabeler;

public class RandomRewire<N, L>
extends AbstractRewire<N, L> {
    Random r = new Random();
    int mindegree = 1;

    public RandomRewire(Graph<N, L> graph, EdgeLabeler<N, L> edgeLabeler) {
        super(graph, edgeLabeler);
    }

    public RandomRewire(Graph<N, L> graph, EdgeLabeler<N, L> edgeLabeler, int n) {
        super(graph, edgeLabeler);
        this.mindegree = n;
    }

    private void rewire_one(N n, int n2, N[] NArray) {
        while (this.graph.nodal_outdegree(n) < n2) {
            N n3;
            while ((n3 = NArray[this.r.nextInt(NArray.length)]) == n) {
            }
            try {
                Object l = this.el.getLabel(n, n3);
                if (l == null) continue;
                this.graph.set(n, n3, l);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public RandomRewire<N, L> set_mindegree(int n) {
        this.mindegree = n;
        return this;
    }

    @Override
    public void rewire() {
        if (this.mindegree > this.graph.size() - 1) {
            throw new IllegalArgumentException("mindegree too high for size of graph");
        }
        Object[] objectArray = this.graph.toArray(new Object[0]);
        RandomRewire.clear(this.graph);
        for (Object object : objectArray) {
            this.rewire_one(object, this.mindegree, objectArray);
        }
    }
}

