/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import se.kth.netzack.Direction;
import se.kth.netzack.Message;
import se.kth.netzack.Netzack;
import se.kth.netzack.PacketBuffer;
import se.kth.netzack.Peer;
import se.kth.netzack.Server;

public class Packet {
    private Peer from;
    private Message msg;
    private PacketBuffer pbuf = Server.getPacketBuffer();

    Packet() {
    }

    Packet(Peer peer, Message message, Object[] objectArray) {
        this();
        this.from = peer;
        this.msg = message;
        this.pbuf.buffer.putChar(message.get());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (object2 instanceof Integer) {
                this.pbuf.buffer.putInt((Integer)object2);
                continue;
            }
            if (object2 instanceof Double) {
                this.pbuf.buffer.putDouble((Double)object2);
                continue;
            }
            if (object2 instanceof String) {
                object = ((String)object2).toCharArray();
                for (int j = 0; j < ((char[])object).length; ++j) {
                    this.pbuf.buffer.putChar(object[j]);
                }
                continue;
            }
            if (object2 instanceof Direction) {
                this.pbuf.buffer.putInt(((Direction)object2).get());
                continue;
            }
            if (object2 instanceof Boolean) {
                if (((Boolean)object2).booleanValue()) {
                    this.pbuf.buffer.put((byte)1);
                    continue;
                }
                this.pbuf.buffer.put((byte)0);
                continue;
            }
            if (object2 instanceof Serializable) {
                try {
                    object = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                    objectOutputStream.writeObject(object2);
                    objectOutputStream.flush();
                    this.pbuf.buffer.put(((ByteArrayOutputStream)object).toByteArray());
                }
                catch (IOException iOException) {
                    Netzack.debug(iOException);
                }
                continue;
            }
            Netzack.debug("Trying to send unsupported data: " + object2.toString());
        }
        this.pbuf.buffer.limit(this.pbuf.buffer.position());
        this.pbuf.buffer.rewind();
    }

    public Message readMessage() {
        return Message.generate(this.pbuf.buffer.getChar());
    }

    public int readInt() {
        return this.pbuf.buffer.getInt();
    }

    public boolean readBoolean() {
        byte by = this.pbuf.buffer.get();
        return by == 1;
    }

    public double readDouble() {
        return this.pbuf.buffer.getDouble();
    }

    public String readString() {
        CharBuffer charBuffer = this.pbuf.buffer.asCharBuffer();
        return charBuffer.toString();
    }

    public Object readObject() {
        if (this.pbuf.buffer.remaining() > 0) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pbuf.buffer.array(), this.pbuf.buffer.position(), this.pbuf.buffer.remaining());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject();
            }
            catch (IOException iOException) {
                Netzack.debug(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Netzack.debug(classNotFoundException);
            }
        }
        return null;
    }

    public DatagramPacket receive(DatagramSocket datagramSocket) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.pbuf.buffer.array(), this.pbuf.buffer.limit());
        datagramSocket.receive(datagramPacket);
        this.pbuf.buffer.rewind();
        this.msg = this.readMessage();
        return datagramPacket;
    }

    public boolean receive(Peer peer, Socket socket) throws IOException {
        int n;
        InputStream inputStream = socket.getInputStream();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            if ((n2 += inputStream.read(byteBuffer.array(), n2, 4 - n2)) == -1) {
                return false;
            }
            if (n2 == 4) break;
        }
        if (n2 != 4) {
            throw new IOException();
        }
        n = byteBuffer.getInt();
        if (n <= 0) {
            return false;
        }
        n2 = 0;
        for (int i = 0; i < 3; ++i) {
            if ((n2 += inputStream.read(this.pbuf.buffer.array(), n2, n - n2)) == -1) {
                return false;
            }
            if (n2 == n) break;
        }
        this.pbuf.buffer.rewind();
        this.pbuf.buffer.limit(n);
        this.msg = this.readMessage();
        this.from = peer;
        return true;
    }

    public void dispatch(Server server) {
        this.pbuf.buffer.rewind();
        server.dispatch(this);
    }

    public void send(Socket socket) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        byte[] byArray = this.pbuf.buffer.array();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(this.pbuf.buffer.limit());
        outputStream.write(byteBuffer.array());
        outputStream.write(byArray, 0, this.pbuf.buffer.limit());
        outputStream.flush();
    }

    public void send(DatagramSocket datagramSocket) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.pbuf.buffer.array(), this.pbuf.buffer.limit(), Server.GROUP, Server.PUBLIC_PORT);
        datagramSocket.send(datagramPacket);
    }

    public void send(DatagramSocket datagramSocket, SocketAddress socketAddress) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.pbuf.buffer.array(), this.pbuf.buffer.limit(), socketAddress);
        datagramSocket.send(datagramPacket);
    }

    public void release() {
        this.pbuf.release();
    }

    public boolean isFrom(Peer peer) {
        return this.from == peer;
    }

    public void from(Peer peer) {
        this.from = peer;
    }

    public void message(Message message) {
        this.msg = message;
    }

    protected void finalize() {
        this.pbuf.release();
    }

    public Peer getFrom() {
        return this.from;
    }

    public Message getMsg() {
        return this.msg;
    }

    static Packet dirPacket(int n, Direction direction, double d, double d2, double d3) {
        return new Packet(null, Message.DIR, new Object[]{new Integer(n), direction, new Double(d), new Double(d2), new Double(d3)});
    }

    static Packet posPacket(int n, int n2, int n3, double d, int n4, int n5, String string) {
        return new Packet(null, Message.POS, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Double(d), new Integer(n4), new Integer(n5), string});
    }

    static Packet echoPacket() {
        return new Packet(null, Message.ECHO, new Object[0]);
    }

    static Packet echoPacket(int n, boolean bl) {
        return new Packet(null, Message.ECHO, new Object[]{new Integer(n), new Boolean(bl)});
    }

    static Packet echoPacket(int n, byte[] byArray) {
        return new Packet(null, Message.ECHO, new Object[]{new Integer(n), byArray});
    }

    static Packet helloPacket(int n) {
        return new Packet(null, Message.HELLO, new Object[]{new Integer(n)});
    }

    static Packet reconnectPacket(int n, int n2, int n3, byte[] byArray) {
        return new Packet(null, Message.RECONNECT, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), byArray});
    }

    static Packet reconnectPacket(int n, int n2) {
        return new Packet(null, Message.RECONNECT, new Object[]{new Integer(n), new Integer(n2)});
    }

    static Packet idPacket(int n, int n2) {
        return new Packet(null, Message.ID, new Object[]{new Integer(n), new Integer(n2)});
    }

    static Packet roundPacket(int n, boolean bl) {
        return new Packet(null, Message.ROUND, new Object[]{new Integer(n), new Boolean(bl)});
    }

    static Packet loopPacket() {
        return new Packet(null, Message.LOOP, new Object[0]);
    }
}

