/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import se.kth.netzack.Message;
import se.kth.netzack.Netzack;
import se.kth.netzack.Packet;
import se.kth.netzack.Server;

public class Peer
extends Thread {
    Socket socket;
    Server server;
    int id;
    int tries;

    private /* synthetic */ void finit$() {
        this.id = 0;
        this.tries = 0;
    }

    Peer(Socket socket, Server server) {
        this.finit$();
        this.server = server;
        this.socket = socket;
        this.start();
    }

    public void run() {
        Packet packet = new Packet();
        boolean bl = true;
        try {
            while (packet.receive(this, this.socket)) {
                Message message = packet.getMsg();
                if (message.equals(Message.HELLO)) {
                    this.id = this.server.generateId();
                    Packet packet2 = Packet.idPacket(this.id, this.server.id);
                    this.send(packet2);
                    this.server.peerConnected(this.id);
                    continue;
                }
                if (message.equals(Message.ID)) {
                    int n = packet.readInt();
                    this.id = packet.readInt();
                    this.server.id = n;
                    this.server.game.thisIsMe(n);
                    continue;
                }
                if (message.equals(Message.RECONNECT)) {
                    this.id = packet.readInt();
                    int n = packet.readInt();
                    if (n == 0) continue;
                    this.server.reconnected(n);
                    Packet packet3 = Packet.reconnectPacket(this.server.id, 0);
                    this.send(packet3);
                    continue;
                }
                if (message.equals(Message.LOOP)) {
                    Netzack.debug("Peer #" + this.id + " closed connection to prevent loop.");
                    bl = false;
                    break;
                }
                if (packet.readInt() == this.server.id) {
                    Netzack.debug("Closing peer #" + this.id + " to prevent loop.");
                    this.send(Packet.loopPacket());
                    bl = false;
                    break;
                }
                packet.dispatch(this.server);
            }
        }
        catch (IOException iOException) {
            Netzack.debug(iOException);
        }
        packet.release();
        this.close();
        Netzack.debug("Peer #" + this.id + " quit.");
        this.server.peerQuit(this.id, bl);
    }

    protected void finalize() throws Throwable {
        try {
            this.socket.close();
        }
        finally {
            Object var1_1 = null;
            super.finalize();
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            Netzack.debug(iOException);
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean send(Packet packet) {
        if (this.socket.isConnected()) {
            try {
                packet.send(this.socket);
                return true;
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {
                Netzack.debug(iOException);
            }
        }
        return false;
    }
}

