/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import se.kth.netzack.Message;
import se.kth.netzack.Netzack;
import se.kth.netzack.Packet;
import se.kth.netzack.Server;

public class PrivateChannel
extends Thread {
    DatagramSocket socket;
    boolean initialConnection;
    Server server;
    Object lock;

    private /* synthetic */ void finit$() {
        this.initialConnection = false;
    }

    PrivateChannel(Server server, Object object) {
        super("PrivateChannel");
        this.finit$();
        this.lock = object;
        try {
            this.socket = new DatagramSocket();
        }
        catch (IOException iOException) {
            Netzack.error(iOException);
        }
        this.server = server;
        this.start();
    }

    protected void finalize() throws Throwable {
        try {
            this.socket.close();
        }
        finally {
            Object var1_1 = null;
            super.finalize();
        }
    }

    public void run() {
        if (!this.socket.isBound()) {
            Netzack.debug("Premature exit: PrivateChannel thread");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Packet packet;
            try {
                this.lock.notify();
            }
            finally {
                packet = null;
            }
            try {
                while (true) {
                    packet = new Packet();
                    DatagramPacket datagramPacket = packet.receive(this.socket);
                    Message message = packet.getMsg();
                    if (message.equals(Message.ECHO)) {
                        ++this.server.echos;
                        if (!this.initialConnection) {
                            this.initialConnection = true;
                            int n = packet.readInt();
                            byte[] byArray = (byte[])packet.readObject();
                            InetAddress inetAddress = InetAddress.getByAddress(byArray);
                            if (inetAddress != null) {
                                this.server.connect(inetAddress, n);
                            }
                        }
                    }
                    packet.release();
                }
            }
            catch (IOException iOException) {
                Netzack.debug(iOException);
                return;
            }
        }
    }

    public void send(Packet packet) {
        try {
            packet.send(this.socket);
        }
        catch (IOException iOException) {
            Netzack.debug(iOException);
        }
    }

    public void send(Packet packet, SocketAddress socketAddress) {
        try {
            packet.send(this.socket, socketAddress);
        }
        catch (IOException iOException) {
            Netzack.debug(iOException);
        }
    }
}

