/*
 * Decompiled with CFR 0.152.
 */
package se.kth.netzack;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.kth.netzack.Game;
import se.kth.netzack.Message;
import se.kth.netzack.Netzack;
import se.kth.netzack.Packet;
import se.kth.netzack.PacketBuffer;
import se.kth.netzack.PacketListener;
import se.kth.netzack.PeerListener;
import se.kth.netzack.PublicChannel;
import se.kth.netzack.ServerThread;

public class Server {
    Game game;
    public static InetAddress GROUP;
    public static int PUBLIC_PORT;
    public static InetAddress localAddress;
    public int id;
    public int echos;
    PublicChannel pub;
    ServerThread server;
    private Vector packetListeners;
    private Vector peerListeners;
    public static final List packetBuffers;

    private /* synthetic */ void finit$() {
        this.id = 0;
        this.echos = 0;
        this.packetListeners = new Vector(5);
        this.peerListeners = new Vector(5);
    }

    Server(Game game, String string, int n) {
        InetAddress inetAddress;
        Object object;
        Object object2;
        this.finit$();
        PUBLIC_PORT = n;
        try {
            GROUP = InetAddress.getByName(string);
            object2 = NetworkInterface.getNetworkInterfaces();
            block10: while (object2.hasMoreElements()) {
                object = object2.nextElement().getInetAddresses();
                while (object.hasMoreElements()) {
                    inetAddress = (InetAddress)object.nextElement();
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) continue;
                    localAddress = inetAddress;
                    continue block10;
                }
            }
        }
        catch (SocketException socketException) {
            Netzack.debug(socketException);
        }
        catch (UnknownHostException unknownHostException) {
            Netzack.debug(unknownHostException);
        }
        this.game = game;
        if (localAddress == null) {
            Netzack.error("Couldn't find local address");
        }
        object = object2 = new Object();
        synchronized (object) {
            try {
                this.pub = new PublicChannel(this, object2);
                try {
                    object2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.server = new ServerThread(this, object2);
                try {
                    object2.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                inetAddress = null;
            }
            catch (Throwable throwable) {
                inetAddress = null;
                throw throwable;
            }
        }
    }

    public void peerConnected(int n) {
        this.dispatchPeerConnected(n);
    }

    public void peerQuit(int n, boolean bl) {
        if (bl) {
            this.server.checkConnections();
            this.dispatchPeerQuit(n);
        } else {
            this.server.reconnected(n);
        }
    }

    public void reconnect(int n, InetAddress inetAddress, int n2) {
        this.server.reconnect(n, inetAddress, n2);
    }

    public void reconnected(int n) {
        this.server.reconnected(n);
    }

    public void reestablish(int n) {
        Netzack.debug("Trying reestablish connection to #" + n + "'s peers.");
        this.pub.send(Packet.reconnectPacket(this.id, n, this.getPort(), localAddress.getAddress()));
    }

    public void play() {
        this.echos = 0;
        this.pub.send(Packet.echoPacket(this.id, true));
        try {
            Thread.sleep(1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.echos == 0) {
            Netzack.verbose("Starting game...");
            this.id = 1;
            this.game.thisIsMe(this.id);
            this.game.newRound();
        } else {
            Netzack.verbose("Joining game...");
            this.game.alone = false;
        }
    }

    public void addPacketListener(PacketListener packetListener) {
        this.packetListeners.add(packetListener);
    }

    public void dispatch(Packet packet) {
        if (packet.getMsg() == Message.NONE) {
            return;
        }
        this.server.dispatch(packet);
        packet.readMessage();
        Iterator iterator = this.packetListeners.iterator();
        while (iterator.hasNext()) {
            PacketListener packetListener = (PacketListener)iterator.next();
            packetListener.gotPacket(this, packet);
        }
        packet.release();
    }

    public void addPeerListener(PeerListener peerListener) {
        this.peerListeners.add(peerListener);
    }

    public void dispatchPeerQuit(int n) {
        Iterator iterator = this.peerListeners.iterator();
        while (iterator.hasNext()) {
            PeerListener peerListener = (PeerListener)iterator.next();
            peerListener.peerQuit(n);
        }
    }

    public void dispatchPeerConnected(int n) {
        Iterator iterator = this.peerListeners.iterator();
        while (iterator.hasNext()) {
            PeerListener peerListener = (PeerListener)iterator.next();
            peerListener.peerConnected(n);
        }
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void connect(InetAddress inetAddress, int n) {
        this.server.connect(inetAddress, n);
        if (this.id == 0) {
            this.send(Packet.helloPacket(this.id));
        }
    }

    public static PacketBuffer getPacketBuffer() {
        return Server.getPacketBuffer(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PacketBuffer getPacketBuffer(boolean bl) {
        List list = packetBuffers;
        synchronized (list) {
            try {
                Iterator iterator = packetBuffers.iterator();
                while (iterator.hasNext()) {
                    PacketBuffer packetBuffer = (PacketBuffer)iterator.next();
                    if (packetBuffer.ref > 0) continue;
                    packetBuffer.buffer.clear();
                    packetBuffer.addRef();
                    return packetBuffer;
                }
                if (!bl) {
                    Runtime runtime = Runtime.getRuntime();
                    runtime.gc();
                    return Server.getPacketBuffer(true);
                }
                packetBuffers.add(new PacketBuffer());
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                throw throwable;
            }
            Object var6_9 = null;
            return Server.getPacketBuffer(true);
        }
    }

    public int generateId() {
        return this.game.generateId();
    }

    public int peers() {
        this.echos = 0;
        this.pub.send(Packet.echoPacket(this.id, false));
        try {
            Thread.sleep(1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.echos;
    }

    public void send(Packet packet) {
        this.server.send(packet);
        packet.release();
    }

    public void send(Message message, Object[] objectArray) {
        Packet packet = new Packet(null, message, objectArray);
        this.server.send(packet);
        packet.release();
    }

    static {
        packetBuffers = Collections.synchronizedList(new ArrayList(10));
    }
}

