#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from qt import *

# states
ACTIVATED    = "on"
DESACTIVATED = "off"
DISABLED     = "disabled"

class StateError(KeyError) : pass

class PixmapSet:
    def __init__(self):
        self.pixmaps = {}

    def addState(self, pixmap, state):
        if self.pixmaps.has_key(state):
            raise StateError("State already present")
        self.pixmaps[state] = pixmap
        self.cropState(state)

    def getState(self, state):
        if not self.pixmaps.has_key(state):
            raise StateError("State not present")
        return self.pixmaps[state]
    
    def cropState(self, state):
        curPixmap = self.pixmaps[state]
        curMask = curPixmap.createHeuristicMask()
        curRect = QRegion(curMask).boundingRect()
        pixmap = QPixmap(curRect.width(), curRect.height())
        bitBlt( pixmap,
                0,
                0,
                curPixmap,
                curRect.x(),
                curRect.y(),
                curRect.width(),
                curRect.height(),
                Qt.CopyROP,
                1 )
        pixmap.setMask(pixmap.createHeuristicMask())
        self.pixmaps[state] = pixmap
        
        
        
