#!/usr/bin/python
import unittest
import os
from testsPath import *
from OBBApp.SimpleApp import SimpleApp
from qt import *
import sys
import thread

class appInstanciationTest(unittest.TestCase):
    """appInstanciationTest : test if app can be instanciated."""
    def runTest(self):
        app = SimpleApp()
        self.failUnless( app != None )

class appCloseNoticeTest(unittest.TestCase):
    """appCloseNoticeTest :
    test if app send the proper message when closing."""
    def runTest(self):
        self.notified = 0
        app = SimpleApp()
        QObject.connect( app,
                         PYSIGNAL("aboutToQuit()"),
                         self.prepareToClose )
        del(app)
        self.failUnless(self.notified)

    def prepareToClose(self):
        self.notified = 1

class appCloseUnNoticeTest(unittest.TestCase):
    """appCloseUnNoticeTest :
    test if app fail to send the message when disconnected."""
    def runTest(self):
        self.notified = 0
        app = SimpleApp()
        QObject.connect( app,
                         PYSIGNAL("aboutToQuit()"),
                         self.prepareToClose )
        del(app)
        self.failUnless(self.notified)
        
        self.notified = 0
        app = SimpleApp()
        QObject.disconnect( app,
                            PYSIGNAL("aboutToQuit()"),
                            self.prepareToClose )
        del(app)
        self.failUnless(not self.notified)        


    def prepareToClose(self):
        self.notified = 1


def suite():
    testSuite = unittest.TestSuite()
    testSuite.addTest(appInstanciationTest())
    testSuite.addTest(appCloseNoticeTest())
    testSuite.addTest(appCloseUnNoticeTest())
    return testSuite
