#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from qt import *
from OBBFrame import OBBFrame
from PixmapSet import *

class StretchFrame(OBBFrame):
    def __init__( self,
                  pixmapSet,
                  parent=None,
                  x=0,
                  y=0,
                  orientation="x",
                  stretchPoint=30,
                  stretchSize=50,
                  wantedSize=100 ):
        # replace the PixmapSet with the stretched version
        newSet = self.stretchPixSet( pixmapSet,
                                     orientation,
                                     stretchPoint,
                                     stretchSize,
                                     wantedSize )
        OBBFrame.__init__(self, newSet, parent, x, y)

    def stretchPixSet( self,
                       pixmapSet,
                       orientation,
                       stretchPoint,
                       stretchSize,
                       wantedSize ):
        oldPix = pixmapSet.getState(DISABLED)

        # TODO : adjust size acording to orientation
        newSize = oldPix.width()
        while (newSize <= wantedSize):
            newSize += stretchSize
        newSize -= stretchSize

        newPix = QPixmap( newSize,
                          oldPix.height(),
                          oldPix.depth(),
                          oldPix.optimization() )
        stretchFactor = (newSize - oldPix.width()) / stretchSize

        bitBlt( newPix,
                0, 0,
                oldPix,
                0, 0,
                stretchPoint, oldPix.height(),
                Qt.CopyROP,
                1 )
        for i in range(stretchFactor):
            bitBlt( newPix,
                stretchPoint + stretchSize*i, 0,
                oldPix,
                stretchPoint, 0,
                stretchSize, oldPix.height(),
                Qt.CopyROP,
                1 )
        bitBlt( newPix,
                stretchPoint + stretchSize*stretchFactor, 0,
                oldPix,
                stretchPoint, 0,
                oldPix.width() - stretchPoint,
                oldPix.height(),
                Qt.CopyROP, 1 )

        newSet = PixmapSet()
        newSet.addState(newPix, DISABLED)
        return newSet
