#!/usr/bin/python

#   Copyright (C) 2002-2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002-2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


"""OBBFuncts : generic utility functions for the OBB system"""

from qt import *
import os
from sys import platform
from OBBDebugger import *

IMG_DIR  = "images"
PAT_DIR  = "patterns"
SND_DIR  = "sounds"
SKIN_DIR = "skins"

def pointOffset(pointA, pointB):
    """pointOffset : returns a point resulting of pointA - pointB"""
    offset = QPoint( (pointA.x() - pointB.x()),
                     (pointA.y() - pointB.y()) )
    return offset

def subPoints(pointA, pointB):
    """subPoints : substract pointB from pointA in place"""
    pointA.setX(pointA.x() - pointB.x())
    pointA.setY(pointA.y() - pointB.y())

def addOffset(point, offset):
    """addOffset : add offset to point"""
    newPoint = QPoint( point.x() + offset.x(),
                       point.y() + offset.y() )
    return newPoint

def getMagnitude(offset):
    """getMagnitude : Returns a fast magnitude aproximation."""
    magnitude = abs(offset.x()) + abs(offset.y())
    return magnitude

def escapeKey(key):
    """escapeKey : Basic space to underscore substitution to enable
                   labels to be XML tags."""
    return key.replace( " ", "_" )

def unescapeKey(key):
    """escapeKey : Basic underscore to space substitution to enable
                   XML tags to be labels."""
    return key.replace( "_", " " )

def printRect(rect):
    """printRect : Print a QRect in the console for debuging."""
    printPoint(rect.topLeft())
    print "w:%d h:%d" % (rect.width(), rect.height())

def printPoint(point):
    """printPoint : Print a QPoint in the console for debuging."""
    print "(%d, %d)" % (point.x(), point.y())

def fullBlit(dst, src):
    """fullBlit : bitBlt() src in dst starting at (0, 0) """
    bitBlt(dst, 0, 0, src)

def getImgDir():
    dir = os.path.join(os.curdir, IMG_DIR)
    if os.path.exists(dir):
        return dir
        
    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    raise Exception("No Images Found !")


def getPatDir():
    dir = os.path.join(os.curdir, PAT_DIR)
    if os.path.exists(dir):
        return dir
        
    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    raise Exception("No Patterns Found !")


def getSndDir():
    dir = os.path.join(os.curdir, SND_DIR)
    if os.path.exists(dir):
        return dir
        
    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    raise Exception("No Sounds Found !")


def getSkinDir():
    dir = os.path.join(os.curdir, SKIN_DIR)
    if os.path.exists(dir):
        return dir
        
    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    dir = os.path.join(os.pardir, dir)
    if os.path.exists(dir):
        return dir

    raise Exception("No Skins Found !")


def kickApp(app):
    """ kickApp : kick a QApplication that has not been exec_loop()ed yet"""
    quitTimer = QTimer()
    QObject.connect( quitTimer,
                     SIGNAL("timeout()"),
                     app.quit )
    quitTimer.start(1)
    app.exec_loop()

def debug(msg):
    OBBDebugger().debug(msg)
    
def formatPath(path, doubleBackSlash = 0):
    path = os.path.normpath(os.path.normcase(path))
    if platform == "win32":
        if doubleBackSlash:
            path = path.replace("\\", "\\\\")
    else:
        path = path.replace("\\", "/")
    
    return path
