/************************************************************************
 *                                                                      *
 * OFE - OFE ForEver - ncurses file editor for GNU/Linux                *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski, Marcus vA     *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

/* background stuff for file operations, this should not leave the ofe! */

#include <ncurses.h>
#include <string.h>
#include <stdlib.h>
#include "file.h"

/* maximum length of lines -> buffer maybe use $COLS */
#define LENGTH 78

/* the first line of all */
contentPtr first_line = NULL;
contentPtr next = NULL;
contentPtr last_line = NULL;

contentPtr 
read_file(char *filename)
{
  /* variables */
  char buf[LENGTH + 1];
  FILE* stream;
  contentPtr new = NULL, tmp = NULL;

  /* is there a file, which can be opened? */
  if ((stream = fopen(filename, "r")) == NULL)
    {
      printf("Argh, no file found! Returning.\n");
      return NULL;
    }
    
  while ( ! feof (stream))
    {
      /* get LENGTH chars and put them in buf */
      fgets (buf, LENGTH, stream);
      
      /* does the first one already exist? */
      if (first_line == NULL)
	{
	  if ((first_line = (content *) malloc (sizeof (content))) == NULL)
	    {
	      printf ("Memory could not be allocated for first element - exiting...\n");
	      return NULL;
	    }
	  /* now we have to store it in a _first_ struct for display */
	  first_line->line_number = 0;
	  first_line->text = (char *) malloc (sizeof (buf));
	  strncpy (first_line->text, buf, strlen (buf));
	  
	  first_line->next = NULL;
	  last_line = first_line;
	  last_line->prev = NULL;
	}
      else
	{
	  /* fun with linking the list :-) */
	  new = first_line;
	  /* jump to th last */
	  while (new->next != NULL)
	    {
	      new = new->next;
	    }
	 
	  /* mem allocation for the new one */
	  if ((new->next = (content *) malloc (sizeof (content)))
	      == NULL)
	    {
	      printf (" Memory could not be allocated - exiting...\n");
	      return NULL;
	    }
	  
	  tmp = new;
	  
	  /* ok, got it, now fill */
	  new = new->next;
	  new->line_number = tmp->line_number + 1;
	  new->text = (char *) malloc (sizeof (buf));
	  strncpy (new->text, buf, strlen (buf));

	  new->next = NULL;
	  last_line = new;
	  new->prev = tmp;
	}
    }
  return first_line;
}
