/************************************************************************
 *                                                                      *
 * OFE - OFE ForEver - ncurses file editor for GNU/Linux                *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski, Marcus vA     *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

/* user interface stuff, window, etc. */

#include "ui.h"

WINDOW*
create_new_win (int wheight, int wwidth, int starty, int startx)
{
  /* variables */
  WINDOW *window;

  /* new window with color*/
  start_color ();
  init_pair(1, COLOR_BLACK, COLOR_BLUE);
   
  window = newwin (wheight, wwidth, starty, startx);
  wattron (window, COLOR_PAIR(1));

  /* create a border and refresh */
  wrefresh (window);

  return window;
}

WINDOW*
create_new_win_with_box (int wheight, int wwidth, int starty, int startx)
{
  WINDOW* window = create_new_win (wheight, wwidth, starty, startx);
  /* draw a box around the new window */
  box (window, 0, 0);
  wrefresh (window);
  return (window);
}

void 
destroy_win (WINDOW* window)
{
  /* destroy the window */
  delwin (window);
  return;
}

