/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

#include <curses.h> /* does not build without it on BSD */
#include <string.h> /* strlen */
#include <stdlib.h>
#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <fcntl.h>
#include "subshell.h"

static pid_t child_pid;
/* static int sub_pipe[2]; */
static int sub_pty, slave_pty;
static struct termios shell_mode;
static int disable_output;

int subshell_run(int switch_key, char *work_dir, char *command)
{
    char buff[100];
    char pty_name[40];
    fd_set read_set;
    int bytes;
    int i;
    struct timeval wtime;
    struct timeval *wptr;
    int status;
    pid_t pid;


    if (child_pid==0) {
	/* looking for terminals */
	i = 0;
	do {
	    sprintf(pty_name,"/dev/ptyp%x",i);
	    sub_pty = open(pty_name, O_RDWR);
	    if ( sub_pty > 0) {
	        pty_name[5] = 't';
		slave_pty = open (pty_name, O_RDWR);
		if (sub_pty > 0 && slave_pty > 0) 
		  break;
		else 
		  close (sub_pty);
		pty_name[5] = 'p';
	    }
	    if (errno == ENOENT && (sub_pty < 0 || slave_pty < 0)) {
		perror ("open");
		fflush (NULL);
		return -1;
	    } 
	    if (i == 0xf && pty_name[8] != 'e') {
		if (pty_name[8] == 'z') pty_name[8] = 'a';
		else pty_name[8]++;
		i = -1;
	    }
	} while (0xf - i++);
    
	if (sub_pty < 0 || slave_pty < 0) {
	    close (sub_pty);
	    close (slave_pty);	    
	    fprintf (stderr, "No pty available.\n");
	    return (-1);		
	}
/*	if (pipe(sub_pipe)) {
	    perror("pipe");
	    fflush(NULL);
	}*/

	tcgetattr (STDOUT_FILENO, &shell_mode);

	child_pid = fork();
	if (child_pid < 0) {
	    perror ("fork");
	    fflush (NULL);
	} else if (child_pid == 0) {      
	    setsid ();
	    slave_pty = open(pty_name, O_RDWR);
	    if (slave_pty < 0) {
		perror ("open");
		exit (0);
	    }
	    close (sub_pty);

#	    ifdef TIOCSCTTY
		ioctl (slave_pty, TIOCSCTTY, 0);
#	    endif
	    
	    shell_mode.c_lflag |= TOSTOP;
	    tcsetattr (slave_pty, TCSANOW, &shell_mode);
	    
	    putenv ("HISTCONTROL=ignorespace");
	    putenv ("PS1=ofm-sh:\\w$ ");
	    
	    dup2 (slave_pty, STDIN_FILENO);
	    dup2 (slave_pty, STDOUT_FILENO);
	    dup2 (slave_pty, STDERR_FILENO);
/*	    close (sub_pipe[0]); */
	    close (slave_pty);  
	    	    
	    execl ("/bin/sh", "sh", NULL);
	} /* else if (child_pid==0) */

	close (slave_pty);
	pid = waitpid (child_pid, &status, WUNTRACED | WNOHANG);
	write (sub_pty, "cd ", 3);
	write (sub_pty, work_dir, strlen (work_dir));
	write (sub_pty, "\n", 1);
	disable_output=2;


    }	/* if (child_pid==0) */


    shell_mode.c_lflag &= ~ECHO;
    shell_mode.c_lflag &= ~OPOST;
    shell_mode.c_lflag &= ~ICANON;
    shell_mode.c_cc[VTIME] = 0;
    shell_mode.c_cc[VMIN] = 1;
    tcsetattr (STDOUT_FILENO, TCSANOW, &shell_mode);
	
#	if defined TIOCSWINSZ && !defined SCO_FLAVOR
	{
	    struct winsize tty_size;
	    tty_size.ws_row = LINES;
	    tty_size.ws_col = COLS;
	    tty_size.ws_xpixel = tty_size.ws_ypixel = 0;

	    if (ioctl (slave_pty, TIOCSWINSZ, &tty_size))
		perror ("pty resize");
	}
#	endif

    if (command != NULL) {
	write (sub_pty, "cd ", 3);
	write (sub_pty, work_dir, strlen (work_dir));
	write (sub_pty, "\n", 1);
	write (sub_pty,command,strlen (command));
	write (sub_pty,"\n",1);
	disable_output++;
    } else {
	write (sub_pty, "cd .\n", 5);
	disable_output++;
    }
    
    /* setting time for select */
    if (switch_key > 0) {
	wtime.tv_sec = 10;           
	wtime.tv_usec = 0;
    } else {
	wtime.tv_sec = 0;
	wtime.tv_usec = 200;
    }
    wptr = &wtime;

    i = 10;
    while (1) {
        FD_ZERO (&read_set);
        FD_SET (sub_pty, &read_set);
/*        FD_SET (sub_pipe[0], &read_set); */
        if (switch_key > 0) FD_SET (STDIN_FILENO, &read_set);

        if (select (FD_SETSIZE, &read_set, NULL, NULL, wptr)==-1) {    
	    if (errno == EINTR) {
		continue;
	    }
	    tcsetattr (STDOUT_FILENO, TCSANOW, &shell_mode);
	    perror ("select");
	    return (-1);
	}

        if (FD_ISSET (sub_pty, &read_set)) {
	    bytes = read (sub_pty, buff, sizeof(buff));
	    if (bytes == -1) {
    		tcsetattr (STDOUT_FILENO, TCSANOW, &shell_mode);
		perror ("reading from pseudo terminal");
		pid = waitpid (child_pid, &status, WUNTRACED | WNOHANG);
		if (WIFEXITED (status) || WIFSIGNALED (status)) {
		    fprintf (stderr,"Subshell process exited.\n");
		    child_pid=0;
		    close (sub_pty);
/*		    close(sub_pipe[0]);
 *		    close(sub_pipe[1]);
 */
 		}
		if (pid == -1 && errno == ECHILD) {
		    fprintf (stderr,"Subshell process not exists.\n");
		    child_pid = 0;
		}
		return (-1);
	    }
	    if (disable_output == 0) write (STDOUT_FILENO, buff, bytes);
	    else if (buff[bytes-1] == '\n') 
	      disable_output--;
	} /*else if (FD_ISSET (sub_pipe[0], &read_set)) {
		bytes = read (sub_pipe[0], buff, sizeof(buff));
		if (bytes==-1) {
		    perror("reading from pipe");
		    getchar();
		    return (-1);
		}
		if (bytes >= 1)
		    buff[bytes-1] = 0;   
		    write (STDOUT_FILENO, buff, bytes);
		    fflush(stdout);

	}*/ 
	else if (FD_ISSET (STDIN_FILENO, &read_set)) {
	    bytes = read (STDIN_FILENO, buff, sizeof (buff));
	    if (bytes == -1) {
    		tcsetattr (STDOUT_FILENO, TCSANOW, &shell_mode);
		perror ("reading from stdin");		
		return (-1);	    
	    }
	    i=bytes;
	    while (i--) {
		if (switch_key > 0 && buff[i] == switch_key) {
		    write (sub_pty, buff, i);
		    return 0;
		}
	    }
	    write (sub_pty, buff, bytes);
	} 
	else if (switch_key <= 0) 
	    return 0;
	if (switch_key > 0) wptr=NULL;
    }
    return 0;
}

int subshell_execute (char *command)
{
    if (command==NULL) return 0;
    subshell_run(0,"./",command);
/*    write(sub_pty, command, strlen(command));
 *    write(sub_pty, "\n", 1);
 */
    return 0;
}

