/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;

/**
* Cette interface est  implmneter par tous les objets 2d acceptant une lgnde attach  leur reprsentation graphique.
* @author O.C.
* @version 0.11
*/
public interface ILegend
{
/**
* Il faut indiquer dans cette mthode quel motif reprsente la lgende. 
* @param Graphics g, l'instance de Graphics pour dessiner le motif.
* @param int x, y les coordonnes suprieures gauches du cadre contenant le motif dans le repre utilisateur li  la vue courante.
* @param int w, h les dimensions du motif en pixels crans.
* @since Opale 0.11
*/
public void drawLegend(Pen2D c,double x, double y,int w, int h);

/**
* Retourne le texte de la lgende. 
* @return String, le texte.
* @since Opale 0.11
*/
public String getLegend();

/**
* Change le texte de la lgende. 
* @param String, le nouveau texte.
* @since Opale 0.11
*/
public void setLegend(String t);
}
