/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d;
import opale.tools.*;
import opale.m2d.*;
import java.io.*;

/**
* This abstract class represents an abstract model to draw a point. In the package <code>opale.m2d.marktype</code>, there are many subclasses to draw a point for example as a triangle, a rectangular...<br>
This abstract class contains an attribute size to define the size of this marktype : it is possible to acces and change this attribute with the methods <code>getSize()</code> and <code>setSize()</code>
* @since Opale-2d 0.15
* @author O.C.
*/

public abstract class MarkType extends OpaleObject implements  Cloneable
{
protected int marksize;

public MarkType()
	{
	marksize=10;
	}

/**
* Method to be implemented to define a drawing style.
* @param Pen2D, pen to draw
* @param double x, x-coordinate of the point location
* @param double y, y-coordinate of the point location
*/
public abstract void draw(Pen2D c,double x, double y);


/**
* Sets the size of this mark.
* @param int, the size
*/
public void setMarksize(int size)
	{
	marksize = Math.abs(size);
	}
	
/**
* Gets the size of this mark
* @return int, the size
*/
	
public int getMarksize()
	{
	return marksize;
	}
	
/**
* Write size of this MarkType in a stream. This method is inherited from OpaleObject
*/
public void write(PrintWriter f,OpaleSet pack) throws InvalidFormatException
	{
	f.println("{ SIZE "+marksize+" }");
	}

	

public  int readKeyWord(String word, StreamReader f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	int type;
	if ( word.equals("SIZE"))
		{
		marksize = (int) f.nextDouble();
		if (marksize < 0 ) throw new InvalidFormatException("Size must be positive integer !!");
		return 0;
		}
	return -1;
		
	}
	
/**
* Clones this object.
* @return Object a new clone object
* @exception  OutOfMemoryError if not enough memory
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	
		MarkType p = (MarkType) super.clone();
		p.marksize = marksize;
		return p;
		//}
	/*catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError(""+e);
		}*/
	}
	
public String toString() { return "MarkType Size = "+marksize;}
 
public static void main(String[] arg)
	{
	opale.m2d.marktype.ClassicPoint cp = new opale.m2d.marktype.ClassicPoint();
	System.out.println(cp.getMarksize());
	opale.m2d.marktype.ClassicPoint cpp = (opale.m2d.marktype.ClassicPoint)cp.clone();
	cp.setMarksize(3);
	System.out.println(cpp.getMarksize());
	System.out.println(cp.getMarksize());


	System.out.println(cp.getClass().getName());
	}
	    
    
}
