/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;
/**
* This interface provides methods for geometrical transformation.
* @author O.C.
* @since Opale-2d 0.1
*/

public interface Transformable
{

/**
* To translate an object with a specified vector (dx, dy).
* @param double dx,dy, coordinate of the translation vector.
*/
public void translate(double dx,double dy);


/**
* To rotate an object around the origin with a specified angle.
* @param double theta, an angle
*/
public void rotate(double theta);

/**
* To rotate an object with a specified center and a specified angle.
* @param double oriX, double oriY, center coordinates
* @param double theta, an angle
*/
public void rotate(double oriX, double oriY,double theta);

/**
* Transforms the object by a general transform <code>AffineTransform</code>.
* @param AffineTransform, the transform
* @since Opale 2d 0.12
*/
public void transform(AffineTransform2D t);


}