/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;
import opale.m2d.*;
import opale.tools.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
/**
* @since Opale-2d 0.11
*/
public class JFrame2D extends JFrame  
{
private  JMenuBar menuBar1 = new JMenuBar();
private  JMenu menuFile = new JMenu();
private  JMenuItem menuFileExit = new JMenuItem();
private  JMenuItem menuFileClose = new JMenuItem();
private  JMenu menuEdition = new JMenu();
private  JMenuItem menuEditEchelle = new JMenuItem();
private  JMenuItem menuEditAxes = new JMenuItem();
private boolean oijselector = true;
private JPanel2D jp;


/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
*/
public JFrame2D()
	{
	super();
	setTitle(opale.Info.getVersion() +" - JFrame 2d");
	setSize(300,300);
	super.setBackground(Color.white);

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
	
	
	jp = new JPanel2D();
		

	getContentPane().add(jp,"Center");	
		
	}
/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
* @param boolean type, mettre vrai si on veut une barre de menu permettant l'dition des axes et echelles.
*/
public JFrame2D(boolean type)
	{
	super();
	setTitle(opale.Info.getVersion() +" - JFrame 2d");
	setSize(300,300);
	super.setBackground(Color.white);

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
if(type)
 {
 menuBar1 = new JMenuBar();
 menuFile = new JMenu();
 menuFileExit = new JMenuItem();
 menuFileClose = new JMenuItem();
 menuEdition = new JMenu();
 menuEditEchelle = new JMenuItem();	
    menuFile.setText("File");
    menuFileClose.setText("Close");
    menuFileClose.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileClose_actionPerformed(e);
      }
    });
    menuFileExit.setText("Quit");
    menuFileExit.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileExit_actionPerformed(e);
      }
    });

    menuEdition.setText("Edit");
    menuEditEchelle.setText("Scale");
    menuEditEchelle.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        menuEditEchelle_actionPerformed(e);
      }
    });

    menuEditAxes.setText("Axis");
    menuEditAxes.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        menuEditAxes_actionPerformed(e);
      }
    });


    menuFile.add(menuFileClose);
    menuFile.add(menuFileExit);
    menuEdition.add(menuEditEchelle);
    menuEdition.add(menuEditAxes);
    menuBar1.add(menuFile);
    menuBar1.add(menuEdition);
    this.setJMenuBar(menuBar1);

 addKeyListener(new JFrame2DKeyListener(this));


  }

	jp = new JPanel2D();
	getContentPane().add(jp,"Center");	
		
	}
	
/**
* Renvoie la rfrence  l'instance de Pack2D contenu dans l'objet courant Frame2D.
* @return Pack2D, l'instance de Pack2D.
*/
public Pack2D getPack2D()
	{
	return jp.getPack2D();
	}

/**
* Set the instance of Pack2d contained in this class.
* @param Pack2D
* @since Opale-2d 0.17
*/
public void setPack2D(Pack2D p)
	{
	 jp.setPack2D(p);
	}

/**
* Renvoie la rfrence  l'instance de GAxis2D contenu dans l'objet courant JFrame2D.
* @return GAxis2D, l'instance de GAxis2D.
*/
public GAxis2D getAxis()
	{
	return jp.getAxis();
	}
	
/**
* Renvoie la rfrence au systme de coordonnes contenu dans l'objet courant JFrame2D.
* @return CoordSystem, l'instance de CoordSystem.
*/
public CoordSystem getCS()
	{
	return jp.getCS();
	}


  //Opration Fichier | Quitter effectue
private   void fileClose_actionPerformed(ActionEvent e) {
    dispose();
  }
private   void fileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }
private   void menuEditEchelle_actionPerformed(ActionEvent e) { 
  	ScaleEditor2 ech = new ScaleEditor2(this,oijselector);
	ech.show();
	
	}

private  void menuEditAxes_actionPerformed(ActionEvent e) { 
  	JAxisEditor ed = new JAxisEditor(this);
	ed.show();
	
	}

public void withOIJSelector(boolean o)
	{
	oijselector = o;
	}


public void redraw()
{
jp.redraw();
jp.repaint();
}


public JPanel2D getJPanel2D()
{
return jp;
}


}






