/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.mathtools;
import opale.tools.*;

import java.io.*;
import java.util.*;

/**
* This abstract class must be extended to implement an integration method of functions.
* @since Opale-Mathtools 0.18
*/
public  abstract class IntegrationRule
{
/**
* This value represents the precision of the solution.
*/
//public double PRECISION = 1.e-6;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
//public int MAXITERATION = 20;

/**
* This value indicates the number of interval to be used to estimate the sum.
*/ 
//public int NIINTERVAL=20;


/**
* Evaluate the sum of a specified function between limits  a and b.
* @param IyFx f, a function.
* @param double a, b, limits of integration interval.
* @param int ni, this value indicates the number of interval to be used to estimate the sum.
* @return double, the result.
*/ 
public abstract double integrate(IyFx f, double a, double b, int ni) ;

}
