/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */


package opale.ode;

import opale.mathtools.*;
import opale.tools.*;
import java.io.*;

/**
* This class inherites from StepSizeControl class and defines a standard step size control.
* @since Opale-ODE 0.15
*/
public final class StandardStepControl extends StepsizeControl
{
private double tol;

/**
* 
*/
public StandardStepControl()
	{
	super();
	tol = 1e-3;
	}
	
public StandardStepControl(TimeScheme ts)
	{
	super(ts);
	tol = 1e-3;
	}
	
public StandardStepControl(double tol)
	{
	if (tol<0) throw new IllegalArgumentException("The tolerance must be positive.");
	this.tol = tol;
	}
	
/**
* Update the step. 
*/
public final boolean update() 
	{
	double eps = getTS().errorEstimate();
	//Debug.print ("epsilon = "+eps);
	if ( eps > 1.2*tol) 
		{
	//Debug.print ("tol/eps = "+tol/eps);
		double newdt = getTS().dt()*Math.sqrt(0.9*tol/eps);
		getTS().dt(newdt);
		return false;
		}
	return true;
	}
	
public int readKeyWord(String word,StreamReader f,OpaleSet ode)   throws java.io.IOException, InvalidFormatException
	 {
	 int i;
	 if ( word.equals("tol"))
		 {
		 tol = f.nextDouble();
		 return 0;
		 }
	 return -1;
	 }


 public void write(PrintWriter f, OpaleSet ode)
	 {
	 f.println("{");
	 f.println("tol "+tol);
	 f.println("}");
	 }
}
