/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */


package opale.tools;
import java.util.*;
import java.io.*;


/**
* This class contains methods to run one test case or all test cases.
* @date 03/03/2001
* @author O.C.
* @since Opale-Tools 0.12
*/

public class ORunTest
{
private static String separator = System.getProperty("file.separator");
private static String OPALE_DIR;
private static int NTEST=0;
private static int NGOOD=0;
private static Vector nosuccessful=new Vector();
private static java.io.PrintStream TestERR;
private static java.io.PrintStream TestOUT;
private static WFile TestLOG;

private static ListOfTest[] list;
/**
* Extract all tests files.
*/
private static void find_alltests()
	{
	Vector list_temp = new Vector();
	File f = new File(OPALE_DIR+separator+"otests"+separator);
	String[] li = f.list();
	for (int i=0;i<li.length;i++)
		{
		ListOfTest temp;
		File f2 = new File(OPALE_DIR+separator+"otests"+separator+li[i]);
		if (f2.isDirectory()) 
			{
			list_temp.add(temp = new ListOfTest(li[i]));
			String[] lis_test = f2.list();
			for (int j=0;j<lis_test.length;j++)
				{
				temp.add(lis_test[j]);
				NTEST++;
				}
			}
		}
	Object[] aaa = list_temp.toArray();	
	list = new ListOfTest[aaa.length];
	for (int i=0;i<list.length;i++)
		list[i] = (ListOfTest) aaa[i];
	}
	
/**
* Run all tests.
*/
private static void runalltest()
	{
	for (int i=0;i<list.length;i++)
		{
		TestLOG.println("\n******************");
		TestLOG.println(list[i].name_mod);
		TestLOG.println("******************\n");
		for (int j=0;j<list[i].name_tests.size();j++)
			{
			ORunTest.runtest((String) list[i].name_mod,(String)list[i].name_tests.get(j));
			}
		}
	
	}
	

/**
* Run the specified test 'nomtest' in the package 'paquet'.
* @param String paquet, the directory that contains the test
* @param String nomtest, the name of the test
*/
private static void runtest(String paquet, String nomtest) 
	{
	String resu;
	try
	{
	
	TestLOG.print("-->>>> "+nomtest+" ");

	String PATH=OPALE_DIR+separator+"otests"+separator+paquet+separator+nomtest+separator;
	Class tes = Class.forName("otests."+paquet+"."+nomtest+"."+nomtest);
	OTest thetest = (OTest) tes.newInstance();
	TestOUT.println(">>>>>>>>>>>>>>Test case : "+ "otests."+paquet+"."+nomtest+"."+nomtest);
	TestERR.println(">>>>>>>>>>>>>>Test case : "+ "otests."+paquet+"."+nomtest+"."+nomtest);
	thetest.run(PATH);
	thetest.stop();
	
	resu =" OK !";
	}
	catch (Exception evt)
		{
		TestLOG.println(" fails !\n"+evt);
		NGOOD--;
		nosuccessful.add("otests."+paquet+"."+nomtest);
		resu = "";
		}
	catch (Error evt)
		{
		TestLOG.println(" fails !\n"+evt);
		NGOOD--;
		nosuccessful.add("otests."+paquet+"."+nomtest);
		resu = "";
		}
	TestLOG.println(resu);
	NGOOD++;
	}
	
private static int chooseTest()
	{
	String resu;
	int cpt=0;
	for (int i=0;i<list.length;i++)
		{
		Stdio.println("\n>> Module "+list[i].name_mod);
		for (int j=0;j<list[i].name_tests.size();j++)
			{
			Stdio.println((++cpt)+"- "+list[i].name_tests.get(j));
			}
			
		}
	Stdio.println("\n0- All tests");
	int choice = Stdio.inputInt("\nChoose a test ?\n");


	System.setErr(TestERR);
	System.setOut(TestOUT);
	TestLOG.println("=================\n OPALE TESTS \n================= \n");


	if (choice == 0)
		{
		runalltest();
		}
	else if (choice > 0 && choice <= NTEST)
		{
		String paquet ="", nomtest="";
		cpt = 0;
		for (int i=0;i<list.length;i++)
			{
			for (int j=0;j<list[i].name_tests.size();j++)
				{
				if (++cpt == choice) 
					{
					paquet = (String) list[i].name_mod;
					nomtest = (String)list[i].name_tests.get(j);
					runtest(paquet, nomtest);
					TestLOG.println("\n=================\n End Of Tests \n================= \n");
					return choice;
					}
				}
			
			}
		}
	else
		{
		choice = -1;
		}
	TestLOG.println("\n=================\n End Of Tests \n================= \n");

	
	return choice;
	}

	
public static void  main(String[] arg)
	{
	try{
	PrintStream old_out = System.out;
	PrintStream old_err = System.err;
	OPALE_DIR=System.getProperty("OPALE_DIR");
	if (OPALE_DIR==null) 
		{
		System.err.println("OPALE_DIR NOT INITIALIZED !!");
		System.exit(-1);
		}

 	ORunTest.find_alltests();



	TestERR = new PrintStream(new FileOutputStream(OPALE_DIR+separator+"otests"+separator+"Test.err"));
	TestOUT = new PrintStream(new FileOutputStream(OPALE_DIR+separator+"otests"+separator+"Test.out"));
	TestLOG = new WFile(OPALE_DIR+separator+"otests"+separator+"Test.log");
	
	int choice = chooseTest();


	System.setOut(old_out);
	System.setOut(old_err);
	TestLOG.close();


	if (choice == 0)  System.out.println("\n Successful cases : "+NGOOD+"/"+NTEST);
	System.exit(-1);
	
	}
	catch (FileNotFoundException evt)
		{
		}
	catch (IOException evt)
		{
		}
		
	}
	
	
	
}

class ListOfTest
{
String name_mod;
Vector name_tests;

ListOfTest(String name_mod)
	{
	this.name_mod = name_mod;
	name_tests = new Vector();
	}
	
void add(String test)
	{
	name_tests.add(test);
	}
}
